<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnToRevenueTargetsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
            $table->unsignedInteger('organization_id')
                ->after('id');

            $table->foreign('organization_id')
                ->references('id')
                ->on('organization')
                ->onUpdate('CASCADE')
                ->onDelete('CASCADE');

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('revenue__targets', function(Blueprint $table)
		{
			$table->dropForeign('revenue__targets_organization_id_foreign');
            $table->dropColumn('organization_id');
		});
	}

}
