<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsToCountriesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('countries', function(Blueprint $table)
		{
            $table->integer('area')->nullable()->after('region_id');
            $table->integer('population')->nullable()->after('area');
            $table->float('population_density')->nullable()->after('population');
			$table->float('latitude', 10, 6)->nullable()->after('population_density');
			$table->float('longitude', 10, 6)->nullable()->after('latitude');

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('countries', function(Blueprint $table)
		{
			$table->dropColumn(['latitude', 'longitude','area', 'population', 'population_density']);
		});
	}

}
