<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRevenueTargetsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('revenue__targets', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('type_id');
            $table->unsignedInteger('currency_id')->nullable();
            $table->unsignedInteger('target_id')->nullable();
            $table->date('period_from');
            $table->date('period_to');
            $table->integer('target')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('type_id')
                ->references('id')
                ->on('report__type')
                ->onUpdate('CASCADE')
                ->onDelete('CASCADE');

           $table->foreign('currency_id')
                ->references('id')
                ->on('currency')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

           $table->foreign('target_id')
                ->references('id')
                ->on('revenue__targets')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('revenue__targets');
	}

}
