<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersIndicatorsDetailsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users__indicators_details', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('user_indicator_id')->nullable();
            $table->unsignedInteger('country_id')->nullable();
            $table->unsignedInteger('wb_income_level_id')->nullable();
            $table->unsignedInteger('wb_region_id')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('user_indicator_id')
                ->references('id')
                ->on('users__indicators')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('country_id')
                ->references('id')
                ->on('countries')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('wb_income_level_id')
                ->references('id')
                ->on('world_bank__income_levels')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('wb_region_id')
                ->references('id')
                ->on('world_bank__regions')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users__indicators_details');
	}

}
