<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersIndicatorsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users__indicators', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('user_id')->nullable();
            $table->unsignedInteger('indicator_id')->nullable();
            $table->unsignedInteger('indicator_category_id')->nullable();

            $table->integer('period_from')->nullable();
            $table->integer('period_to')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('indicator_id')
                ->references('id')
                ->on('indicators')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('indicator_category_id')
                ->references('id')
                ->on('indicators__category')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users__indicators');
	}

}
