<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateIndicatorsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('indicators', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('category_id')->nullable();
            $table->string('series_code')->nullable();
            $table->string('dataset')->nullable();
            $table->string('indicator_name')->nullable();
            $table->text('short_definition')->nullable();
            $table->text('long_definition')->nullable();
            $table->string('unit_of_measure')->nullable();
            $table->string('power_code')->nullable();
            $table->string('periodicity')->nullable();
            $table->string('base_period')->nullable();
            $table->string('reference_period')->nullable();
            $table->string('other_notes')->nullable();
            $table->string('derivation_method')->nullable();
            $table->string('aggregation_method')->nullable();
            $table->text('limitations_and_exceptions')->nullable();
            $table->text('notes_from_original_source')->nullable();
            $table->text('general_comments')->nullable();
            $table->text('source')->nullable();
            $table->string('data_quality')->nullable();
            $table->text('statistical_concept_and_methodology')->nullable();
            $table->text('development_relevance')->nullable();
            $table->text('related_source_links')->nullable();
            $table->string('other_web_links')->nullable();
            $table->string('related_indicators')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('category_id')
                ->references('id')
                ->on('indicators__category')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('indicators');
	}

}
