<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropLevelUniquenessFromOrganizationLevelTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('organization__level', function(Blueprint $table)
		{
			$table->dropUnique('organization__level_level_unique');
            $table->unique(['level', 'structure_department_id'], 'organization__level_level_structure_department_id_unique');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('organization__level', function(Blueprint $table)
		{
            $table->dropUnique('organization__level_level_structure_department_id_unique');
			$table->unique('level');
		});
	}

}
