<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDepartmentIdToOrganizationTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('organization', function(Blueprint $table)
		{
            $table->unsignedInteger('structure_department_id')
                ->nullable()
                ->after('support_staff');

            $table->foreign('structure_department_id')
                ->references('id')
                ->on('structure__departments')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('organization', function(Blueprint $table)
		{
			$table->dropForeign('organization_structure_department_id_foreign');
            $table->dropColumn('structure_department_id');
		});
	}

}
