<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDepartmentIdToOrganizationLevel extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('organization__level', function(Blueprint $table)
		{
            $table->unsignedInteger('structure_department_id')
                ->nullable()
                ->after('level');

            $table->foreign('structure_department_id')
                ->references('id')
                ->on('structure__departments')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('organization__level', function(Blueprint $table)
		{
			$table->dropForeign('organization__level_structure_department_id_foreign');
			$table->dropColumn('structure_department_id');
		});
	}

}
