<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrganizationDetailsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('organization__details', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('organization_id');
            $table->unsignedInteger('table_id');
            $table->integer('table_value_id')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('organization_id')
                ->references('id')
                ->on('organization')
                ->onUpdate('CASCADE')
                ->onDelete('CASCADE');
            $table->foreign('table_id')
                ->references('id')
                ->on('tables')
                ->onUpdate('CASCADE')
                ->onDelete('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('organization__details');
	}

}
