<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrganizationTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('organization', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('user_id')->nullable();
            $table->unsignedInteger('organization_level_id')->nullable();
            $table->boolean('head');
            $table->boolean('support_staff');
            $table->unsignedInteger('structure_position_id')->nullable();
            $table->unsignedInteger('report_to_user_id')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
            $table->foreign('organization_level_id')
                ->references('id')
                ->on('organization__level')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
            $table->foreign('structure_position_id')
                ->references('id')
                ->on('structure__positions')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
            $table->foreign('report_to_user_id')
                ->references('id')
                ->on('users')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('organization');
	}

}
