<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrganizationLevelTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('organization__level', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');

            $table->integer('level');
            $table->unique('level');

            $table->string('name')->nullable();
            $table->string('title')->nullable();
            $table->integer('qty')->nullable();
            $table->boolean('multiple_selection')->default(0);
            $table->boolean('support_staff')->default(0);

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('organization__level');
	}

}
