<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateHomepageChartsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('homepage__charts', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';             $table->increments('id');
            $table->integer('column_id')->nullable();
            $table->unsignedInteger('chart_id')->nullable();
            $table->unsignedInteger('chart_type_id')->nullable();
            $table->string('type')->nullable();
            $table->string('height')->nullable();
            $table->unsignedInteger('report_period_id')->nullable();
            $table->date('date_from')->nullable();
            $table->date('date_to')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('chart_id')
                ->references('id')
                ->on('charts')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('chart_type_id')
                ->references('id')
                ->on('charts__types')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

            $table->foreign('report_period_id')
                ->references('id')
                ->on('report__period')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('homepage__charts');
	}

}
