<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEstimateShareToSalesChannelsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('sales__channels', function(Blueprint $table)
		{
			$table->float('estimate_share', 5)
                ->nullable()
                ->after('channel');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('sales__channels', function(Blueprint $table)
		{
			$table->dropColumn('estimate_share');
		});
	}

}
