<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSalesChannelIdToAgencyTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('agency', function(Blueprint $table)
		{
			$table->unsignedInteger('sales_channel_id')
                ->nullable()
                ->after('address');

            $table->foreign('sales_channel_id')
                ->references('id')
                ->on('sales__channels')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('agency', function(Blueprint $table)
		{
			$table->dropForeign('agency_sales_channel_id_foreign');

            $table->dropColumn('sales_channel_id');

		});
	}

}
