<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsToChartsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('charts', function(Blueprint $table)
		{
            $table->unsignedInteger('chart_type_id')
                ->nullable()
                ->after('id');

            $table->string('image')
                ->nullable()
                ->after('constant');

            $table->foreign('chart_type_id')
                ->references('id')
                ->on('charts__types')
                ->onUpdate('CASCADE')
                ->onDelete('SET NULL');

        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('charts', function(Blueprint $table)
		{
			$table->dropForeign('charts_chart_type_id_foreign');
            $table->dropColumn([
                'chart_type_id',
                'image'
            ]);
		});
	}

}
