<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsToAgencyTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('agency', function(Blueprint $table)
		{
			$table->string('address')
                ->nullable()
                ->after('agency');
            $table->date('founded')
                ->nullable()
                ->after('region_id');
            $table->string('email')
                ->nullable()
                ->after('founded');
            $table->string('website')
                ->nullable()
                ->after('email');
            $table->string('phone')
                ->nullable()
                ->after('website');
            $table->string('mobile')
                ->nullable()
                ->after('phone');

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('agency', function(Blueprint $table)
		{
			$table->dropColumn([
                'address',
                'founded',
                'email',
                'website',
                'phone',
                'mobile'
            ]);
		});
	}

}
