<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPictureToAgencyTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('agency', function(Blueprint $table)
		{
            $table->string('picture')
                ->nullable()
                ->after('region_id');

			$table->string('thumb')
                ->nullable()
                ->after('picture');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('agency', function(Blueprint $table)
		{
			$table->dropColumn('picture');
			$table->dropColumn('thumb');

		});
	}

}
