<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddColumnsToFlightsNumbers extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('flights__numbers', function(Blueprint $table)
		{
            $table->unsignedInteger('departure_airport_id')
                ->nullable()
                ->after('other_airline');
            $table->unsignedInteger('arrival_airport_id')
                ->nullable()
                ->after('departure_airport_id');

            $table->foreign('departure_airport_id')
                ->references('id')
                ->on('airports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('arrival_airport_id')
                ->references('id')
                ->on('airports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('flights__numbers', function(Blueprint $table)
		{
            $table->dropForeign('flights__numbers_departure_airport_id_foreign');
            $table->dropColumn('departure_airport_id');

            $table->dropForeign('flights__numbers_arrival_airport_id_foreign');
            $table->dropColumn('arrival_airport_id');
		});
	}

}
