<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropCountryRegionFromAirports extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('airports', function(Blueprint $table)
		{
            $table->dropForeign('airports_country_id_foreign');
			$table->dropColumn('country_id');

            $table->dropForeign('airports_region_id_foreign');
			$table->dropColumn('region_id');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('airports', function(Blueprint $table)
		{
            $table->unsignedInteger('country_id')
                ->nullable()
                ->after('city_id');
            $table->unsignedInteger('region_id')
                ->nullable()
                ->after('country_id');

            $table->foreign('country_id')
                ->references('id')
                ->on('countries')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('region_id')
                ->references('id')
                ->on('regions')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

}
