<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddGenderFromPassengers extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('passengers', function(Blueprint $table)
		{
            $table->enum('gender', ['male', 'female'])
                ->nullable()
                ->after('dob');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('passengers', function(Blueprint $table)
		{
			$table->dropColumn('gender');
		});
	}

}
