<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropHubsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('hubs', function(Blueprint $table)
		{
			$table->drop();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::create('hubs', function(Blueprint $table)
        {
            $table->increments('id');
            $table->string('name');
            $table->unsignedInteger('city_id')->nullable();
            $table->integer('crew_base')->default(0);
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('city_id')
                ->references('id')
                ->on('cities')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

        });
	}

}
