<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ModifyPassengersOrdersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('passengers__orders', function(Blueprint $table)
		{
			$table->dropColumn(['fare_basis', 'rbd', 'gds']);
            $table->unsignedInteger('reservations_system_id')
                ->nullable()
                ->after('fare_currency_id');

            $table->foreign('reservations_system_id')
                ->references('id')
                ->on('reservations__systems')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('passengers__orders', function(Blueprint $table)
		{
            $table->dropForeign('passengers__orders_reservations_system_id_foreign');
            $table->dropColumn('reservations_system_id');
            $table->string('fare_basis')->nullable()->after('payment_form');
            $table->string('rbd')->nullable()->after('fare_basis');
            $table->string('gds')->nullable()->after('rbd');
		});
	}

}
