<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ModifyPassengerFlightsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
    public function up()
    {
        Schema::table('passengers__flights', function(Blueprint $table)
        {
            $table->dropColumn('fare_basis');
            $table->unsignedInteger('flight_fare_basis_id')->nullable()
                ->after('passenger_order_id');

            $table->dropColumn('rbd');
            $table->unsignedInteger('flight_rbd_id')->nullable()
                ->after('flight_fare_basis_id');

            $table->dropColumn('cabin');
            $table->unsignedInteger('flight_cabin_id')->nullable()
                ->after('flight_rbd_id');

            $table->dropColumn('status');
            $table->unsignedInteger('flight_order_status_id')->nullable()
                ->after('flight_cabin_id');


            $table->foreign('flight_fare_basis_id')
                ->references('id')
                ->on('flights__fare_basis')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('flight_rbd_id')
                ->references('id')
                ->on('flights__rbd')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('flight_cabin_id')
                ->references('id')
                ->on('flights__cabin')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('flight_order_status_id')
                ->references('id')
                ->on('flights__order_status')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('passengers__flights', function(Blueprint $table)
        {
            $table->dropForeign('passengers__flights_flight_fare_basis_id_foreign');
            $table->dropForeign('passengers__flights_flight_rbd_id_foreign');
            $table->dropForeign('passengers__flights_flight_cabin_id_foreign');
            $table->dropForeign('passengers__flights_flight_order_status_foreign');

            $table->dropColumn('flight_fare_basis_id');
            $table->dropColumn('flight_rbd_id');
            $table->dropColumn('flight_cabin_id');
            $table->dropColumn('flight_order_status_id');

            $table->string('fare_basis')->nullable()
                ->after('fare_currency_id');
            $table->string('rbd')->nullable()
                ->after('fare_basis');
            $table->integer('cabin')->nullable()
                ->after('is_inf');
            $table->string('status')->nullable()
                ->after('cabin');
        });
    }
}
