<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersDepartments extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users__departments', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('user_id')->nullable();
            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('department_id')->nullable();
            $table->foreign('department_id')
                ->references('id')
                ->on('structure__departments')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('subdepartment_id')->nullable();
            $table->foreign('subdepartment_id')
                ->references('id')
                ->on('structure__subdepartments')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('position_id')->nullable();
            $table->foreign('position_id')
                ->references('id')
                ->on('structure__positions')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users__departments');
	}

}
