<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePassengersFlightsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('passengers__flights', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('passenger_id')->nullable();
            $table->foreign('passenger_id')
                ->references('id')
                ->on('passengers')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('flight_id')->nullable();
            $table->foreign('flight_id')
                ->references('id')
                ->on('flights')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('flight_number_id')->nullable();
            $table->foreign('flight_number_id')
                ->references('id')
                ->on('flights__numbers')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('passenger_order_id')->nullable();
            $table->foreign('passenger_order_id')
                ->foreign('passenger_order_id')
                ->references('id')
                ->on('passengers__orders')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->timestamp('departure')->nullable();

            $table->date('departure_date')->nullable();

            $table->float('fare', 15,3)->nullable();
            $table->unsignedInteger('fare_currency_id')->nullable();
            $table->foreign('fare_currency_id')
                ->references('id')
                ->on('currency')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->string('fare_basis')->nullable();
            $table->string('rbd')->nullable();
            $table->integer('coupon')->nullable();
            $table->string('seat_number')->nullable();
            $table->integer('is_inf')->nullable();
            $table->enum('cabin', ['first', 'business', 'economy'])->nullable();
            $table->string('status')->nullable();
            $table->integer('baggage_pcs')->nullable();
            $table->float('baggage_weight', 7,2)->nullable();
            $table->string('tag_number')->nullable();
            $table->integer('is_offload')->nullable();
            $table->string('reference_number')->nullable();
            $table->string('offload_force')->nullable();
            $table->string('offload_group')->nullable();
            $table->string('offload_rmk')->nullable();

            $table->index('departure_date');

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('passengers__flights');
	}

}
