<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePassengersOrdersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('passengers__orders', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('agency_code_id')->nullable();
            $table->date('sales_date')->nullable();

            $table->bigInteger('ticket_number')->nullable();
            $table->float('original_fare', 15,3)->nullable();
            $table->unsignedInteger('original_fare_currency_id')->nullable();
            $table->float('fare', 15,3)->nullable();
            $table->unsignedInteger('fare_currency_id')->nullable();
            $table->string('payment_form')->nullable();
            $table->string('fare_basis')->nullable();
            $table->string('rbd')->nullable();
            // Cabin Will be overwritten By Cabin2
            $table->integer('cabin')->nullable();
            $table->enum('cabin2', ['first', 'business', 'economy'])->nullable();
            $table->string('gds')->nullable();
            $table->string('airport_taxes')->nullable();
            // Drop This Column In Future
            $table->string('uab_taxes')->nullable();
            $table->string('fuel_taxes')->nullable();
            $table->string('tch_taxes')->nullable();
            $table->string('other_taxes')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->index('sales_date');
            $table->unique('ticket_number');

            $table->foreign('original_fare_currency_id')
                ->references('id')
                ->on('currency')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('agency_code_id')
                ->references('id')
                ->on('agency__codes')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('fare_currency_id')
                ->references('id')
                ->on('currency')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('passengers__orders');
	}

}
