<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePassengersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('passengers', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->string('last_name')->nullable();;
            $table->string('first_name')->nullable();;
            $table->string('middle_name')->nullable();
            $table->string('email')->nullable();
            $table->date('dob')->nullable();
            $table->unsignedInteger('pob_country_id')->nullable();
            $table->unsignedInteger('nationality_id')->nullable();
            $table->string('gender')->nullable();
            $table->string('passport_num')->nullable();
            $table->date('passport_doi')->nullable();
            $table->date('passport_dex')->nullable();
            $table->string('picture')->nullable();
            $table->string('thumb')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->index('last_name');
            $table->index('first_name');

            $table->foreign('pob_country_id')
                ->references('id')
                ->on('countries')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('nationality_id')
                ->references('id')
                ->on('nationalities')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('passengers');
	}

}
