<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsForwardBookingTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('flights__forward_booking', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->date('updated_date')->nullable();
            $table->unsignedInteger('flight_id')->nullable();
            $table->unsignedInteger('aircraft_id')->nullable();
            $table->unsignedInteger('flight_number_id')->nullable();
            $table->timestamp('std')->nullable();
            $table->integer('pax_c_booked')->nullable();
            $table->integer('pax_y_booked')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('flight_id')
                ->references('id')
                ->on('flights')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('aircraft_id')
                ->references('id')
                ->on('aircraft')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('flight_number_id')
                ->references('id')
                ->on('flights__numbers')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('flights__forward_booking');
	}

}
