<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLogFlightsCrewTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('log__flights_crew', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('flight_id')->nullable();
            $table->foreign('flight_id')
                ->references('id')
                ->on('flights')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('flight_standby_crew_id')->nullable();
            $table->foreign('flight_standby_crew_id')
                ->references('id')
                ->on('flights__standby_crew')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('user_id')->nullable();
            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('position_id')->nullable();
            $table->foreign('position_id')
                ->references('id')
                ->on('structure__positions')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->unsignedInteger('crew_roster_id')->nullable();
            $table->foreign('crew_roster_id')
                ->references('id')
                ->on('crew__rosters')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->integer('position_order')->nullable();
            $table->integer('is_standby')->default(0);
            $table->integer('is_dhc')->default(0);
            $table->timestamp('report_time')->nullable();
            $table->string('reason')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('log__flights_crew');
	}

}
