<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsScheduleFlights extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('flights__schedule_flights', function(Blueprint $table)
		{
		    $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('parent_id')->nullable();
            $table->unsignedInteger('flight_schedule_id')->nullable();
            $table->unsignedInteger('aircraft_id')->nullable();
            $table->unsignedInteger('flight_number_id')->nullable();
            $table->integer('std_weekday');
            $table->timestamp('std_time');
            $table->integer('sta_weekday');
            $table->timestamp('sta_time');
            $table->enum('frequency', ['weekly','once_in_2_weeks','once_in_3_weeks','once_in_4_weeks']);
            $table->enum('starting_week', ['first_week','second_week','third_week','fourth_week']);
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('flight_schedule_id')
                ->references('id')
                ->on('flights__schedule')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('aircraft_id')
                ->references('id')
                ->on('aircraft')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('flight_number_id')
                ->references('id')
                ->on('flights__numbers')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('flights__schedule_flights');
	}

}
