<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinancialReportsData extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('finance__reports_data', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('variable_id')->nullable();
            $table->unsignedInteger('category_id')->nullable();
            $table->unsignedInteger('report_id')->nullable();
            $table->string('flight_number')->nullable();
            $table->date('date')->nullable();
            $table->float('default_value', 11, 2)->nullable();
            $table->float('traffic_revenue', 11, 2)->nullable();
            $table->float('contribution_1', 11, 2)->nullable();
            $table->float('contribution_2', 11, 2)->nullable();
            $table->float('contribution_3', 11, 2)->nullable();
            $table->float('passenger_revenue', 11, 2)->nullable();
            $table->float('variance_volume', 11, 2)->nullable();
            $table->float('variance_yield', 11, 2)->nullable();
            $table->float('average_fare', 11, 2)->nullable();
            $table->float('yield_per_rpk', 11, 2)->nullable();
            $table->float('revenue_pax_km', 11, 2)->nullable();
            $table->float('available_seat_km', 11, 2)->nullable();
            $table->float('passenger_seat_factor', 11, 2)->nullable();
            $table->float('passenger_numbers', 11, 2)->nullable();
            $table->float('excess_baggage', 11, 2)->nullable();
            $table->float('landings', 11, 2)->nullable();
            $table->float('flight_hours', 11, 2)->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('variable_id')
                ->references('id')
                ->on('finance__reports_variables')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('category_id')
                ->references('id')
                ->on('finance__reports_categories')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('report_id')
                ->references('id')
                ->on('finance__reports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('finance__reports_data');
	}

}
