<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinancialReportsVariables extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('finance__reports_variables', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('category_id')->nullable();
            $table->unsignedInteger('report_id')->nullable();
            $table->string('name');
            $table->string('measure')->nullable();
            $table->integer('multiply')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('category_id')
                ->references('id')
                ->on('finance__reports_categories')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('report_id')
                ->references('id')
                ->on('finance__reports')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('finance__reports_variables');
	}

}
