<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCurrencyRatesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('currency__rates', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->date('date');
            $table->unsignedInteger('from_currency_id')->nullable();;
            $table->unsignedInteger('to_currency_id')->nullable();;
            $table->float('rate', 16, 8);
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('from_currency_id')
                ->references('id')
                ->on('currency')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('to_currency_id')
                ->references('id')
                ->on('currency')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('currency__rates');
	}

}
