<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCrewRosterSettingsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('crew__roster_settings', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->enum('type', ['ccm', 'fcm']);
            $table->integer('ftl_7');
            $table->integer('ftl_28');
            $table->integer('ftl_365');
            $table->enum('roster_type', ['weekly', 'fortnightly', 'monthly', 'custom']);
            $table->text('policy_flight_numbers')->nullable();
            $table->text('documents_validity')->nullable();
            $table->integer('flying_license')->default(0);
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('crew__roster_settings');
	}

}
