<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAgencyCodesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('agency__codes', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('code')->nullable();
            $table->string('tch_code')->nullable();
            $table->string('code_ru')->nullable();

            $table->unsignedInteger('agency_id')->nullable();
            $table->unsignedInteger('city_id')->nullable();
            $table->unsignedInteger('country_id')->nullable();
            $table->unsignedInteger('region_id')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('agency_id')
                ->references('id')
                ->on('agency')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('city_id')
                ->references('id')
                ->on('cities')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('country_id')
                ->references('id')
                ->on('countries')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

            $table->foreign('region_id')
                ->references('id')
                ->on('regions')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('agency__codes');
	}

}
