<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCrewFlightTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('crew__flight', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('user_id')->nullable();
            $table->integer('is_captain')->nullable();
            $table->integer('english_level')->nullable();
            $table->date('aruba_validation_from')->nullable();
            $table->date('aruba_validation_to')->nullable();
            $table->date('cmc_from')->nullable();
            $table->date('cmc_to')->nullable();
            $table->date('sep_12')->nullable();
            $table->date('sep_36')->nullable();
            $table->date('crm_from')->nullable();
            $table->date('crm_to')->nullable();
            $table->date('security')->nullable();
            $table->date('medical_from')->nullable();
            $table->date('medical_to')->nullable();
            $table->date('flying_license_from')->nullable();
            $table->date('flying_license_to')->nullable();
            $table->date('line_check_from')->nullable();
            $table->date('line_check_to')->nullable();
            $table->date('license_attachment_from')->nullable();
            $table->date('license_attachment_to')->nullable();
            $table->date('dgr_from')->nullable();
            $table->date('dgr_to')->nullable();
            $table->date('lpc_ir_from')->nullable();
            $table->date('lpc_ir_to')->nullable();
            $table->date('opc_from')->nullable();
            $table->date('opc_to')->nullable();
            $table->date('tri_sfi_from')->nullable();
            $table->date('tri_sfi_to')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('crew__flight');
	}

}
