<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCrewCabinTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('crew__cabin', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('user_id')->nullable();
            $table->integer('is_purser')->nullable();
            $table->date('license_validity')->nullable();
            $table->date('medical_next')->nullable();
            $table->date('cmc_from')->nullable();
            $table->date('cmc_to')->nullable();
            $table->date('sep_from')->nullable();
            $table->date('sep_to')->nullable();
            $table->date('crm_from')->nullable();
            $table->date('crm_to')->nullable();
            $table->date('security_from')->nullable();
            $table->date('security_to')->nullable();
            $table->date('line_check_from')->nullable();
            $table->date('line_check_to')->nullable();
            $table->date('dgr_from')->nullable();
            $table->date('dgr_to')->nullable();
            $table->date('practical_from')->nullable();
            $table->date('practical_to')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('user_id')
                ->references('id')
                ->on('users')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');

        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('crew__cabin');
	}

}
