<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAircraftPartsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('aircraft__parts', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('aircraft_id')->nullable();
            $table->string('part_type')->nullable();
            $table->string('part_number')->nullable();
            $table->string('serial_number')->nullable();
            $table->string('type_model')->nullable();
            $table->string('position')->nullable();
            $table->integer('tsn')->nullable();
            $table->integer('csn')->nullable();
            $table->date('installation_date')->nullable();
            $table->integer('tslsv')->nullable();
            $table->integer('cslsv')->nullable();
            $table->string('thrust_category')->nullable();
            $table->integer('first_llp_remaining_fc')->nullable();
            $table->date('last_overhaul_date')->nullable();
            $table->date('next_overhaul_date')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('aircraft_id')
                ->references('id')
                ->on('aircraft')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('aircraft__parts');
	}

}
