<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('flights', function(Blueprint $table)
		{
		    $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('parent_id')->nullable();
            $table->unsignedInteger('aircraft_id')->nullable();
            $table->foreign('aircraft_id')
                ->references('id')
                ->on('aircraft')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('flight_number_id')->nullable();
            $table->foreign('flight_number_id')
                ->references('id')
                ->on('flights__numbers')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('flights_delay_id')->nullable();
            $table->foreign('flights_delay_id')
                ->references('id')
                ->on('flights__delays')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->text('delays')->nullable();
            $table->timestamp('std')->nullable();
            $table->timestamp('etd')->nullable();
            $table->timestamp('atd')->nullable();
            $table->timestamp('abn')->nullable();
            $table->timestamp('sta')->nullable();
            $table->timestamp('eta')->nullable();
            $table->timestamp('tdn')->nullable();
            $table->timestamp('ata')->nullable();
            $table->integer('capacity_c')->nullable();
            $table->integer('capacity_y')->nullable();
            $table->integer('pax_c_booked')->nullable();
            $table->integer('pax_y_booked')->nullable();
            $table->integer('pax_inf_booked')->nullable();
            $table->integer('pax_c_actual')->nullable();
            $table->integer('pax_y_actual')->nullable();
            $table->integer('pax_inf_actual')->nullable();
            $table->integer('baggage')->nullable();
            $table->integer('cargo')->nullable();
            $table->integer('cargo_200')->nullable();
            $table->integer('mail')->nullable();
            $table->integer('deportees')->nullable();
            $table->integer('in_tanks')->nullable();
            $table->integer('uplifted')->nullable();
            $table->integer('utilised')->nullable();
            $table->string('gate_parking')->nullable();
            $table->integer('is_diversion')->nullable();
            $table->text('diversion')->nullable();
            $table->timestamp('closed_sales')->nullable();
            $table->string('remark')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('flights');
	}

}
