<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsNumbersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('flights__numbers', function(Blueprint $table)
		{
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string('flight_number');
            $table->integer('other_airline')->nullable();
            $table->string('departure_airport');
            $table->string('arrival_airport');
            $table->integer('bound');
            $table->unsignedInteger('flight_type_id')->nullable();
            $table->integer('duration')->nullable();
            $table->integer('distance')->nullable();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

            $table->foreign('flight_type_id')
                ->references('id')
                ->on('flights__types')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('flights__numbers');
	}

}
