<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAircraftTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('aircraft', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->string('name');
            $table->string('mvt_name');
            $table->unsignedInteger('aircraft_type_id')->nullable();
            $table->foreign('aircraft_type_id')
                ->references('id')
                ->on('aircraft__types')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->string('msn');
            $table->string('line_number');
            $table->date('first_flight');
            $table->integer('airframe_status');
            $table->integer('min_fcm');
            $table->integer('min_ccm');
            $table->integer('config_c');
            $table->integer('config_y');
            $table->integer('order');

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('aircraft');
	}

}
