<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAircraftTypesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('aircraft__types', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->string('name');
            $table->string('iata_name');
            $table->integer('min_ccm');
            $table->integer('policy_ccm');
            $table->integer('min_fcm');
            $table->integer('policy_fcm');
            $table->string('details');
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('aircraft__types');
	}

}
