<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStructurePositionsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('structure__positions', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->string('name');
            $table->unsignedInteger('department_id')->nullable();
            $table->foreign('department_id')
                ->references('id')
                ->on('structure__departments')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('subdepartment_id')->nullable();
            $table->foreign('subdepartment_id')
                ->references('id')
                ->on('structure__subdepartments')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('structure__positions');
	}

}
