<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users', function(Blueprint $table)
		{
		            $table->engine = 'InnoDB';             $table->increments('id');
            $table->unsignedInteger('user_access_type_id')->nullable();
            $table->foreign('user_access_type_id')
                ->references('id')
                ->on('users__access_types')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('user_role_id')->nullable();
            $table->foreign('user_role_id')
                ->references('id')
                ->on('users__roles')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('marital_status_id')->nullable();
            $table->foreign('marital_status_id')
                ->references('id')
                ->on('marital_status')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('location_id')->nullable();
            $table->foreign('location_id')
                ->references('id')
                ->on('locations')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('pob_country_id')->nullable();
            $table->foreign('pob_country_id')
                ->references('id')
                ->on('countries')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('nationality_id')->nullable();
            $table->foreign('nationality_id')
                ->references('id')
                ->on('nationalities')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->unsignedInteger('system_language_id')->nullable();
            $table->foreign('system_language_id')
                ->references('id')
                ->on('system_languages')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
            $table->integer('activated')->default(0);
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
            $table->date('doj')->nullable();
			$table->string('email')->unique();
			$table->string('password', 100)->nullable();
			$table->string('tmp_password')->nullable();
            $table->date('dob')->nullable();

            $table->enum('gender', ['male', 'female'])->nullable();
            $table->string('passport_num')->nullable();
            $table->date('passport_doi')->nullable();
            $table->date('passport_dex')->nullable();

            $table->integer('is_contractor')->nullable();
            $table->integer('staff_number')->nullable();
            $table->integer('idcard_number')->nullable();
            $table->date('idcard_expiry')->nullable();
            $table->date('resigned_date')->nullable();
            $table->string('picture')->nullable();
            $table->string('thumb')->nullable();
            $table->timestamp('last_login')->nullable();

			$table->rememberToken();
            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();

		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users');
	}

}
