<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov
 * Date: 18.08.14

 */

use App\Mail\TemplateEmail;
use App\Models\Airline;
use App\Models\CPMMessage;
use App\Models\CrewListMessage;
use App\Models\EmailNotification;
use App\Models\Flight;
use App\Models\FlightNumber;
use App\Models\FlightScheduleFlight;
use App\Models\FlightStation;
use App\Models\FlightTracker;
use App\Models\HBGMessage;
use App\Models\LDMmessage;
use App\Models\LPMMessage;
use App\Models\MVTMessage;
use App\Models\OtherMessage;
use App\Models\PassengerFlight;
use App\Models\PassengerFlightAct;
use App\Models\PNLMessage;
use App\Models\Position;
use App\Models\PRLMessage;
use App\Models\PSMMessage;
use App\Models\PTMMessage;
use App\Models\SLSMessage;
use App\Models\StaffStation;
use App\Models\TPMMessage;
use App\Models\UCMMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\UserModule;
use App\Models\Module;
use App\Models\ModulePermission;
use App\Models\Department;
use App\Models\UserDepartment;
use Illuminate\Pagination\Paginator;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Classes\Crew\FCM;
use App\Classes\Crew\CCM;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\Mail;
use OwenIt\Auditing\Models\Audit;

function cryptoJsAesEncrypt($value, $passphrase){
    $salt = openssl_random_pseudo_bytes(8);
    $salted = '';
    $dx = '';
    while (strlen($salted) < 48) {
        $dx = md5($dx . $passphrase . $salt, true);
        $salted .= $dx;
    }
    $key = substr($salted, 0, 32);
    $iv = substr($salted, 32, 16);
    $encrypted_data = openssl_encrypt(json_encode($value), 'aes-256-cbc', $key, true, $iv);
    $data = ["ct" => base64_encode($encrypted_data), "iv" => bin2hex($iv), "s" => bin2hex($salt)];
    return json_encode($data);
}

function cryptoJsAesDecrypt($jsonStr, $passphrase){
//    return \Nullix\CryptoJsAes\CryptoJsAes::decrypt($jsonStr, $passphrase);
    $json = json_decode($jsonStr, true);
    $salt = hex2bin($json["s"]);
    $iv = hex2bin($json["iv"]);
    $ct = base64_decode($json["ct"]);
    $concatedPassphrase = $passphrase . $salt;
    $md5 = [];
    $md5[0] = md5($concatedPassphrase, true);
    $result = $md5[0];
    for ($i = 1; $i < 3; $i++) {
        $md5[$i] = md5($md5[$i - 1] . $concatedPassphrase, true);
        $result .= $md5[$i];
    }
    $key = substr($result, 0, 32);
    $data = openssl_decrypt($ct, 'aes-256-cbc', $key, true, $iv);
    return json_decode($data, true);

}

function getAudit($model, $conditions = [], $object = null){
    $authUser = Auth::user();

    if (!$authUser || !$authUser->role || !in_array($authUser->role->role, [ADMIN, SUPER_ADMIN])){
        return [];
    }

    $data = Audit::where("auditable_type", $model);

    if ($object){
        $data->where("auditable_id", $object->id);
    }

    if (count($conditions)){
        foreach ($conditions as $condition) {
            $data->where($condition["col"], $condition["val"]);
        }
    }

    $data = $data->orderBy("created_at")
        ->with('user')
        ->get();

    return $data;
}

function getAirlineServiceAudit($airlineID){
    $authUser = Auth::user();

    if (!$authUser || !$authUser->role || !in_array($authUser->role->role, [ADMIN, SUPER_ADMIN])){
        return [];
    }

    $data = Audit::with(["user"])
        ->leftJoin("airlines__services", "airlines__services.id", "=", "auditable_id")
        ->leftJoin("services", "services.id", "=", "airlines__services.service_id")
        ->leftJoin("airlines", "airlines.id", "=", "airlines__services.airline_id")
        ->leftJoin("airports", "airports.id", "=", "airlines__services.airport_id")
        ->where("auditable_type", AIRLINE_SERVICE_MODEL)
//        ->where("event", "deleted")
        ->where(function ($sql) use ($airlineID){
            $sql->where("airlines.id", $airlineID)
                ->orWhere("old_values", "LIKE", '%"airline_id":'.$airlineID.'%');
        });


    $data = $data->orderBy("audits.created_at", "DESC")
        ->get([
            "audits.*",
            "services.abbr",
            "airports.iata as ap"
        ]);

    return $data;
}
function getServiceAudit(){
    $authUser = Auth::user();

    if (!$authUser || !$authUser->role || !in_array($authUser->role->role, [ADMIN, SUPER_ADMIN])){
        return [];
    }

    $data = Audit::with(["user"])
        ->leftJoin("services", "services.id", "=", "auditable_id")
        ->where("auditable_type", SERVICE_MODEL);


    $data = $data->orderBy("audits.created_at", "DESC")
        ->get([
            "audits.*",
            "services.abbr",
        ]);

    return $data;
}

function getAirlineServiceAuditSLA($audit, $servicesList){
    if ($audit->abbr){
        return $audit->abbr;
    }

    foreach ($audit->old_values as $prop => $val) {
        if ($prop == "service_id"){
            return array_key_exists($val, $servicesList) ? $servicesList[$val] : "";
//            $sla = \App\Models\Service::find($val);
//            return $sla ? $sla->abbr : "";
        }
    }
}

function getAirlineServiceAuditAirport($audit, $handlingAirports){
    if ($audit->ap){
        return $audit->ap;
    }

    foreach ($audit->old_values as $prop => $val) {
        if ($prop == "airport_id"){
            return array_key_exists($val, $handlingAirports) ? $handlingAirports[$val] : "";
//            $sla = \App\Models\Airport::find($val);
//            return $sla ? $sla->iata : "";
        }
    }
}

function checkSLAEffectivePeriod($airlineService, $depArrTime){
    // does not apply
    $date = date("Y-m-d", strtotime($depArrTime));

    if ($airlineService->start_date && strtotime($date) < strtotime($airlineService->start_date)){
        return false;
    }
    if ($airlineService->end_date && strtotime($date) > strtotime($airlineService->end_date)){
        return false;
    }


    if ($airlineService->service_timings){
        // Default
        $effectiveFrom = $airlineService->service->effective_from;
        $effectiveTo = $airlineService->service->effective_to;
    }
    else {
        $effectiveFrom = $airlineService->effective_from;
        $effectiveTo = $airlineService->effective_to;
    }

    if (!$effectiveFrom || !$effectiveTo){
        return true;
    }

    $time = date("H:i", strtotime($depArrTime));

    // Standard time period
    if (strtotime($effectiveTo) > strtotime($effectiveFrom)){
        return strtotime($time) >= strtotime($effectiveFrom) && strtotime($time) <= strtotime($effectiveTo);
    }
    else {
        return strtotime($time) >= strtotime($effectiveFrom) || strtotime($time) <= strtotime($effectiveTo);
    }
}

function getPeriod(Request $request){
    $dateYesterday = date('Y-m-d', strtotime(" - 1 days"));
    $dateSearchOption = $request->get('dateSearch');
    switch ($dateSearchOption) {
        case 'monthYear':
            $dateSearch = [
                'month' =>  $request->get('month') ? $request->get('month')  : date('m'),
                'year'  =>  $request->get('year')  ? $request->get('year')   : date('Y')
            ];
            break;
        default:
            $dateSearch = [
                'from'  => $request->has('dateFrom') ? $request->get('dateFrom')  : $dateYesterday,
                'to'    => $request->has('dateTo')   ? $request->get('dateTo')    : $dateYesterday
            ];
            break;
    }

    return $dateSearch;
}

function auditDeleted($records){
    if (!$records){
        return;
    }

    if ($records instanceof \Illuminate\Database\Eloquent\Collection || is_array($records)) {
        foreach ($records as $item) {
            try {
                $item->setAuditEvent("deleted");
                $item->toAudit();
            } catch (\Exception $err) {

            }

            $item->delete();
        }
    }
    // $records -> is single obj
    elseif ($records instanceof \Illuminate\Database\Eloquent\Model) {
        try {
            $records->setAuditEvent("deleted");
            $records->toAudit();
        } catch (\Exception $err) {

        }

        $records->delete();
    }
}

function test($flight){
    getFlightNumberFull($flight);
}

function getUserModulesAndController($authUser)
{
    $userModules = [];
    $userControllers = [];

    // Get User Authorized Modules
    $modules = UserModule::with('module')->where('user_id', $authUser->id)->get();
    if (count($modules)) {
        foreach ($modules as $module_item) {
            if (isset($userModules[$module_item->module->id]))
                $userModules[$module_item->module->id][] = $module_item->module_permission_id;
            else {
                $userModules[$module_item->module->id] = [$module_item->module_permission_id];
                // Get User Controllers List
                $userControllers[] = explode('/', $module_item->module->link)[0];
            }
        }
    }

    // Get Link Of Modules If It Has Any Default (All or Department) Set
    $modules = Module::whereNotNull('department_id')->get();
    foreach ($modules as $each) {
        $defaultValues = checkDefaultPermission($each->id, $authUser);
        if ($defaultValues) {
            if (isset($userModules[$each->id])) {
                foreach ($defaultValues as $value) {
                    if (!in_array($value, $userModules[$each->id])) {
                        $userModules[$each->id][] = $value;
                    }
                }
            } else {
                $userModules[$each->id] = $defaultValues;
                // Get User Controllers List
                $userControllers[] = explode('/', $each->link)[0];
            }
        }
    }
    // Remove All Duplicates
    $userControllers = count($userControllers) ? array_unique($userControllers) : $userControllers;

    return [$userModules, $userControllers];
}

function isUserResignationStarted($user){
    if (!$user || !$user->resigned_date || $user->resigned_date == EMPTY_DATE
        || strtotime($user->resigned_date) > strtotime(date("Y-m-d"))){
        return false;
    }

    return true;
}


function isUserAllowedToLogin($user){
    if (!$user || !$user->activated || $user->deleted_at ||
        isUserResignationStarted($user))
    {
        return false;
    }

    return true;
}

function checkLoginAccess(){

}

/**
 * Full Controllers List (Filter By Permission)
 * @param bool $permission
 * @return array
 */
function controllerList($permission = false, $controllerShortNameList = false)
{
    $controllersList = [
        'admin'         => ['controller' => 'AdminController', 'permission' => [3, 2]],
        'position'      => ['controller' => 'PositionController', 'permission' => [3, 2]],
        'subdepartment' => ['controller' => 'SubDepartmentController', 'permission' => [3, 2]],
        'aircraft'      => ['controller' => 'AircraftController', 'permission' => [3, 2]],

        'module'        => ['controller' => 'ModuleController', 'permission' => 3],
        'backup'        => ['controller' => 'BackupController', 'permission' => 3],
        'fix'           => ['controller' => 'FixController', 'permission' => 3],
        'currency'      => ['controller' => 'CurrencyController', 'permission' => 3],

        'changelog'     => ['controller' => 'ChangeLogController',      'permission' => 'all'],
        'change-record' => ['controller' => 'ChangeRecordController',   'permission' => 'all'],
        'department'    => ['controller' => 'DepartmentController',     'permission' => 'all'],
        'error'         => ['controller' => 'ErrorController',          'permission' => 'all'],
        'export'        => ['controller' => 'ExportController',         'permission' => 'all'],
        'flight'        => ['controller' => 'FlightController',         'permission' => 'all'],
        'crew'          => ['controller' => 'CrewController',           'permission' => 'all'],
        'location'      => ['controller' => 'LocationController',       'permission' => 'all'],
        'language'      => ['controller' => 'LanguageController',       'permission' => 'all'],
        'template'      => ['controller' => 'TemplateController',       'permission' => 'all'],

        'organization-level' => ['controller' => 'OrganizationLevelController', 'permission' => 'authorized'],
        'organization' => ['controller' => 'OrganizationController', 'permission' => 'authorized'],
        'bsp' => ['controller' => 'BspController', 'permission' => 'authorized'],
        'hrm' => ['controller' => 'HrmController', 'permission' => 'authorized'],
        'crewquery' => ['controller' => 'CrewQueryController', 'permission' => 'authorized'],
        'crewroster' => ['controller' => 'CrewRosterController', 'permission' => 'authorized'],
        'crewschedule' => ['controller' => 'CrewScheduleController', 'permission' => 'authorized'],
        'finance' => ['controller' => 'FinanceController', 'permission' => 'authorized'],
        'fleetwatch' => ['controller' => 'FleetWatchController', 'permission' => 'authorized'],
        'fleet-management' => ['controller' => 'FleetManagementController', 'permission' => 'authorized'],
        'flightquery' => ['controller' => 'FlightQueryController', 'permission' => 'authorized'],
        'flightschedule' => ['controller' => 'FlightScheduleController', 'permission' => 'authorized'],
        'forwardbooking' => ['controller' => 'ForwardBookingController', 'permission' => 'authorized'],
        'forwardrevenue' => ['controller' => 'ForwardRevenueController', 'permission' => 'authorized'],
        'passenger' => ['controller' => 'PassengerController', 'permission' => 'authorized'],
        'report' => ['controller' => 'ReportController', 'permission' => 'authorized'],
        'standby' => ['controller' => 'StandbyController', 'permission' => 'authorized'],
    ];

    if ($permission) {
        foreach ($controllersList as $controller => $each) {
            if (is_array($each['permission'])) {
                /* if (!in_array($permission, $each['permission']))
                     unset($controllersList[$controller]);*/

            } else {
                /* if ($each['permission'] != $permission)
                     unset($controllersList[$controller]);*/
            }
        }

    }
    if ($controllerShortNameList) {
        return array_keys($controllersList);
    }
    return $controllersList;
}

/**
 * Add Controllers to User Controller Array Based On Role
 * @param $userControllers
 * @param string $role
 * @return array
 */
function addControllersByRole($userControllers, $role = ROLE_ALL)
{
    $addControllers = controllerList($role, true);
    foreach ($addControllers as $each) {
        if (!in_array($each, $userControllers))
            $userControllers[] = $each;
    }
    $userControllers = array_unique($userControllers);

    return $userControllers;
}

if (!function_exists("allowed")) {
    function allowed($route, $authObject)
    {
        if ($authObject->check()) {
            foreach ($authObject->user()->structure__departments as $department) {
                foreach ($department->resources as $resource) {
                    if ($resource->name == $route) {
                        return TRUE;
                    }
                }
            }
        }

        return FALSE;
    }
}
if (!function_exists("mydebug")) {
    function mydebug($v, $s = FALSE)
    {
        if ($s) {
            echo '<strong>' . $s . '</strong>';
        }
        if ((is_array($v) || is_object($v)) && $v) {
            echo '<pre>';
            print_r($v);
            echo '</pre>';
        } else {
            var_dump($v);
        }
    }
}

function countryUpdate()
{
    $countryList = array(
        'AD' => 'Andorra',
        'AE' => 'United Arab Emirates',
        'AF' => 'Afghanistan',
        'AG' => 'Antigua &amp; Barbuda',
        'AI' => 'Anguilla',
        'AL' => 'Albania',
        'AM' => 'Armenia',
        'AN' => 'Netherlands Antilles',
        'AO' => 'Angola',
        'AQ' => 'Antarctica',
        'AR' => 'Argentina',
        'AS' => 'American Samoa',
        'AT' => 'Austria',
        'AU' => 'Australia',
        'AW' => 'Aruba',
        'AZ' => 'Azerbaijan',
        'BA' => 'Bosnia and Herzegovina',
        'BB' => 'Barbados',
        'BD' => 'Bangladesh',
        'BE' => 'Belgium',
        'BF' => 'Burkina Faso',
        'BG' => 'Bulgaria',
        'BH' => 'Bahrain',
        'BI' => 'Burundi',
        'BJ' => 'Benin',
        'BM' => 'Bermuda',
        'BN' => 'Brunei Darussalam',
        'BO' => 'Bolivia',
        'BR' => 'Brazil',
        'BS' => 'Bahama',
        'BT' => 'Bhutan',
        'BU' => 'Burma (no longer exists)',
        'BV' => 'Bouvet Island',
        'BW' => 'Botswana',
        'BY' => 'Belarus',
        'BZ' => 'Belize',
        'CA' => 'Canada',
        'CC' => 'Cocos (Keeling) Islands',
        'CF' => 'Central African Republic',
        'CG' => 'Congo',
        'CH' => 'Switzerland',
        'CI' => 'Côte D\'ivoire (Ivory Coast)',
        'CK' => 'Cook Iislands',
        'CL' => 'Chile',
        'CM' => 'Cameroon',
        'CN' => 'China',
        'CO' => 'Colombia',
        'CR' => 'Costa Rica',
        'CS' => 'Czechoslovakia (no longer exists)',
        'CU' => 'Cuba',
        'CV' => 'Cape Verde',
        'CX' => 'Christmas Island',
        'CY' => 'Cyprus',
        'CZ' => 'Czech Republic',
        'DD' => 'German Democratic Republic (no longer exists)',
        'DE' => 'Germany',
        'DJ' => 'Djibouti',
        'DK' => 'Denmark',
        'DM' => 'Dominica',
        'DO' => 'Dominican Republic',
        'DZ' => 'Algeria',
        'EC' => 'Ecuador',
        'EE' => 'Estonia',
        'EG' => 'Egypt',
        'EH' => 'Western Sahara',
        'ER' => 'Eritrea',
        'ES' => 'Spain',
        'ET' => 'Ethiopia',
        'FI' => 'Finland',
        'FJ' => 'Fiji',
        'FK' => 'Falkland Islands (Malvinas)',
        'FM' => 'Micronesia',
        'FO' => 'Faroe Islands',
        'FR' => 'France',
        'FX' => 'France, Metropolitan',
        'GA' => 'Gabon',
        'GB' => 'United Kingdom (Great Britain)',
        'GD' => 'Grenada',
        'GE' => 'Georgia',
        'GF' => 'French Guiana',
        'GH' => 'Ghana',
        'GI' => 'Gibraltar',
        'GL' => 'Greenland',
        'GM' => 'Gambia',
        'GN' => 'Guinea',
        'GP' => 'Guadeloupe',
        'GQ' => 'Equatorial Guinea',
        'GR' => 'Greece',
        'GS' => 'South Georgia and the South Sandwich Islands',
        'GT' => 'Guatemala',
        'GU' => 'Guam',
        'GW' => 'Guinea-Bissau',
        'GY' => 'Guyana',
        'HK' => 'Hong Kong',
        'HM' => 'Heard &amp; McDonald Islands',
        'HN' => 'Honduras',
        'HR' => 'Croatia',
        'HT' => 'Haiti',
        'HU' => 'Hungary',
        'ID' => 'Indonesia',
        'IE' => 'Ireland',
        'IL' => 'Israel',
        'IN' => 'India',
        'IO' => 'British Indian Ocean Territory',
        'IQ' => 'Iraq',
        'IR' => 'Islamic Republic of Iran',
        'IS' => 'Iceland',
        'IT' => 'Italy',
        'JM' => 'Jamaica',
        'JO' => 'Jordan',
        'JP' => 'Japan',
        'KE' => 'Kenya',
        'KG' => 'Kyrgyzstan',
        'KH' => 'Cambodia',
        'KI' => 'Kiribati',
        'KM' => 'Comoros',
        'KN' => 'St. Kitts and Nevis',
        'KP' => 'Korea, Democratic People\'s Republic of',
        'KR' => 'Korea, Republic of',
        'KW' => 'Kuwait',
        'KY' => 'Cayman Islands',
        'KZ' => 'Kazakhstan',
        'LA' => 'Lao People\'s Democratic Republic',
        'LB' => 'Lebanon',
        'LC' => 'Saint Lucia',
        'LI' => 'Liechtenstein',
        'LK' => 'Sri Lanka',
        'LR' => 'Liberia',
        'LS' => 'Lesotho',
        'LT' => 'Lithuania',
        'LU' => 'Luxembourg',
        'LV' => 'Latvia',
        'LY' => 'Libyan Arab Jamahiriya',
        'MA' => 'Morocco',
        'MC' => 'Monaco',
        'MD' => 'Moldova, Republic of',
        'MG' => 'Madagascar',
        'MH' => 'Marshall Islands',
        'ML' => 'Mali',
        'MN' => 'Mongolia',
        'MM' => 'Myanmar',
        'MO' => 'Macau',
        'MP' => 'Northern Mariana Islands',
        'MQ' => 'Martinique',
        'MR' => 'Mauritania',
        'MS' => 'Monserrat',
        'MT' => 'Malta',
        'MU' => 'Mauritius',
        'MV' => 'Maldives',
        'MW' => 'Malawi',
        'MX' => 'Mexico',
        'MY' => 'Malaysia',
        'MZ' => 'Mozambique',
        'NA' => 'Namibia',
        'NC' => 'New Caledonia',
        'NE' => 'Niger',
        'NF' => 'Norfolk Island',
        'NG' => 'Nigeria',
        'NI' => 'Nicaragua',
        'NL' => 'Netherlands',
        'NO' => 'Norway',
        'NP' => 'Nepal',
        'NR' => 'Nauru',
        'NT' => 'Neutral Zone (no longer exists)',
        'NU' => 'Niue',
        'NZ' => 'New Zealand',
        'OM' => 'Oman',
        'PA' => 'Panama',
        'PE' => 'Peru',
        'PF' => 'French Polynesia',
        'PG' => 'Papua New Guinea',
        'PH' => 'Philippines',
        'PK' => 'Pakistan',
        'PL' => 'Poland',
        'PM' => 'St. Pierre &amp; Miquelon',
        'PN' => 'Pitcairn',
        'PR' => 'Puerto Rico',
        'PT' => 'Portugal',
        'PW' => 'Palau',
        'PY' => 'Paraguay',
        'QA' => 'Qatar',
        'RE' => 'Réunion',
        'RO' => 'Romania',
        'RU' => 'Russian Federation',
        'RW' => 'Rwanda',
        'SA' => 'Saudi Arabia',
        'SB' => 'Solomon Islands',
        'SC' => 'Seychelles',
        'SD' => 'Sudan',
        'SE' => 'Sweden',
        'SG' => 'Singapore',
        'SH' => 'St. Helena',
        'SI' => 'Slovenia',
        'SJ' => 'Svalbard &amp; Jan Mayen Islands',
        'SK' => 'Slovakia',
        'SL' => 'Sierra Leone',
        'SM' => 'San Marino',
        'SN' => 'Senegal',
        'SO' => 'Somalia',
        'SR' => 'Suriname',
        'ST' => 'Sao Tome &amp; Principe',
        'SU' => 'Union of Soviet Socialist Republics (no longer exists)',
        'SV' => 'El Salvador',
        'SY' => 'Syrian Arab Republic',
        'SZ' => 'Swaziland',
        'TC' => 'Turks &amp; Caicos Islands',
        'TD' => 'Chad',
        'TF' => 'French Southern Territories',
        'TG' => 'Togo',
        'TH' => 'Thailand',
        'TJ' => 'Tajikistan',
        'TK' => 'Tokelau',
        'TM' => 'Turkmenistan',
        'TN' => 'Tunisia',
        'TO' => 'Tonga',
        'TP' => 'East Timor',
        'TR' => 'Turkey',
        'TT' => 'Trinidad &amp; Tobago',
        'TV' => 'Tuvalu',
        'TW' => 'Taiwan, Province of China',
        'TZ' => 'Tanzania, United Republic of',
        'UA' => 'Ukraine',
        'UG' => 'Uganda',
        'UM' => 'United States Minor Outlying Islands',
        'US' => 'United States of America',
        'UY' => 'Uruguay',
        'UZ' => 'Uzbekistan',
        'VA' => 'Vatican City State (Holy See)',
        'VC' => 'St. Vincent &amp; the Grenadines',
        'VE' => 'Venezuela',
        'VG' => 'British Virgin Islands',
        'VI' => 'United States Virgin Islands',
        'VN' => 'Viet Nam',
        'VU' => 'Vanuatu',
        'WF' => 'Wallis &amp; Futuna Islands',
        'WS' => 'Samoa',
        'YD' => 'Democratic Yemen (no longer exists)',
        'YE' => 'Yemen',
        'YT' => 'Mayotte',
        'YU' => 'Yugoslavia',
        'ZA' => 'South Africa',
        'ZM' => 'Zambia',
        'ZR' => 'Zaire',
        'ZW' => 'Zimbabwe'
    );
    foreach ($countryList as $i => $each) {
        $country = Country::firstOrCreate(['abbr' => $i]);
        $country->country = $each;
        $country->save();
    }

}

if (!function_exists("_debug")) {
    function _debug($arr)
    {
        echo "<pre>";
        print_r($arr);
        echo "</pre>";
    }
}

function isArchiveMessages($flight){
    if (!$flight || !$flight->departure_date){
        return false;
    }

    return strtotime($flight->departure_date) <= strtotime("2022-01-01");
}

function getMessages($flightId, $message = MVT, $messageBody = false){
    $flight = Flight::find($flightId);

    if (isArchiveMessages($flight)){
        if (in_array($message, [ADL, PNL]))
        {
            $messages = \App\Models\Message2018::where("type", $message)
                ->where("parsed", 1)
                ->orderBy('part');
        }
        else {
            $messages = \App\Models\Message2018::where("message", $message);
        }
    }
    else {
        switch($message){
            case MVT:
                $messages = MVTMessage::select();
                break;

            case ADL:
            case PNL:
                $messages   = PNLMessage::select();
                break;

            case PRL:
                $messages   = PRLMessage::select();
                break;

            case LDM:
                $messages   = LDMmessage::select();
                break;

            case UCM:
                $messages   = UCMMessage::select();
                break;

            case PSM:
                $messages   = PSMMessage::select();
                break;

            case PTM:
                $messages   = PTMMessage::select();
                break;

            case CPM:
                $messages   = CPMMessage::select();
                break;

            case LPM:
                $messages   = LPMMessage::select();
                break;

            case TPM:
                $messages   = TPMMessage::select();
                break;

            case SLS:
                $messages   = SLSMessage::select();
                break;

            case HBG:
                $messages   = HBGMessage::select();
                break;

            case LIR:
                $messages   = \App\Models\LIRMessage::select();
                break;

            case CAL:
            case PAL:
                $messages   = \App\Models\CALMessage::select();
                break;

            case CREW_LIST:
                $messages = CrewListMessage::select();
                break;

            case NOT:
                $messages   = OtherMessage::whereIn("type", [NOT, NOTOC]);
                break;

            case LDS:
                $messages   = OtherMessage::whereIn("type", [LDS, LOADSHEET, LOADSHEET_FINAL]);
                break;

            case ONLOAD:
            case OTHS:
                $messages   = OtherMessage::whereNotIn("type", [NOT, NOTOC, LDS, LOADSHEET, LOADSHEET_FINAL]);
                break;

            default:
                return null;
        }

        if (in_array($message, [PRL, PNL]))
        {
            $messages->where("parsed", 1)
                ->orderBy('part');
        }
    }

    $messages = $messages->where("flight_id", $flightId)
        ->orderBy("received_datetime", "DESC")
        ->orderBy("created_at", "DESC")
        ->get();

    if ($messageBody) {

        $readyMessages = [];

        foreach ($messages as $j => $each) {
            $readyMessages[] = Flight::parseMessages($each, $message);
        }

        return $readyMessages;
    }

    return $messages;
}

if (!function_exists("getFlightDepartureDate")) {
    function getFlightDepartureDate($flight, $dateOnly = false, $timeOnly = false)
    {
        $date = NULL;
        if (is_object($flight)) {
            if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                $date = $flight->atd;
            } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                $date = $flight->etd;
            } else if ($flight->ptd && $flight->ptd != EMPTY_DATETIME) {
                $date = $flight->ptd;
            } else if ($flight->std && $flight->std != EMPTY_DATETIME) {
                $date = $flight->std;
            }
            else {
                return null;
            }
        }
        return $dateOnly ? date("Y-m-d", strtotime($date)) : ($timeOnly ? date("H:i", strtotime($date)) : $date);

    }
}

function convertToMVTDateFormat($date, $timeOnly = false)
{
    if (!$date || $date == EMPTY_DATETIME) {
        return "";
    }

    if ($timeOnly) {
        return date("Hi", strtotime($date));
    }

    return date("dHi", strtotime($date));
}


function getAircraftType($aircraftType, $iata = false)
{
    if (!$aircraftType) {
        return "";
    }

    if ($iata){
        return $aircraftType->iata_name ? $aircraftType->iata_name :
            ($aircraftType->icao ? $aircraftType->icao :
                ($aircraftType->name ? $aircraftType->name : ""));
    }

    return $aircraftType->icao ? $aircraftType->icao :
        ($aircraftType->iata_name ? $aircraftType->iata_name :
            ($aircraftType->name ? $aircraftType->name : ""));

}

function getStaffLicenseByID($id, $type = "name")
{
    if (!$id || !$object = \App\Models\License::find($id)) {
        return "";
    }

    return $object->{$type};
}

function getTableDisplayName($auditableType){
    $table = ltrim($auditableType, "App\Models\\");

    switch ($table){
        case "User":
            return "Personal Data";

        case "StaffLicense":
            return "License";

        case "StaffService":
            return "SLA";

        case "UserModule":
            return "Module Permissions";

        case "UserDepartment":
            return "Department/Position";

        case "UserHistory":
            return "Office Duties / Leaves";

        default:
            return $table;
    }
}

function getConditionByID($id, $type = "name")
{
    if (!$id || !$object = \App\Models\Condition::find($id)) {
        return "";
    }

    return $object->{$type};
}

function getLocationAirportByID($id, $type = "iata")
{
    if (!$id || !$object = \App\Models\Location::find($id)) {
        return "";
    }

    return $object->airport->{$type};
}

function getHolidayAirportIDs($holiday){
    if (!$holiday || !$holiday->holidayAirports){
        return null;
    }

    return $holiday->holidayAirports->pluck("airport_id")->all();
}

function getUserRoleByID($id, $type = "label")
{
    if (!$id || !$object = \App\Models\UserRole::find($id)) {
        return "";
    }

    return $object->{$type};
}
function getDepartmentByID($id, $type = "name")
{
    if (!$id || !$object = \App\Models\Department::withTrashed()->find($id)) {
        return "";
    }

    return $object->{$type};
}

function getPositionByID($id, $type = "name")
{
    if (!$id || !$object = \App\Models\Position::withTrashed()->find($id)) {
        return "";
    }

    return $object->{$type};
}

function getModuleByID($id, $type = "name")
{
    if (!$id || !$object = \App\Models\Module::find($id)) {
        return "";
    }

    return $object->{$type};
}

function checkIfModulePermissionIsEnabled($module, $permission){

    $auth = Auth::user();

    $permission = ModulePermission::join("modules", "modules.id", "=", "modules__permissions.module_id")
        ->where("modules.name", $module)
        ->where("modules__permissions.name", $permission)
        ->first([
            "modules__permissions.*"
        ]);

    if (!$permission){
        return true;
    }

    $userModules = UserModule::where("user_id", $auth->id)
        ->where("module_id", $permission->module_id)
        ->where("module_permission_id", $permission->id)
        ->first();

    return $userModules != null;
}

function getModulePermissionByID($id, $type = "name")
{
    if (!$id || !$object = \App\Models\ModulePermission::find($id)) {
        return "";
    }

    return $object->{$type};
}


function getServiceByID($id, $type = "abbr")
{
    if (!$id || !$object = \App\Models\Service::find($id)) {
        return "";
    }

    return $object->{$type};
}

function getAirportById($id){
    if (!$id || !$object = \App\Models\Airport::find($id)) {
        return "";
    }

    return $object->iata;
}

function getAirlineById($id){
    if (!$id || !$object = \App\Models\Airline::find($id)) {
        return "";
    }

    return $object->airline;
}

function getAircraftById($id, $mvtName = false)
{
    if (!$id || !$object = \App\Models\Aircraft::find($id)) {
        return "";
    }

    if ($mvtName) {
        return $object->mvt_name ? $object->mvt_name : ($object->name ? str_replace("-", "", $object->name) : "");
    }

    return $object->name ? $object->name : ($object->mvt_name ? $object->mvt_name : "");
}

function getFlightScheduleInfoById($id)
{
    if (!$id) {
        return "";
    }

    $result = FlightScheduleFlight::join("flights__numbers", "flights__numbers.id", "=", "flights__schedule_flights.flight_number_id")
        ->join("airlines", "airlines.id", "=", "flights__schedule_flights.airline_id")
        ->select([
            DB::raw("CONCAT(s_airlines.iata,'-', flight_number, ' (STD: ', departure_time, ' - STA:', arrival_time, ')') as ns"),
        ])
        ->where("flights__schedule_flights.id", $id)
        ->first([
            "ns"
        ]);

    if (!$result) {
        return "";
    }

    return $result->ns;
}

function getAircraft($aircraft, $mvtName = false)
{
    if (!$aircraft) {
        return "";
    }

    if ($mvtName) {
        return $aircraft->mvt_name ? $aircraft->mvt_name : ($aircraft->name ? str_replace("-", "", $aircraft->name) : "");
    }

    return $aircraft->name ? $aircraft->name : ($aircraft->mvt_name ? $aircraft->mvt_name : "");
}

function getFlightNumber($flight, $delimiter = "-", $withAirlineCode = true, $type = IATA)
{
    $flightNumber = $flight->flightNumber;


    $airline = $withAirlineCode ? (($flightNumber && $flightNumber->airline ? $flightNumber->airline->{$type} : "") . $delimiter)
        : "";

    return $airline . ($flightNumber ? $flightNumber->flight_number : "");
}

function getFlightSector($flight, $type = IATA)
{
    $flightNumber = $flight->flightNumber;
    $depAirport = $flightNumber && $flightNumber->departureAirport ? $flightNumber->departureAirport->{$type} : "";
    $arrAirport = $flightNumber && $flightNumber->arrivalAirport ? $flightNumber->arrivalAirport->{$type} : "";

    return $depAirport . "-" . $arrAirport;
}

function getFlightNumberSector($flightNumber)
{
    $depAirport = $flightNumber && $flightNumber->departureAirport ? $flightNumber->departureAirport->iata : "";
    $arrAirport = $flightNumber && $flightNumber->arrivalAirport ? $flightNumber->arrivalAirport->iata : "";

    return $depAirport . "-" . $arrAirport;
}

function getFlightNumber3Types($flight){
    $fn1 = $fn2 = $fn3 = "";

    if ($flight->flightNumber){
        $fn = $flight->flightNumber->flight_number;
        if ($flight->flightNumber->airline){
            $airline = $flight->flightNumber->airline;
            $fn1 .= $airline->airline." ";

            $fn2 .= $airline->icao;
            $fn3 .= $airline->iata;
        }
        $fn1 .= $fn;

        if ($fn2){
            $fn2 .= $fn;
        }

        if ($fn3){
            $fn3 .= $fn;
        }
    }

    return [
        $fn1, $fn2, $fn3
    ];
}

function getFlightDelaysArrayString($flight){
    $delays = [];
    if ($flight->delays){
        foreach ($flight->delays as $each) {
            $delay = $each->delay;
            if ($delay){
                $delays[] = "Code: ".$delay->code." | ".str_limit($delay->description, 100);
            }
        }
    }

    return $delays;
}

function timeToHours($time, $round = 2, $format = "H:i"){
    $s = explode(":", $time);
    $total = intval($s[0]) + (intval($s[1]) / 60);

    if (isset($s[2])){
        $total += intval($s[2]) / 3600;
    }

    return round($total, 2);
}


function getDelayRoundHours($hrs){
    if (!$hrs){
        return 0;
    }

    $totalHRs = floor($hrs);
    $mins = ($hrs - $totalHRs) * 60;

    if ($mins >= 46){
        return $totalHRs + 1;
    }
    if ($mins >= 31){
        return $totalHRs + 0.75;
    }
    if ($mins >= 16){
        return $totalHRs + 0.5;
    }
    if ($mins >= 1){
        return $totalHRs + 0.25;
    }

    return $totalHRs;
}

function removeFlightNumberDuplications($fn , $airline , $depAp , $arrAp){
    $flightNumbers = FlightNumber::where("flight_number", $fn)
        ->where("departure_airport_id", $depAp)
        ->where("arrival_airport_id", $arrAp)
        ->where("airline_id", $airline)
        ->whereNull("deleted_at")
        ->orderBy("id")
        ->get();

    debug("FOUND TOTAL FNs: ".$flightNumbers->count());

    if ($flightNumbers->count() <= 1){
        return "FOUND 0 or 1 FN";
    }

    $flightNumberOriginal = null;
    $otherIDs = [];
    foreach ($flightNumbers as &$each) {

        if (!$flightNumberOriginal){
            $flightNumberOriginal = $each;
        }
        else {
            $otherIDs[] = $each->id;
        }
    }

    debug("Found : ".count($otherIDs). " FNs");

    if (!count($otherIDs) || !$flightNumberOriginal){
        return "Not found original FN, or other ids are 0";
    }

    $result = [];

    // update
    $result["flt"] = Flight::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);


    $result["fsf"] = FlightScheduleFlight::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["fs"] = FlightStation::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["ft"] = FlightTracker::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["fsf"] = CPMMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["cr"] = CrewListMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["hbg"] = HBGMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["ldm"] = LDMmessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["lpm"] = LPMMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["mvt"] = MVTMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["oth"] = OtherMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["pnl"] = PNLMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["prl"] = PRLMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["psm"] = PSMMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["ptm"] = PTMMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["sls"] = SLSMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["tpm"] = TPMMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["ucm"] = UCMMessage::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["pf"] = PassengerFlight::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["pfa"] = PassengerFlightAct::whereIn("flight_number_id", $otherIDs)
        ->update([
            "flight_number_id" => $flightNumberOriginal->id
        ]);
    debug($result);

    $result["final"] = FlightNumber::whereIn("id", $otherIDs)
        ->update(["deleted_at" => date("Y-m-d H:i:s")]);
    debug($result);
}

function getCancellationDate($flight){
    if ($flight->cancellation_received_at)
        return baseDateFormat($flight->cancellation_received_at);
    elseif ($flight->cancelled_at)
        return baseDateFormat($flight->cancelled_at);
    else
        return "";
}

function getCancellationTime($flight){
    if ($flight->cancellation_received_at)
        return baseTimeFormat($flight->cancellation_received_at);
    elseif ($flight->cancelled_at)
        return baseTimeFormat($flight->cancelled_at);
    else
        return "";
}

function getFlightDelays($flight, $string = false){
    $delays = [];
    $delayTimes = [];
    $totalHours = 0;
    $totalDelayMin = 0;

    if ($flight->delays && count($flight->delays)) {
        foreach ($flight->delays as $eachDelay) {
            $delays[] = $eachDelay->delay->code;
            $delayTimes[] = $eachDelay->duration ? baseTimeFormat($eachDelay->duration) : "00:00";

            if ($eachDelay->duration){
                $totalHours += timeToHours($eachDelay->duration);
                $totalDelayMin += TimeToMinutes($eachDelay->duration);
            }
        }
    }



    if ($string){
        return [
            implode("/", $delays),
            implode("/", $delayTimes),
            getDelayRoundHours($totalHours),
            $totalDelayMin,
        ];
    }

    return [
        $delays,
        $delayTimes,
        getDelayRoundHours($totalHours),
        $totalDelayMin
    ];
}

function getFlightAircraft($flight, $obj = false, $mvtName = false)
{
    if ($obj) {
        return $flight->aircraft;
    }

    return getAircraft($flight->aircraft, $mvtName);
}

function getFlightAircraftType($flight, $obj = false, $iata = false)
{
    $aircraftType = $flight->aircraft ? $flight->aircraft->type : $flight->aircraftType;

    if ($obj) {
        return $aircraftType;
    }

    return getAircraftType($aircraftType, $iata);
}

function getFlightMessageRelation($to, $flight = null){
    if ($flight)
        return strtotime($flight->departure_date) <= strtotime("2022-01-01") ? "message2018" : "message";
    else
        return strtotime($to) <= strtotime("2022-01-01") ? "message2018" : "message";
}


function getFlightNumberType($flightNumber){
    if (!$flightNumber){
        return "";
    }

    return $flightNumber->flightType && $flightNumber->flightType->abbr ? $flightNumber->flightType->abbr : "";
}

function getFlightNumberDepartureAirport($flightNumber)
{
    if (!$flightNumber || !$flightNumber->departureAirport){
        return null;
    }

    return $flightNumber->departureAirport->icao ? $flightNumber->departureAirport->icao : $flightNumber->departureAirport->iata;
}

function getFlightNumberArrivalAirport($flightNumber)
{
    if (!$flightNumber || !$flightNumber->arrivalAirport){
        return null;
    }

    return $flightNumber->arrivalAirport->icao ? $flightNumber->arrivalAirport->icao : $flightNumber->arrivalAirport->iata;
}

function getFlightDepartureAirport($flight, $returnID = false, $iata = false)
{
    if (!$flight){
        return "";
    }

    if ($returnID) {
        return $flight->departure_airport_id ? $flight->departure_airport_id : $flight->flightNumber->departure_airport_id;
    }

    $ap = $flight->departureAirport ? $flight->departureAirport :
        ($flight->flightNumber ? $flight->flightNumber->departureAirport : "");

    if ($iata) {
        return $ap ? $ap->iata : "";
    }

    return $ap;
}



function getFlightArrivalAirport($flight, $returnId = false, $iata = false)
{
    if (!$flight){
        return "";
    }

    if ($returnId) {
        return $flight->arrival_airport_id ? $flight->arrival_airport_id : $flight->flightNumber->arrival_airport_id;
    }

    $ap = $flight->arrivalAirport ? $flight->arrivalAirport :
        ($flight->flightNumber ? $flight->flightNumber->arrivalAirport : "");

    if ($iata) {
        return $ap ? $ap->iata : "";
    }

    return $ap;
}


if (!function_exists("getFlightArrivalDate")) {
    function getFlightArrivalDate($flight, $dateOnly = false, $timeOnly = false)
    {
        $date = NULL;
        if (is_object($flight)) {
            if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                $date = $flight->ata;
            } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                $date = $flight->eta;
            } else if ($flight->pta && $flight->pta != EMPTY_DATETIME) {
                $date = $flight->pta;
            } else if ($flight->sta && $flight->sta != EMPTY_DATETIME) {
                $date = $flight->sta;
            }
            else {
                return null;
            }
        }
        return $dateOnly ? date("Y-m-d", strtotime($date)) : ($timeOnly ? date("H:i", strtotime($date)) : $date);

    }
}

if (!function_exists("getFlightDepartureTimeType")) {
    function getFlightDepartureTimeType($flight, $upperString = false, $withSpan = false)
    {
        $type = NULL;
        if (is_object($flight)) {
            if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                $type = ATD;
            } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                $type = ETD;
            } else if ($flight->ptd && $flight->ptd != EMPTY_DATETIME) {
                $type = PTD;
            } else if ($flight->std && $flight->std != EMPTY_DATETIME) {
                $type = STD;
            }
            else {
                return null;
            }

        }


        $type = $upperString ? strtoupper($type) : $type;

        return $withSpan ? "<span class='badge'>{$type}</span>" : $type;
    }
}

if (!function_exists("getFlightArrivalTimeType")) {
    function getFlightArrivalTimeType($flight, $upperString = false, $withSpan = false)
    {
        $type = NULL;
        if (is_object($flight)) {
            if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                $type = ATA;
            } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                $type = ETA;

            } else if ($flight->pta && $flight->pta != EMPTY_DATETIME) {
                $type = PTA;

            } else if ($flight->sta && $flight->sta != EMPTY_DATETIME) {
                $type = STA;
            }
            else {
                return null;
            }
        }

        $type = $upperString ? strtoupper($type) : $type;

        return $withSpan ? "<span class='badge'>{$type}</span>" : $type;

    }
}


if (!function_exists("getFlightDepartureInitialDate")) {
    function getFlightDepartureInitialDate($flight, $dateOnly = false, $timeOnly = false, $ptdFirst = false)
    {
        $date = NULL;
        if (is_object($flight)) {
            if ($flight->std && $flight->std != EMPTY_DATETIME) {
                $date = $flight->std;
            } else if ($flight->ptd && $flight->ptd != EMPTY_DATETIME) {
                $date = $flight->ptd;
            } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                $date = $flight->etd;
            } else if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                $date = $flight->atd;
            }
            else {
                return null;
            }

        }
        return $dateOnly ? date("Y-m-d", strtotime($date)) : ($timeOnly ? date("H:i", strtotime($date)) : $date);
    }
}


if (!function_exists("getFlightDepartureInitialDatePTD")) {
    function getFlightDepartureInitialDatePTD($flight, $dateOnly = false, $timeOnly = false)
    {
        $date = NULL;
        if (is_object($flight)) {
            if ($flight->ptd && $flight->ptd != EMPTY_DATETIME) {
                $date = $flight->ptd;
            } else if ($flight->std && $flight->std != EMPTY_DATETIME) {
                $date = $flight->std;
            } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                $date = $flight->etd;
            } else if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                $date = $flight->atd;
            }
            else {
                return null;
            }

        }
        return $dateOnly ? date("Y-m-d", strtotime($date)) : ($timeOnly ? date("H:i", strtotime($date)) : $date);
    }
}

if (!function_exists("getFlightDepartureInitialTimeType")) {
    function getFlightDepartureInitialTimeType($flight, $upperString = false)
    {
        $type = "";
        if (is_object($flight)) {
            if ($flight->std && $flight->std != EMPTY_DATETIME) {
                $type = STD;
            } else if ($flight->ptd && $flight->ptd != EMPTY_DATETIME) {
                $type = PTD;
            } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                $type = ETD;
            } elseif ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                $type = ATD;
            }
            else {
                return null;
            }

        }
        return $upperString ? strtoupper($type) : $type;

    }
}

if (!function_exists("getFlightDepartureInitialTimeTypePTD")) {
    function getFlightDepartureInitialTimeTypePTD($flight, $upperString = false, $withSpan = false)
    {
        $type = "";
        if (is_object($flight)) {
            if ($flight->ptd && $flight->ptd != EMPTY_DATETIME) {
                $type = PTD;
            } else if ($flight->std && $flight->std != EMPTY_DATETIME) {
                $type = STD;
            } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                $type = ETD;
            } elseif ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                $type = ATD;
            }
            else {
                return null;
            }
        }

        $type = $upperString ? strtoupper($type) : $type;

        return $withSpan ? "<span class='badge'>{$type}</span>" : $type;
    }
}

if (!function_exists("getFlightArrivalInitialDate")) {
    function getFlightArrivalInitialDate($flight, $dateOnly = false, $timeOnly = false)
    {
        $date = NULL;
        if (is_object($flight)) {
            if ($flight->sta && $flight->sta != EMPTY_DATETIME) {
                $date = $flight->sta;
            } else if ($flight->pta && $flight->pta != EMPTY_DATETIME) {
                $date = $flight->pta;
            } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                $date = $flight->eta;
            } else if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                $date = $flight->ata;
            }
            else {
                return null;
            }
        }

        return $dateOnly ? date("Y-m-d", strtotime($date)) : ($timeOnly ? date("H:i", strtotime($date)) : $date);
    }
}

function getParentFlight($flight){
    if (!$flight->parent_id){
        return null;
    }

    $parent = \App\Models\Flight::find($flight->parent_id);

    if ($parent->deleted_at || ($parent->cancelled_at && !$parent->sod_completed)){
        return null;
    }

    return $parent;
}

if (!function_exists("getFlightArrivalInitialDatePTA")) {
    function getFlightArrivalInitialDatePTA($flight, $dateOnly = false, $timeOnly = false)
    {
        $date = NULL;
        if (is_object($flight)) {
            if ($flight->pta && $flight->pta != EMPTY_DATETIME) {
                $date = $flight->pta;
            } else if ($flight->sta && $flight->sta != EMPTY_DATETIME) {
                $date = $flight->sta;
            } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                $date = $flight->eta;
            } else if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                $date = $flight->ata;
            }
            else {
                return null;
            }
        }

        return $dateOnly ? date("Y-m-d", strtotime($date)) : ($timeOnly ? date("H:i", strtotime($date)) : $date);
    }
}

if (!function_exists("getFlightArrivalInitialTimeType")) {
    function getFlightArrivalInitialTimeType($flight, $upperString = false)
    {
        $type = "";
        if (is_object($flight)) {
            if ($flight->sta && $flight->sta != EMPTY_DATETIME) {
                $type = STA;
            } else if ($flight->pta && $flight->pta != EMPTY_DATETIME) {
                $type = PTA;
            } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                $type = ETA;
            } else if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                $type = ATA;
            }
            else {
                return null;
            }
        }
        return $upperString ? strtoupper($type) : $type;
    }
}

if (!function_exists("getFlightArrivalInitialTimeTypePTA")) {
    function getFlightArrivalInitialTimeTypePTA($flight, $upperString = false, $withSpan = false)
    {
        $type = "";
        if (is_object($flight)) {
            if ($flight->pta && $flight->pta != EMPTY_DATETIME) {
                $type = PTA;
            } else if ($flight->sta && $flight->sta != EMPTY_DATETIME) {
                $type = STA;
            } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                $type = ETA;
            } else if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                $type = ATA;
            }
            else {
                return null;
            }
        }

        $type = $upperString ? strtoupper($type) : $type;

        return $withSpan ? "<span class='badge'>{$type}</span>" : $type;
//        return $withSpan ? "<span class='label label-primary'>{$type}</span>" : $type;
    }
}

function actualTimeAccess($pln, $act){
    if (!$pln || !$act){
        return false;
    }

    return strtotime($act) > strtotime($pln);
}

function departureArrivalTypeSpan($type, $float = "right", $display = "inline-block", $fontSize = "90%")
{
    if ($type) {
        switch (strtolower($type)) {
            case STD:
                $messageType = 'primary';
                break;
            case ETD:
                $messageType = 'warning';
                break;
            case ATD:
                $messageType = 'primary';
                break;

            case STA:
                $messageType = 'primary';
                break;
            case ETA:
                $messageType = 'warning';
                break;
            case ATA:
                $messageType = 'primary';
                break;
            default:
                $messageType = 'info';
        }

        if ($float){
            return "<span id='flt_dep_arr_span' style='float: {$float}; font-size: {$fontSize}' class='label label-$messageType departureArrivalType'>" . strtoupper($type) . "</span>";
        }

        return "<span id='flt_dep_arr_span' style='display:{$display}; font-size: {$fontSize}' class='label label-$messageType departureArrivalType'>" . strtoupper($type) . "</span>";

    }
    return false;
}


function isFlightDelayed($flight, $ghaModule){
    if (!$flight || !is_object($flight)){
        return false;
    }

    $depDiff = null;
    $delayTimeMin = 0;
    if ($ghaModule)
    {
        $initDep = getFlightDepartureInitialDate($flight);
        $airline = $flight->flightNumber ? $flight->flightNumber->airline : null;
        $delayTimeMin = $airline && $airline->delay_tolerance ? $airline->delay_tolerance : 0; // && $airlineID != 470 ? 0 : 3;
    }
    // DELAY POINT IS PTD FOR AIRLINES
    else
    {
        $initDep = getFlightDepartureInitialDatePTD($flight);
    }

    if ($initDep) {
        if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
            $depDiff = round((strtotime($flight->atd) - strtotime($initDep)) / 60);
        }
        else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
            $depDiff = round((strtotime($flight->etd) - strtotime($initDep)) / 60);
        }
    }

    return $depDiff !== null && $depDiff > $delayTimeMin ? hoursToTime($depDiff / 60, true) : false;
}

function getFlightDelayFromStaToAta($flight){
    $initDep = getFlightArrivalInitialDate($flight);

    if (!$initDep || !$flight->ata || $flight->ata == EMPTY_DATETIME){
        return "";
    }

    $depDiff = round((strtotime($flight->ata) - strtotime($initDep)) / 60);
    if ($depDiff <= 0){
        return "";
    }

    return $depDiff;
}

/**
 * Used in Flight Comms
 * @param $flight
 * @return bool
 */
function isFlightDelayedStrict($flight, $ghaModule){
    if (!$flight || !is_object($flight)){
        return false;
    }

    $depDiff = null;

    if (count($flight->delays)){
        return true;
    }

    if ($ghaModule)
    {
        $initDep = getFlightDepartureInitialDate($flight);
    }
    // DELAY POINT IS PTD FOR AIRLINES
    else
    {
        $initDep = getFlightDepartureInitialDatePTD($flight);
    }

    if ($initDep) {
        if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
            $depDiff = round((strtotime($flight->atd) - strtotime($initDep)) / 60);
        }
        else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
            $depDiff = round((strtotime($flight->etd) - strtotime($initDep)) / 60);
        }
    }

    return $depDiff !== null && $depDiff >= 1;
}

if (!function_exists("getFlightClassName")) {
    function getFlightClassName($flight, $ghaModule, $airline = null)
    {
        // A3 -> 5mins,  BT, EI, IB -> 3mins exception
        //$delayTimeMin = $airlineID ? ($airlineID == 209 ? 5 : (in_array($airlineID, [270, 349, 470]) ? 3 : 0)) : 0;
        $delayTimeMin = $airline && $airline->delay_tolerance ? $airline->delay_tolerance : 0;

        $className = "available";
        if (is_object($flight)) {
            $depDiff = $arrDiff = null;

            if ($ghaModule) {
                $initDep = getFlightDepartureInitialDate($flight);
                $initArr = getFlightArrivalInitialDate($flight);
            }
            // DELAY POINT IS PTD FOR AIRLINES
            else {
                $initDep = getFlightDepartureInitialDatePTD($flight);
                $initArr = getFlightArrivalInitialDatePTA($flight);
            }

            $atd = $ata = $etd = $eta = null;
            if ($initDep) {
                if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                    $depDiff = round((strtotime($flight->atd) - strtotime($initDep)) / 60);
                    $atd = true;
                } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                    $depDiff = round((strtotime($flight->etd) - strtotime($initDep)) / 60);
                    $etd = true;
                }
            }

            if ($initArr) {
                if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                    $arrDiff = round((strtotime($flight->ata) - strtotime($initArr)) / 60);
                    $ata = true;
                } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                    $arrDiff = round((strtotime($flight->eta) - strtotime($initArr)) / 60);
                    $eta = true;
                }
            }

            if ($flight->cancelled_at) {
                $className = "cancelled";
            }
            else if ($flight->deleted_at) {
                $className = "deleted";
            }
            else if ($flight->is_diversion) {
                $className = "diversion";
                if (count($flight->delays)) {
                    $className .= " delayed";
                }
            }
            else if ($flight->created_by_email && (!$flight->std || !$flight->sta)) {
                $className = "created_by_email";
            } /*
            else if (count($flight->delays))
            {
                $className = "delayed".($arrDiff !== null && $arrDiff <= 3 ? "-on_time" : "");
            }
            */
            else if ($depDiff !== null) {
                if ($depDiff > $delayTimeMin) {
                    $className = $atd ? "delayed" : "et_delayed";

                    if ($processed = ($arrDiff !== null)) {
                        $className .= ($arrDiff <= $delayTimeMin ? ($ata ? "-on_time" : "-et_on_time") :
                            ($eta ? "-et_on_time" : ""));
                    }
                }
                else {
                    $className = $atd ? "on_time" : "et_on_time";
                    if ($processed = ($arrDiff !== null)) {
                        $className .= ($arrDiff > $delayTimeMin ? ($ata ? "-delayed" : "-et_delayed") :
                            ($ata ? ($className != "on_time" ? "-on_time" : "") :
                                ($className != "et_on_time" ? "-et_on_time" : "")));
                    }
                }

                if (!$processed) {
                    $className .= $flight->edited_by_email ? "-edited_by_email" : "-available";
                }
            }
            else if ($arrDiff !== null) {
                $className = $flight->edited_by_email ? "edited_by_email-" : "available-";

                if ($ata){
                    $className .= $arrDiff > $delayTimeMin ? "delayed" : "on_time";
                }
                else {
                    $className .= $arrDiff > $delayTimeMin ? "et_delayed" : "et_on_time";
                }
            }
            else if ($flight->edited_by_email) {
                $className = "edited_by_email";
            }
            else if (!$flight->flight_schedule_id && $flight->created_by) {
                $className = "manually_created";
            }
            else if ($flight->updated_at) {
                $className = "edited";
            }
        }
        return $className;
    }
}

if (!function_exists("getStaffWatchBoxClassName")) {
    function getStaffWatchBoxClassName($airlineService, $flight, $airline = null)
    {
        return strtolower($airlineService->sla). "-". ($flight->serviceData["serviceType"] == ARRIVAL_SERVICE ? "arrival" : "departure");
    }
}

if (!function_exists("getFlightClassNameStrict")) {
    function getFlightClassNameStrict($flight, $fltType)
    {
        $className = "available";
        if (is_object($flight)) {
            $depDiff = $arrDiff = null;

            // DELAY POINT IS PTD FOR AIRLINES
            if (airlineModule()) {
                $initDep = getFlightDepartureInitialDatePTD($flight);
                $initArr = getFlightArrivalInitialDatePTA($flight);
            } else {
                $initDep = getFlightDepartureInitialDate($flight);
                $initArr = getFlightArrivalInitialDate($flight);
            }

            if ($fltType == DEPARTURE){
                if ($initDep) {
                    if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                        $depDiff = round((strtotime($flight->atd) - strtotime($initDep)) / 60);
                    } else if ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                        $depDiff = round((strtotime($flight->etd) - strtotime($initDep)) / 60);
                    }
                    if ($depDiff !== null) {
                        $className = $depDiff > 3 ? "delayed" : "on_time";
                    }
                }
            }
            else {
                if ($initArr) {
                    if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                        $arrDiff = round((strtotime($flight->ata) - strtotime($initArr)) / 60);
                    } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                        $arrDiff = round((strtotime($flight->eta) - strtotime($initArr)) / 60);
                    }

                    if ($arrDiff !== null) {
                        $className = $arrDiff > 3 ? "delayed" : "on_time";
                    }
                }
            }

        }
        return $className;
    }
}


function CountryList()
{
    return [
        "Afghanistan" => "Afghanistan",
        "Albania" => "Albania",
        "Algeria" => "Algeria",
        "Andorra" => "Andorra",
        "Angola" => "Angola",
        "Antigua and Barbuda" => "Antigua and Barbuda",
        "Argentina" => "Argentina",
        "Armenia" => "Armenia",
        "Australia" => "Australia",
        "Austria" => "Austria",
        "Azerbaijan" => "Azerbaijan",
        "Bahamas" => "Bahamas",
        "Bahrain" => "Bahrain",
        "Bangladesh" => "Bangladesh",
        "Barbados" => "Barbados",
        "Belarus" => "Belarus",
        "Belgium" => "Belgium",
        "Belize" => "Belize",
        "Benin" => "Benin",
        "Bhutan" => "Bhutan",
        "Bolivia" => "Bolivia",
        "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
        "Botswana" => "Botswana",
        "Brazil" => "Brazil",
        "Brunei" => "Brunei",
        "Bulgaria" => "Bulgaria",
        "Burkina Faso" => "Burkina Faso",
        "Burundi" => "Burundi",
        "Cambodia" => "Cambodia",
        "Cameroon" => "Cameroon",
        "Canada" => "Canada",
        "Cape Verde" => "Cape Verde",
        "Central African Republic" => "Central African Republic",
        "Chad" => "Chad",
        "Chile" => "Chile",
        "China" => "China",
        "Colombi" => "Colombi",
        "Comoros" => "Comoros",
        "Congo (Brazzaville)" => "Congo (Brazzaville)",
        "Congo" => "Congo",
        "Costa Rica" => "Costa Rica",
        "Cote d'Ivoire" => "Cote d'Ivoire",
        "Croatia" => "Croatia",
        "Cuba" => "Cuba",
        "Cyprus" => "Cyprus",
        "Czech Republic" => "Czech Republic",
        "Denmark" => "Denmark",
        "Djibouti" => "Djibouti",
        "Dominica" => "Dominica",
        "Dominican Republic" => "Dominican Republic",
        "East Timor (Timor Timur)" => "East Timor (Timor Timur)",
        "Ecuador" => "Ecuador",
        "Egypt" => "Egypt",
        "El Salvador" => "El Salvador",
        "Equatorial Guinea" => "Equatorial Guinea",
        "Eritrea" => "Eritrea",
        "Estonia" => "Estonia",
        "Ethiopia" => "Ethiopia",
        "Fiji" => "Fiji",
        "Finland" => "Finland",
        "France" => "France",
        "Gabon" => "Gabon",
        "Gambia The" => "Gambia, The",
        "Georgia" => "Georgia",
        "Germany" => "Germany",
        "Ghana" => "Ghana",
        "Greece" => "Greece",
        "Grenada" => "Grenada",
        "Guatemala" => "Guatemala",
        "Guinea" => "Guinea",
        "Guinea-Bissau" => "Guinea-Bissau",
        "Guyana" => "Guyana",
        "Haiti" => "Haiti",
        "Honduras" => "Honduras",
        "Hungary" => "Hungary",
        "Iceland" => "Iceland",
        "India" => "India",
        "Indonesia" => "Indonesia",
        "Iran" => "Iran",
        "Iraq" => "Iraq",
        "Ireland" => "Ireland",
        "Israel" => "Israel",
        "Italy" => "Italy",
        "Jamaica" => "Jamaica",
        "Japan" => "Japan",
        "Jordan" => "Jordan",
        "Kazakhstan" => "Kazakhstan",
        "Kenya" => "Kenya",
        "Kiribati" => "Kiribati",
        "Korea North" => "Korea, North",
        "Korea South" => "Korea, South",
        "Kuwait" => "Kuwait",
        "Kyrgyzstan" => "Kyrgyzstan",
        "Laos" => "Laos",
        "Latvia" => "Latvia",
        "Lebanon" => "Lebanon",
        "Lesotho" => "Lesotho",
        "Liberia" => "Liberia",
        "Libya" => "Libya",
        "Liechtenstein" => "Liechtenstein",
        "Lithuania" => "Lithuania",
        "Luxembourg" => "Luxembourg",
        "Macedonia" => "Macedonia",
        "Madagascar" => "Madagascar",
        "Malawi" => "Malawi",
        "Malaysia" => "Malaysia",
        "Maldives" => "Maldives",
        "Mali" => "Mali",
        "Malta" => "Malta",
        "Marshall Islands" => "Marshall Islands",
        "Mauritania" => "Mauritania",
        "Mauritius" => "Mauritius",
        "Mexico" => "Mexico",
        "Micronesia" => "Micronesia",
        "Moldova" => "Moldova",
        "Monaco" => "Monaco",
        "Mongolia" => "Mongolia",
        "Morocco" => "Morocco",
        "Mozambique" => "Mozambique",
        "Myanmar" => "Myanmar",
        "Namibia" => "Namibia",
        "Nauru" => "Nauru",
        "Nepal" => "Nepal",
        "Netherlands" => "Netherlands",
        "New Zealand" => "New Zealand",
        "Nicaragua" => "Nicaragua",
        "Niger" => "Niger",
        "Nigeria" => "Nigeria",
        "Norway" => "Norway",
        "Oman" => "Oman",
        "Pakistan" => "Pakistan",
        "Palau" => "Palau",
        "Panama" => "Panama",
        "Papua New Guinea" => "Papua New Guinea",
        "Paraguay" => "Paraguay",
        "Peru" => "Peru",
        "Philippines" => "Philippines",
        "Poland" => "Poland",
        "Portugal" => "Portugal",
        "Qatar" => "Qatar",
        "Romania" => "Romania",
        "Russia" => "Russia",
        "Rwanda" => "Rwanda",
        "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
        "Saint Lucia" => "Saint Lucia",
        "Saint Vincent" => "Saint Vincent",
        "Samoa" => "Samoa",
        "San Marino" => "San Marino",
        "Sao Tome and Principe" => "Sao Tome and Principe",
        "Saudi Arabia" => "Saudi Arabia",
        "Senegal" => "Senegal",
        "Serbia and Montenegro" => "Serbia and Montenegro",
        "Seychelles" => "Seychelles",
        "Sierra Leone" => "Sierra Leone",
        "Singapore" => "Singapore",
        "Slovakia" => "Slovakia",
        "Slovenia" => "Slovenia",
        "Solomon Islands" => "Solomon Islands",
        "Somalia" => "Somalia",
        "South Africa" => "South Africa",
        "Spain" => "Spain",
        "Sri Lanka" => "Sri Lanka",
        "Sudan" => "Sudan",
        "Suriname" => "Suriname",
        "Swaziland" => "Swaziland",
        "Sweden" => "Sweden",
        "Switzerland" => "Switzerland",
        "Syria" => "Syria",
        "Taiwan" => "Taiwan",
        "Tajikistan" => "Tajikistan",
        "Tanzania" => "Tanzania",
        "Thailand" => "Thailand",
        "Togo" => "Togo",
        "Tonga" => "Tonga",
        "Trinidad and Tobago" => "Trinidad and Tobago",
        "Tunisia" => "Tunisia",
        "Turkey" => "Turkey",
        "Turkmenistan" => "Turkmenistan",
        "Tuvalu" => "Tuvalu",
        "Uganda" => "Uganda",
        "Ukraine" => "Ukraine",
        "United Arab Emirates" => "United Arab Emirates",
        "United Kingdom" => "United Kingdom",
        "United States" => "United States",
        "Uruguay" => "Uruguay",
        "Uzbekistan" => "Uzbekistan",
        "Vanuatu" => "Vanuatu",
        "Vatican City" => "Vatican City",
        "Venezuela" => "Venezuela",
        "Vietnam" => "Vietnam",
        "Yemen" => "Yemen",
        "Zambia" => "Zambia",
        "Zimbabwe" => "Zimbabwe"
    ];
}

if (!function_exists("nationalities")) {
    function nationalities()
    {
        return [
            "afghan" => "Afghan",
            "albanian" => "Albanian",
            "algerian" => "Algerian",
            "american" => "American",
            "andorran" => "Andorran",
            "angolan" => "Angolan",
            "antiguans" => "Antiguans",
            "argentinean" => "Argentinean",
            "armenian" => "Armenian",
            "australian" => "Australian",
            "austrian" => "Austrian",
            "azerbaijani" => "Azerbaijani",
            "bahamian" => "Bahamian",
            "bahraini" => "Bahraini",
            "bangladeshi" => "Bangladeshi",
            "barbadian" => "Barbadian",
            "barbudans" => "Barbudans",
            "batswana" => "Batswana",
            "belarusian" => "Belarusian",
            "belgian" => "Belgian",
            "belizean" => "Belizean",
            "beninese" => "Beninese",
            "bhutanese" => "Bhutanese",
            "bolivian" => "Bolivian",
            "bosnian" => "Bosnian",
            "brazilian" => "Brazilian",
            "british" => "British",
            "bruneian" => "Bruneian",
            "bulgarian" => "Bulgarian",
            "burkinabe" => "Burkinabe",
            "burmese" => "Burmese",
            "burundian" => "Burundian",
            "cambodian" => "Cambodian",
            "cameroonian" => "Cameroonian",
            "canadian" => "Canadian",
            "cape verdean" => "Cape Verdean",
            "central african" => "Central African",
            "chadian" => "Chadian",
            "chilean" => "Chilean",
            "chinese" => "Chinese",
            "colombian" => "Colombian",
            "comoran" => "Comoran",
            "congolese" => "Congolese",
            "costa rican" => "Costa Rican",
            "croatian" => "Croatian",
            "cuban" => "Cuban",
            "cypriot" => "Cypriot",
            "czech" => "Czech",
            "danish" => "Danish",
            "djibouti" => "Djibouti",
            "dominican" => "Dominican",
            "dutch" => "Dutch",
            "east timorese" => "East Timorese",
            "ecuadorean" => "Ecuadorean",
            "egyptian" => "Egyptian",
            "emirian" => "Emirian",
            "equatorial guinean" => "Equatorial Guinean",
            "eritrean" => "Eritrean",
            "estonian" => "Estonian",
            "ethiopian" => "Ethiopian",
            "fijian" => "Fijian",
            "filipino" => "Filipino",
            "finnish" => "Finnish",
            "french" => "French",
            "gabonese" => "Gabonese",
            "gambian" => "Gambian",
            "georgian" => "Georgian",
            "german" => "German",
            "ghanaian" => "Ghanaian",
            "greek" => "Greek",
            "grenadian" => "Grenadian",
            "guatemalan" => "Guatemalan",
            "guinea-bissauan" => "Guinea-Bissauan",
            "guinean" => "Guinean",
            "guyanese" => "Guyanese",
            "haitian" => "Haitian",
            "herzegovinian" => "Herzegovinian",
            "honduran" => "Honduran",
            "hungarian" => "Hungarian",
            "icelander" => "Icelander",
            "indian" => "Indian",
            "indonesian" => "Indonesian",
            "iranian" => "Iranian",
            "iraqi" => "Iraqi",
            "irish" => "Irish",
            "israeli" => "Israeli",
            "italian" => "Italian",
            "ivorian" => "Ivorian",
            "jamaican" => "Jamaican",
            "japanese" => "Japanese",
            "jordanian" => "Jordanian",
            "kazakhstani" => "Kazakhstani",
            "kenyan" => "Kenyan",
            "kittian and nevisian" => "Kittian and Nevisian",
            "kuwaiti" => "Kuwaiti",
            "kyrgyz" => "Kyrgyz",
            "laotian" => "Laotian",
            "latvian" => "Latvian",
            "lebanese" => "Lebanese",
            "liberian" => "Liberian",
            "libyan" => "Libyan",
            "liechtensteiner" => "Liechtensteiner",
            "lithuanian" => "Lithuanian",
            "luxembourger" => "Luxembourger",
            "macedonian" => "Macedonian",
            "malagasy" => "Malagasy",
            "malawian" => "Malawian",
            "malaysian" => "Malaysian",
            "maldivan" => "Maldivan",
            "malian" => "Malian",
            "maltese" => "Maltese",
            "marshallese" => "Marshallese",
            "mauritanian" => "Mauritanian",
            "mauritian" => "Mauritian",
            "mexican" => "Mexican",
            "micronesian" => "Micronesian",
            "moldovan" => "Moldovan",
            "monacan" => "Monacan",
            "mongolian" => "Mongolian",
            "moroccan" => "Moroccan",
            "mosotho" => "Mosotho",
            "motswana" => "Motswana",
            "mozambican" => "Mozambican",
            "namibian" => "Namibian",
            "nauruan" => "Nauruan",
            "nepalese" => "Nepalese",
            "new zealander" => "New Zealander",
            "ni-vanuatu" => "Ni-Vanuatu",
            "nicaraguan" => "Nicaraguan",
            "nigerien" => "Nigerien",
            "north korean" => "North Korean",
            "northern irish" => "Northern Irish",
            "norwegian" => "Norwegian",
            "omani" => "Omani",
            "pakistani" => "Pakistani",
            "palauan" => "Palauan",
            "panamanian" => "Panamanian",
            "papua new guinean" => "Papua New Guinean",
            "paraguayan" => "Paraguayan",
            "peruvian" => "Peruvian",
            "polish" => "Polish",
            "portuguese" => "Portuguese",
            "qatari" => "Qatari",
            "romanian" => "Romanian",
            "russian" => "Russian",
            "rwandan" => "Rwandan",
            "saint lucian" => "Saint Lucian",
            "salvadoran" => "Salvadoran",
            "samoan" => "Samoan",
            "san marinese" => "San Marinese",
            "sao tomean" => "Sao Tomean",
            "saudi" => "Saudi",
            "scottish" => "Scottish",
            "senegalese" => "Senegalese",
            "serbian" => "Serbian",
            "seychellois" => "Seychellois",
            "sierra leonean" => "Sierra Leonean",
            "singaporean" => "Singaporean",
            "slovakian" => "Slovakian",
            "slovenian" => "Slovenian",
            "solomon islander" => "Solomon Islander",
            "somali" => "Somali",
            "south african" => "South African",
            "south korean" => "South Korean",
            "spanish" => "Spanish",
            "sri lankan" => "Sri Lankan",
            "sudanese" => "Sudanese",
            "surinamer" => "Surinamer",
            "swazi" => "Swazi",
            "swedish" => "Swedish",
            "swiss" => "Swiss",
            "syrian" => "Syrian",
            "taiwanese" => "Taiwanese",
            "tajik" => "Tajik",
            "tanzanian" => "Tanzanian",
            "thai" => "Thai",
            "togolese" => "Togolese",
            "tongan" => "Tongan",
            "trinidadian or tobagonian" => "Trinidadian or Tobagonian",
            "tunisian" => "Tunisian",
            "turkish" => "Turkish",
            "tuvaluan" => "Tuvaluan",
            "ugandan" => "Ugandan",
            "ukrainian" => "Ukrainian",
            "uruguayan" => "Uruguayan",
            "uzbekistani" => "Uzbekistani",
            "venezuelan" => "Venezuelan",
            "vietnamese" => "Vietnamese",
            "welsh" => "Welsh",
            "yemenite" => "Yemenite",
            "zambian" => "Zambian",
            "zimbabwean" => "Zimbabwean"
        ];
    }
}


function setFdpAndReportTimes(&$crewFlights, $crewType, $locationRepository)
{

    switch ($crewType) {
        case FCM_CREW:
            $crew = new FCM($locationRepository);
            $crew->addFlights($crewFlights);
            return $crew->getFdpList();
            break;
        case CCM_CREW:
            $crew = new CCM($locationRepository);
            $crew->addFlights($crewFlights);
            $crew->debugFdpList();
            return $crew->getFdpList();
            break;
    }
}

function calculateFdpTotalTimes($fdpFlights)
{
    $fdpFlightsTotal = new stdClass();
    $fdpFlightsTotal->other_time = 0;
    $fdpFlightsTotal->flight_time = 0;
    $fdpFlightsTotal->flying_time = 0;
    $fdpFlightsTotal->fdp_total_time = 0;
    $fdpFlightsTotal->fdp_max_time = 0;

    foreach ($fdpFlights as $each) {
        $fdpFlightsTotal->other_time += $each->getOtherTime();
        $fdpFlightsTotal->flight_time += $each->getFlightTime();
        $fdpFlightsTotal->flying_time += $each->getFlyingTime();
        $fdpFlightsTotal->fdp_total_time += $each->getCurrentFdpTime();
        $fdpFlightsTotal->fdp_max_time += $each->getMaxFdpTime();
    }
    return $fdpFlightsTotal;
}

if (!function_exists("getFlightTime")) {
    function getFlightTime($flight, $flight_time = null, $hours_minutes_separated = null)
    {
        if (!is_object($flight)) {
            return isset($hours_minutes_separated) ? ['h' => 0, 'm' => 0] : "00:00";
        }
        if ($flight->is_standby || $flight->is_dhc) {
            return '-';
        }
        if (isset($flight_time)) {

            if ($flight->abn && $flight->tdn) {
                $start = new DateTime($flight->abn);
                $end = new DateTime($flight->tdn);
            } else {
                return "-";
            }
        } else {
            if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME) {
                $start = new DateTime($flight->atd);
                $end = new DateTime($flight->ata);
            } else {
                $start = new DateTime($flight->std);
                $end = new DateTime($flight->sta);
            }
        }
        $diff = $end->diff($start);

        return isset($hours_minutes_separated) ? ['h' => $diff->format("%h"), 'm' => $diff->format("%i")] : $diff->format("%H:%I");
    }
}

/**
 * Redirect to 404 Page If Not Exists|Null|Empty String
 * @param $variable
 * @return \Illuminate\View\View
 */
function RedirectTo404IfNot($variable)
{
    if (!$variable || $variable == '' || is_null($variable)) {
        return redirect("error/getPageNotFound");
    }
}

/**
 * Profile Photo Save
 * @param $user
 * @param bool $redirect
 * @param bool $url
 * @return $this|\Illuminate\Http\RedirectResponse|string
 */
function profilePhoto($user, $redirect = false, $url = false, $imgFolder = 'users')
{
    $message = false;
    if (\request()->has('imageDelete')) {
        $user->picture = null;
        $user->thumb = null;
        $user->save();

        \Flash::success("Profile Photo Successfully Deleted");
    } else {
        if (\request()->hasFile('profile_image')) {
            $rules = ['file' => 'required|image|mimes:jpeg,jpg,png,bmp,gif,svg'];
            $file = ['file' => \request()->file('profile_image')];
            $validator = Validator::make($file, $rules);

            if ($validator->fails()) {
                $message = is_array($validator) ? implode(', ', $validator) : $validator;
                if ($redirect) {
                    return redirect($url)
                        ->withInput()
                        ->withErrors($validator);
                }
            } else {

                $fileName = $user->id . "." . $file['file']->getClientOriginalExtension();
                $fileNameThumb = $user->id . '_thumb' . "." . $file['file']->getClientOriginalExtension();
                $pathFile = public_path('assets/img/' . $imgFolder . '/' . $fileName);
                $pathFileThumb = public_path('assets/img/' . $imgFolder . '/' . $fileNameThumb);

                // Picture Save
                saveProfilePhoto($file['file'], $pathFile, null, 300, 80);
                // Thumb Save`
                saveProfilePhoto($file['file'], $pathFileThumb, null, 100, 80);

                $user->picture = $fileName;
                $user->thumb = $fileNameThumb;
                $user->save();

                $message = "Profile Photo Successfully Updated";

                if ($redirect) {
                    return redirect($url)
                        ->withInput()
                        ->with("message", $message);
                }

            }
        } else {
            $message = "Please Choose Picture";
            if ($redirect) {
                return redirect($url)
                    ->withInput()
                    ->withErrors([$message]);
            }
        }
    }
    return $message;
}


function saveProfilePhoto($file, $pathFile, $resizeWidth = null, $resizeHeight = null, $imgQuality = 100)
{
    $result = Image::make($file->getRealPath())->resize($resizeWidth, $resizeHeight, function ($constraint) {
        $constraint->aspectRatio();
        $constraint->upsize();
    })->save($pathFile, $imgQuality);
    return $result;
}


function saveUploadedPhoto($file, $pathFile, $resizeWidth = null, $resizeHeight = null, $imgQuality = 100, $crop = FALSE)
{

    $result = Image::make($file);

    if ($crop) {
        // Crop
        $result->crop((int)$crop->width, (int)$crop->height, (int)$crop->x, (int)$crop->y);
    }

    if ($resizeWidth || $resizeHeight) {
        $result->resize($resizeWidth, $resizeHeight, function ($constraint) {
            $constraint->aspectRatio();
            $constraint->upsize();
        });
    }

    $result->save($pathFile, $imgQuality);

    return $result;
}

function getModulePermission()
{
    $url = \request()->path();
    $userModules = Session::get('userModules');
    $module = Module::where('link', $url)->first();

    if (count($module)) {
        $permissions = ModulePermission::where('module_id', $module->id)->pluck('id')->all();
    }

    return [$userModules, $module, $permissions];
}


function getCrewPosition($user)
{
    if (!is_object($user)) {
        throw new Exception("User must be object type");
    }

    $position = $user->position[0] ? trim($user->position[0]->name) : null;

    if ($position && in_array($position->type, [CCM_PSR_TYPE_ID, CCM_CC_TYPE_ID, FCM_CPT_TYPE_ID, FCM_FA_TYPE_ID])) {
        if ($user->is_standby){
            $message = "Standby " . $user->position_title . "-" . ($user->position_order + 1);
        }
        elseif ($user->is_dhc){
            $message = "DHC";
        }
        else{
            $message = $user->position_title . "-" . ($user->position_order + 1);
        }
    }
    else {
        if ($user->is_standby){
            $message = "Standby";
        }
        elseif ($user->is_dhc){
            $message = "DHC";
        }
        else{
            $message = ($user->position_order == 0) ? "Purser" : ($user->position_order + 1);
        }
    }

    return $message;
}

/**
 * Check If User is Flight Or Cabin Crew
 * @param $user
 * @return bool
 * @throws Exception
 */
function checkIfCrew($user)
{
    if (!is_object($user)) {
        throw new Exception("User must be object type");
    }
    $usersDepartment = UserDepartment::with(["position"])
        ->where('user_id', $user->id)
        ->first();

    $position = $usersDepartment->position;

    if (!$position){
        return false;
    }

    if (in_array($position->type, [CCM_PSR_TYPE_ID, CCM_CC_TYPE_ID, FCM_CPT_TYPE_ID, FCM_FA_TYPE_ID]))
    {
        return true;
    }

    return false;
}

if (!function_exists("getFlightFlySeconds")) {
    function getFlightFlySeconds($flight)
    {
        if (!is_object($flight)) {
            throw new Exception("Flight must be object type");
        }
        if ($flight->atd && $flight->atd != EMPTY_DATETIME && $flight->ata && $flight->ata != EMPTY_DATETIME) {
            $start = $flight->atd;
            $end = $flight->ata;
        } else if ($flight->std && $flight->std != EMPTY_DATETIME && $flight->sta && $flight->sta != EMPTY_DATETIME) {
            $start = $flight->std;
            $end = $flight->sta;
        } else {
            throw new Exception("Not found required data in flight object");
        }

        return strtotime($end) - strtotime($start);
    }
}

if (!function_exists("convertToHoursMinutes")) {
    function convertToHoursMinutes($seconds, $ready = false)
    {
        if ($seconds || $seconds === 0){
            $hours = floor($seconds / 3600);
            $mins = floor(($seconds - ($hours * 3600)) / 60);

            if ($ready) {
                return ($hours < 10 ? "0" . $hours : $hours) . ":" . ($mins < 10 ? "0" . $mins : $mins);
            }
            else {
                return [
                    "hours" => $hours,
                    "minutes" => floor(($seconds - ($hours * 3600)) / 60),
                    "seconds" => floor($seconds % 60)
                ];
            }
        }

        return NULL;
    }
}

if (!function_exists("printComparison")) {

    function printComparison($array, $class, $sign = NULL)
    {
        if (isset($sign)) {
            $sign = $sign;
        } else {
            $sign = "";
        }
        foreach ($array as $item) {
            $vars[] = $item;
        }

        if ($vars[0] == 0 && $vars[1] == 0) {
            $diff = "";
        } else if ($vars[0] == 0) {
            $diff = -100;
        } else if ($vars[1] == 0) {
            $diff = 100;
        } else {
            $diff = (($vars[0] - $vars[1]) / $vars[0]) * 100;
        }

        if ($diff == "") {
            $icon = '<i class="fa fa-minus" style="color: blue; margin-left: 5px;"></i>';
        } else {
            if ($diff < 0) {
                $diff *= -1;
                $icon = '<i class="fa fa-arrow-down" style="color: red; margin-left: 5px">' . round($diff) . '%</i>';

            } else {
                $icon = '<i class="fa fa-arrow-up" style="color: #009000; margin-left: 5px">' . round($diff) . '%</i>';
            }
        }

        $result = "";
        foreach ($vars as $each) {
            $print = is_numeric($each) ? number_format(round($each)) : $each;
            $result .= "<td class='$class'>$print" . "" . "$sign</td>";
        }
        $result .= "<td class='$class'>" . $icon . "</td>";

        return $result;
    }

}

if (!function_exists("periodText")) {
    function periodText($period, $date_from, $date_to, $months, $weekday, $selected_year, $data, $comparision = null)
    {
        $to = NULL;
        switch ($period) {
            case 0:
                $selected_period = $data;
                $from = (isset($date_from) && strtotime($date_from) > strtotime(firstDayOf('year', null, null, $data))) ? $date_from : firstDayOf('year', null, null, $data);
                $to = (isset($date_to) && strtotime($date_to) < strtotime(lastDayOf('year', null, null, $data))) ? $date_to : lastDayOf('year', null, null, $data);
                break;
            case 1:
                $selected_period = "Quarter " . $data;
                $from = (isset($date_from) && strtotime($date_from) > strtotime(firstDayOf('quarter', null, $data, $selected_year))) ? $date_from : firstDayOf('quarter', null, $data, $selected_year);
                $to = (isset($date_to) && strtotime($date_to) < strtotime(lastDayOf('quarter', null, $data, $selected_year))) ? $date_to : lastDayOf('quarter', null, $data, $selected_year);
                break;
            case 2:
                $data_month = date('m', strtotime($data));
                if (isset($comparision))
                    $selected_period = $months[$data];
                else
                    $selected_period = $data;//$months[$data];
                $from = (isset($date_from) && strtotime($date_from) > strtotime(firstDayOf('quarter', null, $data_month, $selected_year))) ? $date_from : firstDayOf('quarter', null, $data_month, $selected_year);
                $to = (isset($date_to) && strtotime($date_to) < strtotime(lastDayOf('month', null, $data_month, $selected_year))) ? $date_to : lastDayOf('month', null, $data_month, $selected_year);
                break;
            case 3:
                $selected_period = "Week " . $data;
                $from = firstDayOf('week', null, $data, $selected_year);
                $to = lastDayOf('week', null, $data, $selected_year);
                break;
            case 4:
                $selected_period = $weekday[$data];
                $from = $date_from;
                $to = $date_to;
                break;
            case 5:
                $selected_period = date('d-M-y', strtotime($data));
                $from = $data;
                $to = $data;
                break;
            case 6:
                $selected_period = $data;
                $from = $date_from;
                $to = $date_from;
                break;
            case 7:
                $selected_period = $data;
                $from = $date_from;
                break;
            default:
                $selected_period = $data;
                $from = null;
                $to = null;
        }
        return array(
            $selected_period,
            $from,
            $to
        );
    }
}

if (!function_exists("checkAgencySelected")) {
    function checkAgencySelected($country = NULL, $city = NULL, $agency = NULL)
    {
        $data = array(
            'country' => NULL,
            'city' => NULL,
            'agency' => NULL
        );
        if (isset($country)) {
            $data['country'] = $country;
        }
        if (isset($city)) {
            $data['city'] = $city;
        }
        if (isset($agency)) {
            $data['agency'] = $agency;
        }

        return $data;

    }
}

if (!function_exists("relationshipsList")) {
    function relationshipList($marital_status = null, $ids = null)
    {
        $list = DB::table('relationships');

        if (!is_null($marital_status))
            $list->where('marital_status_id', $marital_status);

        if (isset($ids))
            return $list->pluck('id');
        else
            return ['' => 'Select'] + $list->pluck('title', 'id');
    }
}

function combineArrays($array1, $array2, $json = null)
{
    $final[] = $array1;
    foreach ($array2 as $each) {
        $final[] = $each;
    }
    return isset($json) ? json_encode($final) : $final;
}

if (!function_exists("monthName")) {
    function monthName($k, $abbr = false)
    {
        if ($k == 1) {
            $name = $abbr ? "Jan" : 'January';
        } else if ($k == 2) {
            $name = $abbr ? "Feb" : 'February';
        } else if ($k == 3) {
            $name = $abbr ? "Mar" : 'March';
        } else if ($k == 4) {
            $name = $abbr ? "Apr" : 'April';
        } else if ($k == 5) {
            $name = $abbr ? "May" : 'May';
        } else if ($k == 6) {
            $name = $abbr ? "Jun" : 'June';
        } else if ($k == 7) {
            $name = $abbr ? "Jul" : 'July';
        } else if ($k == 8) {
            $name = $abbr ? "Aug" : 'August';
        } else if ($k == 9) {
            $name = $abbr ? "Sep" : 'September';
        } else if ($k == 10) {
            $name = $abbr ? "Oct" : 'October';
        } else if ($k == 11) {
            $name = $abbr ? "Nov" : 'November';
        } else if ($k == 12) {
            $name = $abbr ? "Dec" : 'December';
        } else {
            $name = 'Undefined = ' . $k;
        }

        return $name;
    }
}
if (!function_exists("getDelayCategory")) {
    function getDelayCategory($flight)
    {
        $depInit = getFlightDepartureInitialDatePTD($flight);
        $dep = getFlightDepartureDate($flight);

        if (!$depInit || !$dep || $depInit == EMPTY_DATETIME || $dep == EMPTY_DATETIME) {
            return 0;
        }
        else {
            $diff = CalculateDifference($depInit, $dep);

            if ($diff <= 3) {
                $category = 0;
            } else {
                if ($diff <= 15) {
                    $category = 1;
                } else {
                    if ($diff <= 30) {
                        $category = 2;
                    } else {
                        if ($diff <= 60) {
                            $category = 3;
                        } else {
                            $category = 4;
                        }
                    }
                }
            }

            return $category;
        }
    }
}

if (!function_exists("sortArray")) {
    function sortArray($a, $b)
    {
        if ($a->count == $b->count) {
            return ($a->duration < $b->duration) ? 1 : -1;
        }
        return ($a->count < $b->count) ? 1 : -1;
    }
}

if (!function_exists("firstDayOf")) {

    function firstDayOf($period, $date = null, $value = null, $year = null)
    {
        $period = strtolower($period);
        $validPeriods = array('year', 'quarter', 'month', 'week');

        if (!in_array($period, $validPeriods))
            throw new InvalidArgumentException('Period must be one of: ' . implode(', ', $validPeriods));


        $newDate = ($date === null) ? new DateTime() : clone $date;

        switch ($period) {
            case 'year':
                $newDate = date('Y-m-d', strtotime("$year-01-01"));
                break;
            case 'quarter':
                /*$month = $newDate->format('n') ;

                if ($month < 4) {
                    $newDate->modify('first day of january ' . $newDate->format('Y'));
                } elseif ($month > 3 && $month < 7) {
                    $newDate->modify('first day of april ' . $newDate->format('Y'));
                } elseif ($month > 6 && $month < 10) {
                    $newDate->modify('first day of july ' . $newDate->format('Y'));
                } elseif ($month > 9) {
                    $newDate->modify('first day of october ' . $newDate->format('Y'));
                }*/
                if ($value == 1) {
                    $newDate = date("$year-m-d", strtotime('first day of january'));
                } elseif ($value == 2) {
                    $newDate = date("$year-m-d", strtotime('first day of april'));
                } elseif ($value == 3) {
                    $newDate = date("$year-m-d", strtotime('first day of july'));
                } elseif ($value == 4) {
                    $newDate = date("$year-m-d", strtotime('first day of october'));
                } else {
                    $newDate = '';
                }
                break;
            case 'month':
                $newDate = date('Y-m-d', strtotime("$year-$value-01"));
                break;
            case 'week':
                $newDate = date('Y-m-d', strtotime($year . 'W' . str_pad($value, 2, '0', STR_PAD_LEFT)));
                break;
        }


        return $newDate;
    }
}


if (!function_exists("lastDayOf")) {

    function lastDayOf($period, $date = null, $value = null, $year = null)
    {
        $period = strtolower($period);
        $validPeriods = array('year', 'quarter', 'month', 'week');

        if (!in_array($period, $validPeriods))
            throw new InvalidArgumentException('Period must be one of: ' . implode(', ', $validPeriods));

        switch ($period) {
            case 'year':
                $newDate = date('Y-m-d', strtotime("$year-12-31"));
                break;
            case 'quarter':
                if ($value == 1) {
                    $newDate = date("$year-m-d", strtotime('last day of march'));
                } elseif ($value == 2) {
                    $newDate = date("$year-m-d", strtotime('last day of june'));
                } elseif ($value == 3) {
                    $newDate = date("$year-m-d", strtotime('last day of september'));
                } elseif ($value == 4) {
                    $newDate = date("$year-m-d", strtotime('last day of december'));
                } else {
                    $newDate = '';
                }

                break;
            case 'month':
                $newDate = date('Y-m-t', strtotime("$year-$value-01"));
                break;
            case 'week':
                $newDate = date('Y-m-d', strtotime($year . 'W' . str_pad($value, 2, '0', STR_PAD_LEFT)));
                $newDate = date('Y-m-d', strtotime("$newDate + 6 days"));
                break;
        }

        return $newDate;
    }
}

function groupSelectionNonComparison($group_period, $sales_departure = null)
{
    $column = isset($sales_departure) ? $sales_departure : "std";
    switch ($group_period) {
        case 0:
            $select = "YEAR($column)";
            break;
        case 1:
            $select = "CONCAT(QUARTER($column),', ', YEAR($column))";
            break;
        case 2:
            $select = "DATE_FORMAT($column, '%b, %Y')";
            break;
        case 3:
            $select = "DATE_FORMAT($column, '%V, %X')";
            break;
        case 4:
            $select = "WEEKDAY($column)";
            break;
        case 5:
            $select = "DATE_FORMAT($column, '%Y-%m-%d')";
            break;
        case 6:
            $select = "flight_number";
            break;
        case 7:
            $select  = "CONCAT(s_depAirport.iata, '-', s_arrAirport.iata)";
            break;
        case 8:
            $select = "DATE_FORMAT(sales_date, '%Y/%m/%d')";
            break;
        case 9:
            $select = "YEAR($column)";
            break;
        default:
            $select = false;
            break;
    }
    return $select;
}

function M_d_H_i_Format($datetime)
{
    return date('M d, H:i', strtotime($datetime));
}

function UK_date($date)
{
    return date('d-m-Y', strtotime($date));
}

function Compare_DateTimes($datetime1, $datetime2)
{
    return strtotime($datetime1) >= strtotime($datetime2);
}

function hoursToTime($hours, $ready = false, $roundSecs = false)
{
    $minus = $hours < 0;

    $hours = $minus ? -1 * $hours : $hours;
    $seconds = $hours * 3600;
    // extract hours
    $hours = floor($seconds / (60 * 60));

    // extract minutes
    $divisor_for_minutes = $seconds % (60 * 60);
    $minutes = floor($divisor_for_minutes / 60);

    // extract the remaining seconds
    $divisor_for_seconds = $divisor_for_minutes % 60;
    $seconds = ceil($divisor_for_seconds);

    if ($roundSecs && $seconds > 50) {
        $seconds = 0;
        $minutes++;

        if ($minutes >= 60) {
            $hours++;
            $minutes -= 60;
        }
    }

    // return the final array
    $obj = array(
        "h" => ($minus ? "-" : "") . ($hours < 10 ? "0" . $hours : $hours),
        "m" => $minutes < 10 ? "0".$minutes : $minutes,
        "s" => $seconds < 10 ? "0".$seconds : $seconds,
    );
    if (isset($ready))
        return $obj['h'] . ":" . $obj['m'];
    else
        return $obj;

}

function secsToHours($seconds){
    return $seconds / 3600;
}


function secsToTime($seconds, $showSecs = false)
{
    $hours = floor($seconds / 3600);
    $mins = floor($seconds / 60 % 60);
    $secs = floor($seconds % 60);

    if ($showSecs) {
        return sprintf('%02d:%02d:%02d', $hours, $mins, $secs);
    } else {
        return sprintf('%02d:%02d', $hours, $mins);
    }
}

function hoursToDayHourTime($hours, $ready = null, $separator = ":")
{
    $seconds = $hours * 3600;

    // extract days
    $days = floor($seconds / (60 * 60 * 24));
    $seconds -= ($days * 60 * 60 * 24);

    // extract hours
    $hours = floor($seconds / (60 * 60));
    if ($hours >= 0 && $hours < 10)
        $hours = "0" . $hours;
    $seconds -= ($hours * 60 * 60);

    // extract minutes
    $minutes = floor($seconds / 60);
    if ($minutes >= 0 && $minutes < 10)
        $minutes = "0" . $minutes;

    // return the final array
    $obj = array(
        "d" => $days,
        "h" => $hours,
        "m" => $minutes,
    );
    if (isset($ready)) {
        $readyString = $days ? $days . "d " : "";
        $readyString .= $obj['h'] . $separator . $obj['m'];
        return $readyString;
    } else
        return $obj;

}

function Hours_To_Time($hours)
{
    return gmdate('H:i', $hours * 60 * 60);
}

function Minutes_To_Time($minutes)
{
    return gmdate('H:i', $minutes * 60);
}


function TimeToSeconds($timestring, $HMSformat = false)
{
    $hours = $minutes = $seconds = 0;

    if ($HMSformat) {
        sscanf($timestring, "%d:%d:%d", $hours, $minutes, $seconds);
    } else {
        sscanf($timestring, "%d:%d", $hours, $minutes);
    }

    return isset($seconds) ? ($hours * 3600 + $minutes * 60 + $seconds) : ($hours * 60 + $minutes);
}

function TimeToMinutes($timestring, $HMSformat = false)
{
    $hours = $minutes = $seconds = 0;

    if ($HMSformat) {
        sscanf($timestring, "%d:%d:%d", $hours, $minutes, $seconds);
    } else {
        sscanf($timestring, "%d:%d", $hours, $minutes);
    }

    return $hours * 60 + $minutes;
}

function Outbound_Inbound($count_flights, $flight_number, $k)
{
    if ($count_flights == 2) {
        if ($k == 0)
            $add_option = 'outbound';
        else
            $add_option = 'inbound';
    } else if ($count_flights == 1) {
        if (intval($flight_number) % 2 == 0)
            $add_option = 'inbound';
        else
            $add_option = 'outbound';
    }

    return $add_option;
}

function Add_Minutes_To_DateTime($datetime, $minutes, $hours = null, $subtract = null)
{
    if (isset($subtract))
        return date('Y-m-d H:i', strtotime($datetime) - $minutes * 60 * ($hours ? 60 : 1));
    else
        return date('Y-m-d H:i', strtotime($datetime) + $minutes * 60 * ($hours ? 60 : 1));
}

function Preferred_Value_First($array, $preferred_value, $times = null)
{
    $preferred = [];
    $others = [];
    $result = [];
    $n = 0;
    foreach ($array as $id => $value) {
        if ($value == $preferred_value) {
            // Only Defined Qty
            if ($times) {
                if ($n <= $times) {
                    $preferred["$id"] = $value;
                    $n++;
                } else {
                    $others["$id"] = $value;
                }
            } else {
                $preferred["$id"] = $value;
            }
        } else
            $others["$id"] = $value;
    }

    foreach ($preferred as $id => $value) {
        $result["$id"] = $value;
    }
    foreach ($others as $id => $value) {
        $result["$id"] = $value;
    }

    return $result;
}


function Preferred_Value_First_Once($array, $preferred_value)
{
    $newArray = $array;

    $foundKey = array_search($preferred_value, $array);
    if ($foundKey) {

        $newArray = [
            "$foundKey" => $array[$foundKey]
        ];

        unset($array[$foundKey]);

        foreach ($array as $key => $each) {
            $newArray[$key] = $each;
        }
    }

    return $newArray;
}


function countDays($dateInString)
{

    // Write your code here

    $date = DateTime::createFromFormat('m.d.Y', $dateInString);

    if ($date && $date->format('Y-m-d') != '1970-01-01') {

        $date2 = new DateTime();
        $date2->setDate($date->format('Y'), 1, 1);

        $diff = 1 + (strtotime($date->format('Y-m-d')) - strtotime($date2->format('Y-m-d'))) / (60 * 60 * 24);
    } else
        debug("Bad format");


}

function changeNickname($oldNickname, $newNickname, $users)
{

    // Write your code here

    // To print results to the standard output you can use print
    // Example:
    // print "Hello world!";

}

function Difference_Dates($date1, $date2)
{
    $date1 = new DateTime($date1);
    $date2 = new DateTime($date2);
    $interval = $date1->diff($date2);
    $years = $interval->format('%y');
    $months = $interval->format('%m');
    $days = $interval->format('%d');

    return ['y' => (int)$years, 'm' => (int)$months, 'd' => (int)$days];
}

/**
 * Calculate Difference Between 2 DateTimes And Return Hours/Minutes/Secs. Default (MINS)
 * @param $dateTimeFrom
 * @param $dateTimeTo
 * @param string $totalType
 * @return array
 */
function DateTimeDifference($dateTimeFrom, $dateTimeTo, $totalType = 'i')
{
    $date1 = new DateTime($dateTimeFrom);
    $date2 = new DateTime($dateTimeTo);
    $interval = $date1->diff($date2);
    switch ($totalType) {
        case 'H':
            $total = $interval->d * 60 + $interval->h + ($interval->i / 60);
            break;
        case 'i':
            $total = $interval->d * 60 * 60 + $interval->h * 60 + $interval->i;
            break;
        case 's':
            $total = $interval->d * 60 * 60 * 60 + $interval->h * 60 * 60 + $interval->i * 60 + $interval->s;
            break;

    }
    return ['H' => $interval->h, 'i' => ($interval->i < 10 ? '0' . $interval->i : $interval->i), 'total' => $total];

}

function CalculateDifference($from_date, $to_date, $seconds = false)
{
    if ($seconds){
        return (strtotime($to_date) - strtotime($from_date));
    }

    return (strtotime($to_date) - strtotime($from_date)) / 60;
}

function getWorksTypesList($full = true)
{
    if ($full) {
        return [
            1 => "Full Time (F)",
            2 => "Part Time (P)",
            3 => "Mini Jobber (M)",
            4 => "Student (S)",
            5 => "Internship (I)",
        ];
    }

    return [
        1 => "F",
        2 => "P",
        3 => "M",
        4 => "S",
        5 => "I",
    ];

}

function workTypeSelected($selected)
{
    $list = getWorksTypesList();

    return $selected && array_key_exists($selected, $list) ? $list[$selected] : "";
}

function getUserWorkType($selected)
{
    $list = getWorksTypesList(false);

    return $selected && array_key_exists($selected, $list) ? $list[$selected] : "";
}

function weekDaysSelected($string){
    $list = [
        1 => "Monday",
        2 => "Tuesday",
        3 => "Wednesday",
        4 => "Thursday",
        5 => "Friday",
        6 => "Saturday",
        0 => "Sunday",
    ];

    $result = explode(";", $string);

    $str = "";
    foreach ($result as $item) {
        $str .= $list[$item].", ";
    }

    return rtrim($str, ", ");
}

function Calculate_Duration($from_date, $to_date, $no_round = null, $round = 4)
{

    if (!$from_date || !$to_date || $from_date == EMPTY_DATETIME || $to_date == EMPTY_DATETIME) {
        return 0;
    }

    if ($no_round)
        return (strtotime($to_date) - strtotime($from_date)) / (60 * 60);
    else
        return round((strtotime($to_date) - strtotime($from_date)) / 3600, $round);
}

function getYearsArray($startYear = 2017, $endYear = false)
{
    if (!$endYear)
        $endYear = date("Y") + 10;

    for ($i = $startYear; $i < $endYear; $i++) {
        $years[$i] = $i;
    }
    return $years;
}

function getPeriods($exception = false)
{
    $array = ['' => 'None', 'Daily' => 'Daily', 'Weekly' => 'Weekly', 'Monthly' => 'Monthly'];
    if ($exception && is_array($exception)) {
        return array_except($array, $exception);
    }
    return $array;
}

function getPeriodStr($dateFrom, $dateTo){
    if ($dateTo <= $dateFrom){
        return baseDateFormat($dateFrom);
    }

    return baseDateFormat($dateFrom)." - ".baseDateFormat($dateTo);
}

function getPeriodsArray($exception = false)
{
    $array = ['' => 'None', 0 => 'Yearly', 1 => 'Quarterly', 2 => 'Monthly', 3 => 'Weekly', 4 => 'Weekdays', 5 => 'Daily', 6 => 'Flight Number'];
    if ($exception && is_array($exception)) {
        return array_except($array, $exception);
    }
    return $array;
}

function getPeriodNamesArray($exception = false)
{
    $array = ['' => 'None', 0 => 'Year', 1 => 'Quarter', 2 => 'Month', 3 => 'Weekly', 4 => 'Weekdays', 5 => 'Daily', 6 => 'Flight Number'];
    if ($exception && is_array($exception)) {
        return array_except($array, $exception);
    }
    return $array;
}


function getMonthsArray($abbr = false)
{
    if ($abbr) {
        $array = [1 => "Jan", 2 => "Feb", 3 => "Mar", 4 => "Apr", 5 => "May", 6 => "Jun", 7 => "Jul", 8 => "Aug", 9 => "Sep", 10 => "Oct", 11 => "Nov", 12 => "Dec"];
    } else {
        $array = [1 => "January", 2 => "February", 3 => "March", 4 => "April", 5 => "May", 6 => "June", 7 => "July", 8 => "August", 9 => "September", 10 => "October", 11 => "November", 12 => "December"];
    }
    return $array;
}


function getWeekdaysArray($abbr = false, $indexFromArray = false)
{
    if ($abbr) {
        $array = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
    } else {
        $array = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
    }

    if ($indexFromArray) {
        $newArray = [];
        foreach ($array as $each) {
            $newArray[$indexFromArray++] = $each;
        }
        return $newArray;
    }

    return $array;
}


function getSelectedYear()
{
    if (\request()->has('year') && \request()->get('year')) {
        return \request()->get('year');
    }
    return date('Y');
}


function getMonthArrayFromDates($from, $to, $month = false)
{

    $monthArray = [];
    if ($month && is_array($month)) {
        foreach ($month as $m) {
            $monthArray[$m] = monthName($m, true);
        }
    } else {
        if ($from && $to) {
            $fromM = date('n', strtotime($from));
            $toM = date('n', strtotime($to));
            $monthArray = [];

            for ($i = $fromM; $i <= $toM; $i++) {
                $monthArray[$i] = monthName($i, true);
            }
        }
    }
    return $monthArray;
}

function Calculate_Max_Allowed_FDP($report_time, $release_time, $fdp_max)
{
    return WOCL_Period_Check($report_time, $release_time);
}


/**
 * @param $report_time
 * @param $release_time
 * @return float|int
 */
function WOCL_Period_Check($report_time, $release_time)
{
    $encroachment = 0;
    $fdpMaxReduction = 0;
    $local = 18000;

    $report_time = strtotime(date('H:i', strtotime($report_time) + $local));
    $release_time = strtotime(date('H:i', strtotime($release_time) + $local));
    $wocl_start = strtotime("02:00");
    $wocl_end = strtotime("05:59");


    // FDP starts at WOCL
    if ($report_time >= $wocl_start && $report_time <= $wocl_end) {
        // Omitted
        // $encroachment = round(($wocl_end - $report_time) / 3600, 1);
        // When the FDP starts in the WOCL, the maximum stated in point 1.3 and point 1.4 will be reduced by 100 % of its encroachment up to a maximum of two hours
        // $fdpMaxReduction = $encroachment > 2 ? 2 : $encroachment;
    } // FDP Ends or Fully encompasses WOCL
    else {
        if ($release_time >= $wocl_end) {
            if ($report_time >= $wocl_start && $report_time <= $wocl_end) {
                $encroachment = round(($wocl_end - $report_time) / 3600, 1);
            } elseif ($report_time < $wocl_start || $report_time > $release_time) {
                $encroachment = round(($wocl_end - $wocl_start) / 3600, 1);
            }
        } // Release Time < WOCL End
        else {
            if ($release_time >= $wocl_start) {
                $encroachment = round(($release_time - $wocl_start) / 3600, 1);
            }
        }

        if ($encroachment > 0) {
            // When the FDP ends in or fully encompasses the WOCL, the maximum FDP stated in point 1.3 and point 1.4 will be reduced by 50 % of its encroachment
            $fdpMaxReduction = 0.5 * $encroachment;
        }
    }


    return $fdpMaxReduction;
}

/**
 * Find Extended FDP Duty Time (If Additional Crew Added)
 * @param $report_time
 * @param $release_time
 * @param $sector_count
 * @param $crewMin
 * @param $crewCurrent
 * @param $fdpMax
 * @return mixed
 */
function extendedFdp($report_time, $release_time, $sector_count, $crewMin, $crewCurrent, $fdpMax)
{

    $requiredAdditionalCrew = intval(ceil($crewMin * 0.3));
    $local = 18000;
    $hour_minute_format = strtotime(date('H:i', strtotime($report_time) + $local));
    $sector_index = $sector_count - 1;
    $addedCrew = $crewCurrent - $crewMin;


    $fdpWOCLReduction = 0;
    // Apply WOCL Rule after 23-05-16
    if (strtotime($report_time) > strtotime("2016-05-24")) {
        $fdpWOCLReduction = Calculate_Max_Allowed_FDP($report_time, $release_time, $fdpMax);
    }

    if ($addedCrew > 0) {

        $augmentedHours = [
            0 => [14.00, 14.00, 14.00, 14.00, 14.00, 14.00],
            1 => [15.00, 15.00, 15.00, 15.00, 15.00, 15.00],
            2 => [16.50, 16.50, 16.50, 16.50, 16.50, 16.50],
            3 => [15.00, 15.00, 15.00, 15.00, 15.00, 15.00],
            4 => [14.00, 14.00, 14.00, 14.00, 14.00, 14.00],
        ];

        $doubleCrewHours = [
            0 => [16.00, 16.00, 14.00, 14.00, 14.00, 14.00],
            1 => [15.00, 15.00, 13.00, 13.00, 13.00, 13.00],
        ];

        if ($hour_minute_format >= strtotime('00:00') && $hour_minute_format <= strtotime('05:59')) {
            $fdpAugmentedCrew = $augmentedHours[0][$sector_index]; //index -> sectors
            $fdpDoubleCrew = $doubleCrewHours[1][$sector_index];
        } elseif ($hour_minute_format >= strtotime('06:00') && $hour_minute_format <= strtotime('06:59')) {
            $fdpAugmentedCrew = $augmentedHours[1][$sector_index]; //index -> sectors
            $fdpDoubleCrew = $doubleCrewHours[0][$sector_index];
        } elseif ($hour_minute_format >= strtotime('07:00') && $hour_minute_format <= strtotime('12:59')) {
            $fdpAugmentedCrew = $augmentedHours[2][$sector_index]; //index -> sectors
            $fdpDoubleCrew = $doubleCrewHours[0][$sector_index];
        } elseif ($hour_minute_format >= strtotime('13:00') && $hour_minute_format <= strtotime('16:59')) {
            $fdpAugmentedCrew = $augmentedHours[3][$sector_index]; //index -> sectors
            $fdpDoubleCrew = $doubleCrewHours[0][$sector_index];
        } elseif ($hour_minute_format >= strtotime('17:00') && $hour_minute_format <= strtotime('21:59')) {
            $fdpAugmentedCrew = $augmentedHours[4][$sector_index]; //index -> sectors
            $fdpDoubleCrew = $doubleCrewHours[0][$sector_index];
        } else {
            $fdpAugmentedCrew = $augmentedHours[4][$sector_index]; //index -> sectors
            $fdpDoubleCrew = $doubleCrewHours[1][$sector_index];
        }

        // STATIC PARAMETERS, REMOVE UPON REQUEST
        // $fdpAugmentedCrew = $augmentedHours[0][$sector_index];
        // $fdpDoubleCrew = $doubleCrewHours[1][$sector_index];
        // NEEDS TO BE REMOVED LATER ON

        for ($k = 1; $k <= $crewMin; $k++) {
            if ($k < $requiredAdditionalCrew) {
                $addition[$k] = $fdpMax - $fdpWOCLReduction;
            } elseif ($k == $crewMin) {
                $addition[$k] = $fdpDoubleCrew - $fdpWOCLReduction;
            } else {
                $addition[$k] = $fdpAugmentedCrew - $fdpWOCLReduction;
            }
        }

        if (isset($addition[$addedCrew])) {
            return $addition[$addedCrew];
        }
    }

    return $fdpMax - $fdpWOCLReduction;
}


function FdpCalculator($time, $sector, $rule, $local = false)
{
    $localSeconds = 0;
    if ($local) {
        $localSeconds = 60 * 60 * 5;
    }

    $hour_minute_format = strtotime(date('H:i', strtotime($time) + $localSeconds));
    $sector_index = $sector - 1;
    $max_fdp_selected = 12;
    switch ($rule) {
        case TAJIKISTAN_CAA:
            $max_fdp = [
                0 => [13.00, 13.00, 13.00, 13.00, 13.00, 13.00],
                1 => [12.00, 12.00, 12.00, 12.00, 12.00, 12.00],
            ];

            if ($hour_minute_format >= strtotime('06:01') && $hour_minute_format <= strtotime('21:59'))
                $max_fdp_selected = $max_fdp[0][$sector_index]; //index -> sectors
            else
                $max_fdp_selected = $max_fdp[1][$sector_index]; //index -> sectors

            break;

        case PREV_TAJIKISTAN_CAA:
            $max_fdp = [
                0 => [12.00, 12.00, 10.50, 10.50, 08.50, 08.50, 08.50, 08.50, 08.50, 08.50, 08.50],
                1 => [11.00, 11.00, 10.00, 10.00, 06.50, 06.50, 06.50, 06.50, 06.50, 06.50, 06.50],
            ];

            $max_fdp_selected = 12;

            if ($hour_minute_format >= strtotime('06:01') && $hour_minute_format <= strtotime('21:59'))
                $max_fdp_selected = $max_fdp[0][$sector_index]; //index -> sectors
            else
                $max_fdp_selected = $max_fdp[1][$sector_index]; //index -> sectors
            break;
        case EASA:
            $max_fdp = [
                0 => [13.00, 13.00, 12.50, 12.00, 11.50, 11.00, 10.50, 10.00, 09.50, 09.00, 09.00],
                1 => [12.75, 12.75, 12.25, 11.75, 11.25, 10.75, 10.25, 09.75, 09.25, 09.00, 09.00],
                2 => [12.50, 12.50, 12.00, 11.50, 11.00, 10.50, 10.00, 09.50, 09.00, 09.00, 09.00],
                3 => [12.25, 12.25, 11.75, 11.25, 10.75, 10.25, 09.75, 09.25, 09.00, 09.00, 09.00],
                4 => [12.00, 12.00, 11.50, 11.00, 10.50, 10.00, 09.50, 09.00, 09.00, 09.00, 09.00],
                5 => [11.75, 11.75, 11.25, 10.75, 10.25, 09.75, 09.25, 09.00, 09.00, 09.00, 09.00],
                6 => [11.50, 11.50, 11.00, 10.50, 10.00, 09.50, 09.00, 09.00, 09.00, 09.00, 09.00],
                7 => [11.25, 11.25, 10.75, 10.25, 09.75, 09.25, 09.00, 09.00, 09.00, 09.00, 09.00],
                8 => [11.00, 11.00, 10.50, 10.00, 09.50, 09.00, 09.00, 09.00, 09.00, 09.00, 09.00],
                9 => [12.00, 12.00, 11.50, 11.00, 10.50, 10.00, 09.50, 09.00, 09.00, 09.00, 09.00],
                10 => [12.25, 12.25, 11.75, 11.25, 10.75, 10.25, 09.75, 09.25, 09.00, 09.00, 09.00],
                11 => [12.50, 12.50, 12.00, 11.50, 11.00, 10.50, 10.00, 09.50, 09.00, 09.00, 09.00],
                12 => [12.75, 12.75, 12.25, 11.75, 11.25, 10.75, 10.25, 09.75, 09.00, 09.00, 09.00],
            ];

            $max_fdp_selected = 13;

            if ($hour_minute_format >= strtotime('06:00') && $hour_minute_format <= strtotime('13:29'))
                $max_fdp_selected = $max_fdp[0][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('13:30') && $hour_minute_format <= strtotime('13:59'))
                $max_fdp_selected = $max_fdp[1][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('14:00') && $hour_minute_format <= strtotime('14:29'))
                $max_fdp_selected = $max_fdp[2][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('14:30') && $hour_minute_format <= strtotime('14:59'))
                $max_fdp_selected = $max_fdp[3][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('15:00') && $hour_minute_format <= strtotime('15:29'))
                $max_fdp_selected = $max_fdp[4][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('15:30') && $hour_minute_format <= strtotime('15:59'))
                $max_fdp_selected = $max_fdp[5][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('16:00') && $hour_minute_format <= strtotime('16:29'))
                $max_fdp_selected = $max_fdp[6][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('16:30') && $hour_minute_format <= strtotime('16:59'))
                $max_fdp_selected = $max_fdp[7][$sector_index]; //index -> sectors

            else if ($hour_minute_format >= strtotime('05:00') && $hour_minute_format <= strtotime('05:14'))
                $max_fdp_selected = $max_fdp[9][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('05:15') && $hour_minute_format <= strtotime('05:29'))
                $max_fdp_selected = $max_fdp[10][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('05:30') && $hour_minute_format <= strtotime('05:44'))
                $max_fdp_selected = $max_fdp[11][$sector_index]; //index -> sectors
            else if ($hour_minute_format >= strtotime('05:45') && $hour_minute_format <= strtotime('05:59'))
                $max_fdp_selected = $max_fdp[12][$sector_index]; //index -> sectors
            else if (($hour_minute_format >= strtotime('00:00') && $hour_minute_format <= strtotime('04:59')) ||
                ($hour_minute_format >= strtotime('17:00') && $hour_minute_format <= strtotime('23:59'))
            ) {
                $max_fdp_selected = $max_fdp[8][$sector_index]; //index -> sectors
            } else
                $max_fdp_selected = 13; //index -> sectors

            break;
    }

    return floatval($max_fdp_selected);
}


function SetUserPermissionsArray()
{
//    list($userModules, $userControllers) = getUserModulesAndController(Auth::user());
    // Add Controllers By User Role
//    $userControllers = addControllersByRole($userControllers, Auth::user()->role);
    // Add Controllers That All Users Require
//    $userControllers = addControllersByRole($userControllers, ROLE_ALL);
    // Put Session Variables
//    \Illuminate\Support\Facades\Session::put('userControllers', $userControllers);
//    \Illuminate\Support\Facades\Session::put('userModules', $userModules);
}


function Date_Within_Range($date, $range_from, $range_to)
{
    return (strtotime($date) >= strtotime($range_from) && strtotime($date) < strtotime($range_to));
}

/**
 * Both $from and $to included
 * @param $date
 * @param $rangeFrom
 * @param $rangeTo
 * @return bool
 */
function dateWithinRange($date, $rangeFrom, $rangeTo)
{
    return (strtotime($date) >= strtotime($rangeFrom) && strtotime($date) <= strtotime($rangeTo));
}

function superThree($n)
{
    $series = [0, 1, 1, 1];

    for ($i = 3; $i <= $n; $i++) {

        $a = (isset($series[$i - 3])) ? $series[$i - 3] : 0;

        $b = (isset($series[$i - 2])) ? $series[$i - 2] : 0;

        $c = (isset($series[$i - 1])) ? $series[$i - 1] : 0;

        $d = ($a + $b + $c) - 1;

        if ($d < 0) {
            $d = 0;
        }

        $series[$i] = $d;
    }

    echo $series[$n - 1];
}

function getMimeType($file)
{
    // our list of mime types
    $mime_types = array(
        "pdf" => "application/pdf"
    , "exe" => "application/octet-stream"
    , "zip" => "application/zip"
    , "docx" => "application/msword"
    , "doc" => "application/msword"
    , "xls" => "application/vnd.ms-excel"
    , "ppt" => "application/vnd.ms-powerpoint"
    , "gif" => "image/gif"
    , "png" => "image/png"
    , "jpeg" => "image/jpg"
    , "jpg" => "image/jpg"
    , "mp3" => "audio/mpeg"
    , "wav" => "audio/x-wav"
    , "mpeg" => "video/mpeg"
    , "mpg" => "video/mpeg"
    , "mpe" => "video/mpeg"
    , "mov" => "video/quicktime"
    , "avi" => "video/x-msvideo"
    , "3gp" => "video/3gpp"
    , "css" => "text/css"
    , "jsc" => "application/javascript"
    , "js" => "application/javascript"
    , "php" => "text/html"
    , "htm" => "text/html"
    , "html" => "text/html"
    , "xlsx" => "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
    , "xltx" =>  "application/vnd.openxmlformats-officedocument.spreadsheetml.template"
    , "xlsm" =>  "application/vnd.ms-excel.sheet.macroEnabled.12"
    , "xltm" =>  "application/vnd.ms-excel.template.macroEnabled.12"
    , "xlam" =>  "application/vnd.ms-excel.addin.macroEnabled.12"
    , "xlsb" =>  "application/vnd.ms-excel.sheet.binary.macroEnabled.12"
    );

    $ext = explode('.', $file);

    $extension = strtolower($ext[1]);
    return isset($extension) ? $mime_types[$extension] : false;
}

function dateValidation($date, $format = null, $dateObject = null)
{
    $format = (isset($format)) ? $format : 'Y-m-d';
    $d = DateTime::createFromFormat($format, $date);
    if (isset($dateObject)) {
        if ($d && $d->format($format) == $date && date('Y-m-d', strtotime($date)) != '1970-01-01')
            return $d;
        else
            return false;
    } else {
        debug($format);
        return $d && $d->format($format) == $date && date('Y-m-d', strtotime($date)) != '1970-01-01';
    }
}

function Expiration_Date($date = null, $issueDate = null, $type = null)
{
    $message = '';

    if ($type){
        $validStatus = '&#10003;';
        $validTemp = '&#10003;';
        $notIssued = 'x';
        $expired = 'x';
    }
    else {
        $validStatus = '<span class="label label-success status">VALID</span>';
        $validTemp = '<span class="label label-warning status">VALID</span>';
        $notIssued = '<span class="label label-primary status">NOT ISSUED</span>';
        $expired = '<span class="label label-danger status">EXPIRED</span>';
    }

    if ($date) {
        $today = date('Y-m-d');

        $message = "Expired ";

        $curdate_month = date('m');
        $date_month = date('m', strtotime($date));
        $curdate_plus_30days = date('Y-m-d', strtotime('+ 30 days'));

        if (strtotime($date) <= strtotime($today)) {
            if (date('Y') == date('Y', strtotime($date)) && $curdate_month == $date_month) {
                $status = $validTemp;
                $filter = 'valid_temp';
                $class = "color-green";
            } else {
                $status = $expired;
                $filter = 'expired';
                $class = "color-red";
            }
        } else {
            if ($date < $curdate_plus_30days) {
                $status = $validTemp;
                $filter = 'valid_temp';
                $class = "txt-color-orange";
            } else {
                $status = $validStatus;
                $filter = "valid";
                $class = "color-green";
            }
        }
    }
    else {
        if ($issueDate){
            $status = $validStatus;
            $class = "color-green";
        }
        else {
            $status = $notIssued;
            $class = "color-red";
        }
        $filter = 'valid';
    }

    return ['message' => $message, 'status' => $status, 'filter' => $filter, 'class' => $class];
}

function dmy_format($date, $timestamp = null)
{
    return isset($timestamp) ? date('dMy H:i', strtotime($date)) : date('dMy', strtotime($date));
}

function dmy_format_compare_dates($datetime1, $datetime2, $timestamp = null)
{
    if (strtotime(date('Y-m-d', strtotime($datetime1))) == strtotime(date('Y-m-d', strtotime($datetime2)))) {
        return isset($timestamp) ? date('H:i', strtotime($datetime2)) : date('dMy', strtotime($datetime2));
    } else {
        return isset($timestamp) ? date('dMy H:i', strtotime($datetime2)) : date('dMy', strtotime($datetime2));
    }
}


function Standby_DHC_Count($type, $date, $user_id = null)
{
    switch ($type) {
        case "fcm":
            $crew_all = User::join('crew__flight', 'users.id', '=', 'crew__flight.user_id')
                        ->where(function($sql){
                            $sql->whereNull("users.resigned_date")
                                ->orWhere("users.resigned_date", EMPTY_DATE)
                                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                        });
            break;
        case "ccm":
            $crew_all = User::join('crew__cabin', 'users.id', '=', 'crew__cabin.user_id')
                        ->where(function($sql){
                            $sql->whereNull("users.resigned_date")
                                ->orWhere("users.resigned_date", EMPTY_DATE)
                                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
                        });
            break;
    }

    if (isset($user_id))
        $crew_all->where('users.id', $user_id);

    $crew = $crew_all->orderBy('id')
        ->get(['users.id as id']);

    $ccm = [];
    $ids = [];
    if (count($crew)) {

        foreach ($crew as $each) {
            $ids[] = $each->id;
        }

        $last_365days = date('Y-m-d', strtotime("$date - 365 days"));
        $last_90days = date('Y-m-d', strtotime("$date - 90 days"));
        $last_28days = date('Y-m-d', strtotime("$date - 28 days"));
        $last_7days = date('Y-m-d', strtotime("$date - 7 days"));

        $planned_30days = date('Y-m-d', strtotime("$date + 30 days"));

        $crew_flights = FlightCrew::selectRaw('user_id, SUM(is_dhc) as dhc, SUM(is_standby) as standby')
            ->join('flights', 'flights.id', '=', 'flights__crew.flight_id')
            ->whereRaw("DATE(std) BETWEEN '$last_90days' AND '$date' ")
            ->where(function ($sql) {
                $sql->where('is_standby', 1)
                    ->orWhere('is_dhc', 1);
            });

        if (isset($user_id))
            $crew_flights->where('user_id', $user_id);
        else
            $crew_flights->whereIn('user_id', $ids);


        $crew_flights = $crew_flights->orderBy('user_id')
            ->orderBy('std')
            ->groupBy('user_id')
            ->get();

        if (!$crew_flights->isEmpty()) {
            $iteration = 0;
            foreach ($crew_flights as $user) {
                $iteration++;
                $ccm[$user->user_id]['dhc'] = $user->dhc;
                $ccm[$user->user_id]['standby'] = $user->standby;
            }
        }
    }
    return $ccm;
}

/**
 * Put Id as Array Key
 * @param $array
 * @return array
 */
function makeObjectIdAsArrayKey($array)
{
    if (count($array)) {
        $newArray = [];
        foreach ($array as $each) {
            if (is_array($each)) {
                $newArray[$each['id']] = $each;
            } else if (is_object($each)) {
                $newArray[$each->id] = $each;
            }
        }
        $array = $newArray;
    }
    return $array;
}

/**
 * Get Ids From Array or Array of Objects
 * @param $array
 * @return array|bool
 */
function getIdsFromObjectOrArray($array)
{
    $ids = false;
    if (count($array)) {
        foreach ($array as $each) {
            if (is_array($each)) {
                $ids[] = $each['id'];
            } else if (is_object($each)) {
                $ids[] = $each->id;
            }
        }
    } else if (is_object($array)) {
        $ids = $array->id;
    }
    return $ids;
}

function Route_Group_By_Base($route, $bases = ['DYU', 'LBD'])
{
    if (is_array($route) && count($route)) {
        //arsort($route);
        $filtered_route = [];

        if (!is_array($bases))
            $bases = [$bases];

        $regexp = "/";
        foreach ($bases as $base) {
            $regexp .= "(" . $base . "[-.]?\w{3}+)|";
        }
        $regexp = rtrim($regexp, '|');
        $regexp .= "/m";

        $json_hours = json_encode($route);

        preg_match_all($regexp, $json_hours, $matches);
        list($filtered_route['all'], $filtered_route['dyu'], $filtered_route['lbd']) = $matches;

        foreach ($filtered_route as $i => $each)
            $filtered_route[$i] = array_diff($each, ['']);

        return $filtered_route;
    }
}

function Crew_Designation($type, $crew_object)
{
    switch ($type) {
        case "fcm":
            $designation = $crew_object->is_captain ||( $crew_object->position[0] && $crew_object->position[0]->type == FCM_CPT_TYPE_ID) ? "Captain" : "First Officer";
            break;
        case "ccm":
            $designation = $crew_object->is_purser ||( $crew_object->position[0] && $crew_object->position[0]->type == CCM_PSR_TYPE_ID) ? "Purser" : "Cabin Crew";
            break;
    }
    return isset($designation) ? $designation : "";
}

function isCaptain($crew_object){
    return $crew_object->is_captain || ( $crew_object->position[0] && $crew_object->position[0]->type == FCM_CPT_TYPE_ID);
}

function isPurser($crew_object){
    return $crew_object->is_purser || ( $crew_object->position[0] && $crew_object->position[0]->type == CCM_PSR_TYPE_ID);
}

function Get_Limitation_Class($last)
{
    foreach ($last as $index => $value) {
        $class[$index] = '';
        if (is_array($value)) {
            switch ($index) {
                case 'last7days':
                    $limit = 40;
                    if ($value['value'] > $limit)
                        $class[$index] = 'limit1';
                    else
                        $class[$index] = 'limit3';
                    break;
                case 'last28days':
                    $limit = 80;
                    $limit_max = 88;
                    if ($value['value'] > $limit_max)
                        $class[$index] = 'limit1';
                    else {
                        if ($value['value'] >= $limit)
                            $class[$index] = 'limit2';
                        else {
                            if ($value['value'] < $limit)
                                $class[$index] = 'limit3';
                        }
                    }
                    break;
                case $index == 'last365days' || $index == 'yearToDate':
                    $limit = 800;
                    $limit_max = 880;
                    if ($value['value'] > $limit_max)
                        $class[$index] = 'limit1';
                    else {
                        if ($value['value'] >= $limit)
                            $class[$index] = 'limit2';
                        else {
                            if ($value['value'] < $limit)
                                $class[$index] = 'limit3';
                        }
                    }
                    break;
            }
        } else {
            if (is_numeric($value)) {
                switch ($index) {
                    case 'last7days':
                        $limit = 40;
                        if ($value > $limit)
                            $class[$index] = 'limit1';
                        else
                            $class[$index] = 'limit3';
                        break;
                    case 'last28days':
                        $limit = 80;
                        $limit_max = 88;
                        if ($value > $limit_max)
                            $class[$index] = 'limit1';
                        else {
                            if ($value >= $limit)
                                $class[$index] = 'limit2';
                            else {
                                if ($value < $limit)
                                    $class[$index] = 'limit3';
                            }
                        }
                        break;
                    case $index == 'last365days' || $index == 'yearToDate':
                        $limit = 800;
                        $limit_max = 880;
                        if ($value > $limit_max)
                            $class[$index] = 'limit1';
                        else {
                            if ($value >= $limit)
                                $class[$index] = 'limit2';
                            else {
                                if ($value < $limit)
                                    $class[$index] = 'limit3';
                            }
                        }
                        break;
                }
            }
        }
    }

    return $class;

}

function getMyDepartmentId($authUser)
{
    return $authUser->department && count($authUser->department) ? $authUser->department->first()->id : null;
}

function getDepartmentList()
{
    return Department::whereNull("deleted_at")->pluck('name', 'id')->all();
}

function getDepartmentListByRole($authObject, $skipEmptyOption = false)
{
    $list = Department::whereNull("deleted_at")->pluck('name', 'id')->all();

    if ($skipEmptyOption){
        return $list;
    }

    return ['' => 'Select'] + $list;

    $departments = [];

    if ($authObject->user()->user_role_id == 3) {
        $departments = ['' => 'Select'] + Department::pluck('name', 'id')->all();
    } else if ($authObject->user()->user_role_id == 2) {
        $departments = Department::where('id', $authObject->user()->department->first()->id)->pluck('name', 'id')->all();
    } else {
        $departments = Department::where('id', $authObject->user()->department->first()->id)->pluck('name', 'id')->all();
    }
    return $departments;
}

function getStaffByDepartment(){
    $result = \App\Models\User::leftJoin("users__departments", "users.id", "=", "users__departments.user_id")
        ->whereNull("users.vs")
        ->whereNull("users.deleted_at")
        ->where(function($sql){
            $sql->whereNull("users.resigned_date")
                ->orWhere("users.resigned_date", EMPTY_DATE)
                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
        })
        ->groupBy("department_id")
        ->get([
            \Illuminate\Support\Facades\DB::raw("COUNT(*) as counter"),
            "department_id"
        ])
        ->keyBy("department_id")->toArray();


    return $result;
}

function getDepartmentObjectByRole($authObject)
{
    return Department::with(['module'])->get();

    $departments = null;

    if ($authObject->user()->user_role_id == 3) {
        $departments = Department::with(['module']);
    } else if ($authObject->user()->user_role_id == 2) {

        if ($authObject->user()->department) {
            $departments = Department::with(['module'])->where('id', $authObject->user()->department->first()->id);
        } else {
            $departments = Department::with(['module']);
        }
    }
    return $departments ? $departments->get() : [];
}

function checkAuthorization($permitted_roles)
{
    $user_role = (string)Auth::user()->user_role_id;
    $permitted_roles = is_array($permitted_roles) ? $permitted_roles : [$permitted_roles];

    if (in_array($user_role, $permitted_roles)) {
        return true;
    }
    return false;
}

/**
 * Check And Return Default Permissions of The Given Module (ALL or Department )
 * @param $moduleId
 * @return array|null
 */

function checkDefaultPermission($moduleId, $authUser)
{
    $userDepartmentId = getMyDepartmentId($authUser);
    if ($userDepartmentId && strlen($userDepartmentId) > 0) {
        $permission = ModulePermission::join('modules', 'modules__permissions.module_id', '=', 'modules.id')
            ->where('module_id', $moduleId)
            ->whereNotNull('department_id')
            ->where(function ($sql) use ($userDepartmentId) {
                $sql->where('default_all', 1)
                    ->orWhere(function ($query) use ($userDepartmentId) {
                        $query->where('default_department', 1)
                            ->where('department_id', $userDepartmentId);
                    });
            })
            ->get(['modules__permissions.id as id'])->pluck('id')->all();
        if (count($permission))
            return $permission;
    }
    return false;
}


/**
 * Get Auth User Id If Logged
 * @return bool|mixed
 */
function getAuthUserId($authObject)
{
    return $authObject->check() ? $authObject->user()->id : false;
}

/**
 * Set Created And Updated By Fields If Not Set
 * @param $record
 */
function setCreatedUpdatedBy(&$record, $authObject)
{
    if ($record && is_object($record)) {
        $authUserId = getAuthUserId($authObject);

        if (!$record->updated_by && $authUserId)
            $record->updated_by = $authUserId;

        if (!$record->created_by && $authUserId)
            $record->created_by = $authUserId;

        $record->save();
    }
}

function chatDateFormat($date, $time = FALSE)
{
    if (strtotime(date('d-M-y', strtotime($date))) == strtotime(date('d-M-y'))) {
        $datePart = "";
    } elseif (strtotime(date('d-M-y', strtotime($date))) == strtotime(date('d-M-y', strtotime('yesterday')))) {
        $datePart = 'Yesterday, ';
    } else {
        $datePart = date('d-M-y', strtotime($date)) . ", ";
    }

    return $datePart . date('H:i', strtotime($date));
}


function getUserChatStatusIconClass($chatStatus)
{
    switch ($chatStatus) {
        case STATUS_AWAY:
            $class = "glyphicon glyphicon-ban-circle chat-users-away-sm";
            break;
        case STATUS_DONT_DISTURB:
            $class = "glyphicon glyphicon-minus-sign chat-users-do_not_disturb-sm";
            break;
        case STATUS_INVISIBLE:
            $class = "glyphicon glyphicon-eye-open chat-users-invisible-sm";
            break;
        case STATUS_OFFLINE:
            $class = "glyphicon glyphicon-remove-circle chat-users-offline-sm";
            break;
        default:
        case STATUS_ONLINE:
            $class = "glyphicon glyphicon-ok-circle chat-users-online-sm";
            break;
    }
    return $class;
}

function getUserChatStatusBtnClass($chatStatus)
{
    switch ($chatStatus) {
        case STATUS_AWAY:
            $class = "btn btn-warning";
            break;
        case STATUS_DONT_DISTURB:
            $class = "btn btn-danger";
            break;
        case STATUS_INVISIBLE:
            $class = "btn btn-primary";
            break;
        case STATUS_OFFLINE:
            $class = "btn btn-danger";
            break;
        default:
        case STATUS_ONLINE:
            $class = "btn btn-success";
            break;
    }
    return $class;
}

function getUserChatStatusTabClass($chatStatus)
{
    switch ($chatStatus) {
        case STATUS_AWAY:
            $class = "chat-btn-away";
            break;
        case STATUS_DONT_DISTURB:
            $class = "chat-btn-do_not_disturb";
            break;
        case STATUS_INVISIBLE:
            $class = "chat-btn-invisible";
            break;
        case STATUS_OFFLINE:
            $class = "chat-btn-offline";
            break;
        default:
        case STATUS_ONLINE:
            $class = "chat-btn-online";
            break;
    }
    return $class;
}

function baseFullDateFormat($date, $time = FALSE, $excludeYear = FALSE)
{
    if ($time) {
        return date("G", strtotime($date));
    } else {
        return date("G", strtotime($date));
    }
}


function ukDateFormat($date, $time = FALSE, $splitDateSign = " ", $excludeYear = FALSE, $includeSeconds = FALSE)
{
    if ($excludeYear) {
        $format = 'm' . $splitDateSign . 'd';
    } else {
        $format = 'd' . $splitDateSign . 'm' . $splitDateSign . 'Y';
    }

    if ($time) {
        $format .= " H:i" . ($includeSeconds ? ":s" : "");

        return date($format, strtotime($date));
    } else {
        return date($format, strtotime($date));
    }
}

function setFlightsStationSectorInfo(&$flights){
    if (!$flights){
        return;
    }

    foreach ($flights as $flight) {
        setFlightStationSectorInfo($flight);
    }
}

function setFlightStationSectorInfo(&$flight){
    if (!$flight->station || !$flight->station->count()){
        return;
    }

    debug($flight);

    $info = [];
    $depAP = getFlightDepartureAirport($flight);
    $arrAP = getFlightArrivalAirport($flight);

    foreach ($flight->station as $each){
        $index = (($depAP && $each->airport_id == $depAP->id )
            || ($arrAP && $each->airport_id == $arrAP->id)) ? $each->airport_id : "tra";

        $info[$index] = [
            "ap"        => $each->airport,
            "pax_a"     => $each->pax_a,
            "pax_c"     => $each->pax_c,
            "pax_y"     => $each->pax_y,
            "pax_inf"   => $each->pax_inf,
            "pax_total" => $each->pax_a + $each->pax_c + $each->pax_y,
        ];
    }

    $flight->sectors = $info;
}



function baseUSDateFormat($date, $time = FALSE, $splitDateSign = " ", $excludeYear = FALSE, $includeSeconds = FALSE, $month = "m")
{
    if (!$date){
        return "";
    }

    if ($time){
        if ($date === EMPTY_DATETIME){
            return "";
        }
    }
    else {
        if ($date == EMPTY_DATE){
            return "";
        }
    }

    if ($excludeYear) {
        $format = $month . $splitDateSign . 'd';
    } else {
        $format = 'Y'.$splitDateSign . $month . $splitDateSign .'d' ;
    }

    if ($time) {
        $format .= " H:i" . ($includeSeconds ? ":s" : "");

        return date($format, strtotime($date));
    } else {
        return date($format, strtotime($date));
    }
}


function baseDateFormat($date, $time = FALSE, $splitDateSign = " ", $excludeYear = FALSE, $includeSeconds = FALSE, $month = "M")
{
    if (!$date){
        return "";
    }

    if ($time){
        if ($date === EMPTY_DATETIME){
            return "";
        }
    }
    else {
        if ($date == EMPTY_DATE){
            return "";
        }
    }


    if ($excludeYear) {
        $format = $month . $splitDateSign . 'd';
    } else {
        $format = 'd' . $splitDateSign . $month . $splitDateSign . 'y';
    }

    if ($time) {
        $format .= " H:i" . ($includeSeconds ? ":s" : "");

        return date($format, strtotime($date));
    } else {
        return date($format, strtotime($date));
    }
}

function baseDateFormatYear($date, $time = FALSE)
{
    if ($time)
        return date('d M Y H:i', strtotime($date));
    else
        return date('d M Y', strtotime($date));
}

function baseTimeFormat($time, $separator = ":")
{
    return $time ? date("H{$separator}i", strtotime($time)) : "";
}

function newDateFormat($date, $time = FALSE)
{
    if ($time)
        return strtoupper(date('dM H:i', strtotime($date)));
    else
        return strtoupper(date('dM', strtotime($date)));
}

function getMonthName($date)
{
    return date('F', strtotime($date));
}

/**
 * Apply Conditions To Query
 * @param $query
 * @param $conditions
 */
function handleConditions(&$query, $conditions)
{
    /* Sample. Each Of Condition
     * [ 'condition' => 'where',
         'field'     => 'user',
         'operator'  => 'LIKE',
         'values'    => 'ABDC' ]*/

    foreach ($conditions as $each) {
        $condition = $each['condition'];
        $field = isset($each['field']) ? $each['field'] : null;
        $operator = isset($each['operator']) ? $each['operator'] : null;
        $values = isset($each['values']) ? $each['values'] : null;

        switch ($condition) {
            CASE in_array($condition, [WHERE, OR_WHERE]):
                $query->{$condition}($field, $operator, $values);
                break;
            CASE in_array($condition, [WHERE_BETWEEN, WHERE_IN]):
                $query->{$condition}($field, $values);
                break;
            CASE in_array($condition, [WHERE_NULL, WHERE_NOT_NULL]):
                $query->{$condition}($field);
                break;
            CASE ORDER_BY:
                $query->orderBy($field, $values);
                break;
            CASE GROUP_BY:
                $query->groupBy($field);
                break;
            CASE LIMIT:
                $query->limit($values);
                break;
        }
    }
}

/**
 * Get Revenue Period And Type
 * @param bool $revenue_type
 * @param bool $report_period_id
 * @param bool $date_from
 * @param bool $date_to
 * @return array
 */
function revenueGetPeriod($revenue_type = FALSE, $report_period_id = FALSE, $date_from = FALSE, $date_to = FALSE)
{

    if ($revenue_type && $revenue_type == REVENUE_SOLD) {
        $var_from = 'sales_from';
        $var_to = 'sales_to';
    } // By Default Revenue Type is FLOWN
    else {
        $var_from = 'departure_from';
        $var_to = 'departure_to';
    }
    // By Default Period Is Set To Yesterday
    if (!$date_from)
        $date_from = date('Y-m-d 00:00:00', strtotime('- 1 day'));
    if (!$date_to)
        $date_to = date('Y-m-d 23:59:59', strtotime('- 1 day'));

    // If Period Is Set,
    if ($report_period_id) {
        list($date_from, $date_to) = getReportPeriod($report_period_id);
    }

    $period = [
        $var_from => $date_from,
        $var_to => $date_to
    ];

    return $period;
}

function setFlightDepartureDate($flight, $save = false){
    if ($flight->std && $flight->std != EMPTY_DATETIME){
        $flight->departure_date = $flight->std;
    }
    else if ($flight->ptd && $flight->ptd != EMPTY_DATETIME){
        $flight->departure_date = $flight->ptd;
    }
    else if ($flight->etd && $flight->etd != EMPTY_DATETIME){
        $flight->departure_date = $flight->etd;
    }
    else if ($flight->atd && $flight->atd != EMPTY_DATETIME){
        $flight->departure_date = $flight->atd;
    }
    else if ($flight->abn && $flight->abn != EMPTY_DATETIME){
        $flight->departure_date = $flight->abn;
    }

    if ($save){
        $flight->save();
    }
}

function setFlightArrivalDate($flight, $save = false){
    if ($flight->sta && $flight->sta != EMPTY_DATETIME){
        $flight->arrival_date = $flight->sta;
    }
    else if ($flight->pta && $flight->pta != EMPTY_DATETIME){
        $flight->arrival_date = $flight->pta;
    }
    else if ($flight->eta && $flight->eta != EMPTY_DATETIME){
        $flight->arrival_date = $flight->eta;
    }
    else if ($flight->tdn && $flight->tdn != EMPTY_DATETIME){
        $flight->arrival_date = $flight->tdn;
    }
    else if ($flight->ata && $flight->ata != EMPTY_DATETIME){
        $flight->arrival_date = $flight->ata;
    }

    if ($save){
        $flight->save();
    }
}

function getAirlineLogoWithSize($airline, $width = 256){

    $path = storage_path("app/public/airlines/img/{$airline->picture}");

    if (File::exists($path)) {
//        $fileContents = File::get($path);
        $fileExtension = strtolower(substr(strrchr($airline->picture, "."), 1));
    }
    else {
        $path = "/assets/img/default-airline-picture.png";
//        $fileContents = File::get(asset("/assets/img/default-airline-picture.png"));
        $fileExtension = "png";
    }

//    $image =  \Intervention\Image\Facades\Image::make($path)->resize($width, null, function ($constraint) {
//        $constraint->aspectRatio();
//    });

    $image = \Intervention\Image\Facades\Image::make(file_get_contents($path))->resize($width, null, function ($constraint) {
        $constraint->aspectRatio();
    });
    $image->encode($fileExtension);

    return $image->response('png', "70");

//    return preparePicResponse($fileContents, $fileExtension);
}

function preparePicResponse($fileContents, $fileExtension){

    switch( $fileExtension ) {
        case "gif": $ctype="image/gif"; break;
        case "png": $ctype="image/png"; break;
        case "jpeg":
        case "jpg": $ctype="image/jpeg"; break;
        default:
            $ctype="image/jpeg"; break;
    }

    $response = \Illuminate\Support\Facades\Response::make($fileContents, 200);
    $response->header('Content-Type', $ctype);
    return $response;
}

function getStaffListBySLA($staffList, $sla){
    $data = [];
    if (isset($staffList[$sla]) && $staffList[$sla] && count($staffList[$sla])){
        foreach ($staffList[$sla] as $item) {
            $data[] = getUserName($item->user);
        }
    }
    return $data;
}


function getReportTime($crewType, $departure)
{
    $reportTime = false;
    switch ($crewType) {
        case FCM_CREW:
            $reportTime = date('dMy H:i', strtotime("- " . FCM_CREW_REPORT_TIME . " minutes", strtotime($departure)));
            break;
        case CCM_CREW:
            $reportTime = date('dMy H:i', strtotime("- " . CCM_CREW_REPORT_TIME . " minutes", strtotime($departure)));
            break;
    }
    return $reportTime;
}


/**
 * Get Report Period From And To
 * @param $report_period_id
 * @return array
 */
function getReportPeriod($report_period_id)
{
    if ($report_period_id) {
        switch ($report_period_id) {
            case PERIOD_TODAY:
                $date_from = date('Y-m-d 00:00:00');
                $date_to = date('Y-m-d 23:59:59');
                break;
            case PERIOD_YESTERDAY:
                $date_from = date('Y-m-d 00:00:00', strtotime('- 1 day'));
                $date_to = date('Y-m-d 23:59:59', strtotime('- 1 day'));
                break;
            case PERIOD_LAST_7_DAYS:
                $date_from = date('Y-m-d 00:00:00', strtotime('- 7 days'));
                $date_to = date('Y-m-d 23:59:59', strtotime('- 1 day'));
                break;
            case PERIOD_LAST_28_DAYS:
                $date_from = date('Y-m-d 00:00:00', strtotime('- 28 days'));
                $date_to = date('Y-m-d 23:59:59', strtotime('- 1 day'));
                break;
            case PERIOD_MONTH_TO_DATE:
                $date_from = date('Y-m-01 00:00:00');
                $date_to = date('Y-m-d  23:59:59', strtotime('- 1 days'));
                break;
            case PERIOD_LAST_90_DAYS:
                $date_from = date('Y-m-d 00:00:00', strtotime('- 90 days'));
                $date_to = date('Y-m-d 23:59:59', strtotime('- 1 day'));
                break;
            case PERIOD_YEAR_TO_DATE:
                $date_from = date('Y-01-01 00:00:00');
                $date_to = date('Y-m-d   23:59:59', strtotime('- 1 days'));
                break;
            case PERIOD_LAST_365_DAYS:
                $date_from = date('Y-m-d 00:00:00', strtotime('- 365 days'));
                $date_to = date('Y-m-d 23:59:59', strtotime('- 1 day'));
                break;
            default:
                $date_from = date('Y-m-d 00:00:00', strtotime('- 1 day'));
                $date_to = date('Y-m-d 23:59:59', strtotime('- 1 day'));
                break;
        }
        return [$date_from, $date_to];
    }
}


/**
 * Remove Blank Attributes
 * @param $inputs
 */
function removeBlankAttributes(&$inputs)
{
    foreach ($inputs as $j => $each) {
        if ($each === '')
            unset($inputs[$j]);
    }
}

/**
 * Remove Null Values From Given Array
 * @param $array
 */
function removeNullValues(&$array)
{
    foreach ($array as $j => $each) {
        if (!$each)
            unset($array[$j]);
    }
}

/**
 * Replace Blank Attributes with Null
 * @param $inputs
 * @param null $replacement
 */
function replaceBlankAttributes(&$inputs, $replacement = NULL)
{
    foreach ($inputs as $j => $each) {
        if (!$each)
            $inputs[$j] = $replacement;
    }
}

/**
 * Remove Fields That We Don't Require
 * @param $inputs
 * @param $fields
 */
function removeUnnecessaryField(&$inputs, $fields)
{
    if ($fields) {
        if (is_array($fields)) {
            foreach ($fields as $each) {
                if (array_key_exists($each, $inputs))
                    unset($inputs[$each]);
            }
        } else {
            if (array_key_exists($fields, $inputs))
                unset($inputs[$fields]);
        }
    }
}

function decryptMessage($crypted, $Key) {

    //проверяем, чтобы длина ключа была 8 символов
    if (mb_strlen($Key,'utf-8') !== 8)
        throw new Exception ("Неверная длина ключа");

    //устанавливаем тип алгоритма
    $keySize      = MCRYPT_RIJNDAEL_128;
    $mode         = MCRYPT_MODE_CBC;

    //формируем полный ключ, полный ключ состоит из повторяющихся четыре раза ключа, итого 32 байта
    $fullkeystring=$Key.$Key.$Key.$Key;

    //преобразуем ключ из строки в байтовый массив
    $mykey=pack("H*",strtoupper($fullkeystring));

    //IV используем нулевой
    $iv=pack("H*",'00000000000000000000000000000000');

    //преобразуем строку к верхнему регистру, а затем из шестнадцатеричного кода преобразуем в массив байтов
    $BinMessage=pack("H*",strtoupper($crypted));

    //дешифруем сообщение
    $decrypt=mcrypt_decrypt($keySize, $mykey, $BinMessage, $mode, $iv);

    //обрезаем пробелы
    $result = trim($decrypt);

    //проверяем, корректно ли расшифровалось, или нет
    if (strpos($result,'_crc_') !== false && strpos($result,'_crc_') === 0) {

        //убираем лишний мусор содержащейся в конце строки
        if (strpos($result, chr(0))>0)
            $result = substr($result, 0, strpos($result, chr(0)));

        return substr ($result, 5);  //если все нормально, возвращаем строку
    }
    else throw new Exception ("Неверный ключ шифрования");
}

function generateString($length = 10)
{
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}
function generateRandomPassword($length = 10)
{
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%^&*()-+';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}

function generateEmail($lastName, $firstName, $domain)
{

    $i = 1;
    do {
        $email = strtolower(str_replace(" ", "-", $lastName)) . "." . strtolower(str_replace(" ", "-", $firstName)) . ($i > 1 ? ".{$i}" : "") . "@" . $domain;
        $user = \App\Models\User::where("email", $email)
            ->first();
        $i++;
    } while ($user != null);

    return $email;
}


function paginate($data, $currentPage = 1, $perPage = 5)
{
    $currentPage = $currentPage ? $currentPage : 1;
    $min = (($currentPage * $perPage) - $perPage) + 1;
    $max = $currentPage * $perPage;
    $count = 1;
    $page_data = [];
    foreach ($data as $item) {
        if ($count >= $min && $count <= $max) {
            $page_data[] = $item;
        }
        $count++;
    }
    $pages = ceil(count($data) / $perPage);
    return [
        'pagination' => new LengthAwarePaginator($data, count($data), $perPage, $currentPage, [
            'path' => Paginator::resolveCurrentPath(),
        ]),
        'pageData' => $page_data,
        'pages' => $pages,
        'currentPage' => $currentPage
    ];
}


function removeCommas($str)
{
    return str_replace(',', '', $str);
}

/**
 * Soft Delete Given Objects
 * @param $objects
 * @param $userId
 */
function softDeleteObject(&$objects, $userId)
{
    if ($objects && $userId) {
        if (count($objects) > 1) {
            foreach ($objects as $each) {
                $each->updated_by = $userId;
                $each->deleted_at = date('Y-m-d H:i:s');
                $each->save();
            }
        } else {
            $objects->updated_by = $userId;
            $objects->deleted_at = date('Y-m-d H:i:s');
            $objects->save();
        }
    }
}


/**
 * Soft Delete Given Objects
 * @param $objects
 * @param $userId
 */
function restoreObject(&$objects, $userId)
{
    if ($objects && $userId) {
        if (count($objects) > 1) {
            foreach ($objects as $each) {
                $each->updated_by = $userId;
                $each->deleted_at = null;
                $each->save();
            }
        } else {
            $objects->updated_by = $userId;
            $objects->deleted_at = null;
            $objects->save();
        }
    }
}

function isProductionEnv(){
    return app()->environment() == PRODUCTION;
}

function applicationStatusSpan($status)
{
    $span = "";
    if ($status) {
        switch ($status) {
            case APPLICATION_STATUS_PENDING:
                $span = '<span class="label label-primary">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_APPROVED:
                $span = '<span class="label label-success">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_CHANGE:
                $span = '<span class="label label-warning">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_DECLINED:
                $span = '<span class="label label-danger">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_IN_LINE:
                $span = '<span class="label label-info">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_VOID:
                $span = '<span class="label label-danger">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_CANCELLED:
                $span = '<span class="label label-default">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_DOCUMENTATION_IN_PROCESS:
                $span = '<span class="label label-info">' . $status . '</span>';
                break;
            case APPLICATION_STATUS_DOCUMENTATION_COMPLETED:
                $span = '<span class="label label-success">' . $status . '</span>';
                break;
        }
    }
    return $span;
}

function getWorkingDays($startDate, $endDate, $holidays = [])
{
    // do strtotime calculations just once
    $endDate = strtotime($endDate);
    $startDate = strtotime($startDate);


    //The total number of days between the two dates. We compute the no. of seconds and divide it to 60*60*24
    //We add one to inlude both dates in the interval.
    $days = ($endDate - $startDate) / 86400 + 1;

    $no_full_weeks = floor($days / 7);
    $no_remaining_days = fmod($days, 7);

    //It will return 1 if it's Monday,.. ,7 for Sunday
    $the_first_day_of_week = date("N", $startDate);
    $the_last_day_of_week = date("N", $endDate);

    //---->The two can be equal in leap years when february has 29 days, the equal sign is added here
    //In the first case the whole interval is within a week, in the second case the interval falls in two weeks.
    if ($the_first_day_of_week <= $the_last_day_of_week) {
        if ($the_first_day_of_week <= 6 && 6 <= $the_last_day_of_week) $no_remaining_days--;
        if ($the_first_day_of_week <= 7 && 7 <= $the_last_day_of_week) $no_remaining_days--;
    } else {
        // (edit by Tokes to fix an edge case where the start day was a Sunday
        // and the end day was NOT a Saturday)

        // the day of the week for start is later than the day of the week for end
        if ($the_first_day_of_week == 7) {
            // if the start date is a Sunday, then we definitely subtract 1 day
            $no_remaining_days--;

            if ($the_last_day_of_week == 6) {
                // if the end date is a Saturday, then we subtract another day
                $no_remaining_days--;
            }
        } else {
            // the start date was a Saturday (or earlier), and the end date was (Mon..Fri)
            // so we skip an entire weekend and subtract 2 days
            $no_remaining_days -= 2;
        }
    }

    //The no. of business days is: (number of weeks between the two dates) * (5 working days) + the remainder
//---->february in none leap years gave a remainder of 0 but still calculated weekends between first and last day, this is one way to fix it
    $workingDays = $no_full_weeks * 5;
    if ($no_remaining_days > 0) {
        $workingDays += $no_remaining_days;
    }

    //We subtract the holidays
    foreach ($holidays as $holiday) {
        $time_stamp = strtotime($holiday);
        //If the holiday doesn't fall in weekend
        if ($startDate <= $time_stamp && $time_stamp <= $endDate && date("N", $time_stamp) != 6 && date("N", $time_stamp) != 7)
            $workingDays--;
    }

    return $workingDays;
}

function getHolidaysByStationIDs(){
    $currYear = date("Y");

    $holidays = \App\Models\Holiday::with("holidayAirports")
//                    ->whereRaw("YEAR(fixed_date) = {$currYear}")
        ->whereNull("deleted_at")
        ->orderBy("fixed_date")
        ->get();

    $stations = \App\Models\Airport::listHandlingStations("id");

    $result = [];

    foreach ($holidays as $holiday) {
//        $year = date("Y", strtotime($holiday->fixed_date));

        if ($holiday->all_stations){
            foreach ($stations as $airportID){
                if (!isset($result[$airportID])){
                    $result[$airportID] = [];
                }

                $result[$airportID][] = $holiday->fixed_date;
            }
        }
        else {
            foreach ($holiday->holidayAirports as $each){
                if (!isset($result[$each->airport_id])){
                    $result[$each->airport_id] = [];
                }

                $result[$each->airport_id][] = $holiday->fixed_date;
            }
        }
    }

    return $result;
}

function getHolidaysByStation($airportID, $year = null)
{
    if (!$year) {
        $year = date("Y");
    }

    $holidays = \App\Models\Holiday::with("holidayAirports")
        ->whereRaw("YEAR(fixed_date) = {$year}")
        ->whereNull("deleted_at")
        ->orderBy("fixed_date")
        ->get();

    $result = [];

    foreach ($holidays as $holiday) {
        if ($holiday->all_stations){
            $result[] = $holiday->fixed_date;
        }
        else {
            foreach ($holiday->holidayAirports as $each){
                if ($each->airport_id == $airportID){
                    $result[] = $holiday->fixed_date;
                    break;
                }
            }
        }
    }

    $result = array_unique($result);

    return $result;
}

function blackoutDaysConflict($station, $from, $to, $year = null){
    if (!$year){
        $year = date("Y");
    }

    $airline = env(\AIRLINE);
    $period = null;
    switch ($airline) {
        case GSRM:
            $period = getBlackoutPeriodByStation($station, $year);
            break;

        default:
            break;
    }

    if (!$period){
        return false;
    }

    debug($period);

    foreach ($period as $arr) {
        if (isset($arr[0]) && isset($arr[1])){
            if (strtotime($from) >= strtotime($arr[0]) && strtotime($from) <= strtotime($arr[1])
                || strtotime($to) >= strtotime($arr[0]) && strtotime($to) <= strtotime($arr[1])
                || strtotime($from) <= strtotime($arr[0]) && strtotime($to) >= strtotime($arr[1])){
                return true;
            }
        }
        else if (isset($arr[0])){
            if (strtotime($from) == strtotime($arr[0]) || strtotime($to) == strtotime($arr[0]) ||
                strtotime($from) <= strtotime($arr[0]) && strtotime($to) >= strtotime($arr[0])){
                return true;
            }
        }
    }

    return false;
}

function findDepartmentHeadPosition($department){
    if ($department){
        $position = Position::where("head_of_department", true)
            ->where("department_id", $department->id)
            ->first();

        if (!$position){
            $positionIDs = Position::where("department_id", $department->id)->pluck("id")->all();

            $position = Position::where("department_id", $department->id)
                ->whereNotIn("reports_to_id", $positionIDs)
                ->first();
        }

        if (!$position){
            $position = Position::whereNull("reports_to_id")
                ->first();
        }
    }
    else {
        $position = Position::whereNull("reports_to_id")
            ->where(function($sql){
                $sql->where("name", "Managing Director")
                    ->orWhere("name", "CEO");
            })
            ->first();
    }

    return $position;
}

function initOrganizationChain($department){
    $position = findDepartmentHeadPosition($department);

    if (!$position){
        return [];
    }

    $chain = [];

    $users = findUsersByPosition($position->id);

    debug("INIT Position: {$position->name}");

    if (count($users)) {
        foreach ($users as $user) {

            $userLocationAirportID = getUserLocationAirport($user, true);

            $chain[] = prepareOrganizationUserChain(null, $user, $department, $userLocationAirportID, $position);

        }
    }
    else {
        $staffAirports = StaffStation::currentStaffStationsList();

        foreach ($staffAirports as $airportID){

            $chain[] = prepareOrganizationUserChain(null, null, $department, $airportID, $position);
        }

    }

    return $chain && count($chain) ? $chain : null;
}

function findReportsToPositionsTopDown($department, $parentPosition, $airportID, $parentUser = null){

    $chain = [];

    if (!$parentPosition){
        return null;
    }

    $positions = \App\Models\Position::where("reports_to_id", $parentPosition->id)
        ->whereNull("deleted_at");

    if ($department){
        $positions->where("department_id", $department->id);
    }

    $positions = $positions->get();

    if (count($positions)){

        foreach ($positions as $position){

            $users = findUsersByPosition($position->id, $airportID);

            if (count($users)) {

                foreach ($users as $user) {

                    $userLocationAirportID = getUserLocationAirport($user, true);

                    // Passenger Handling - Station Manager is excluded
                    // Passenger Handling - Station Admin Officer

                    $chain[] = prepareOrganizationUserChain($parentUser, $user, $department, $userLocationAirportID, $position);
                }
            }
            else {

                debug("NO users for Position: {$position->name}, Station: {$airportID}");

                $chain[] = prepareOrganizationUserChain($parentUser, null, $department, $airportID, $position);
            }
        }
    }

    return $chain && count($chain) ? $chain : null;
}

function prepareOrganizationUserChain($parentUser, $user, $department, $airportID, $position){
    return [
        "user"      => getUserObjectCompact($user, $parentUser),
        "position"  => getPositionObjectCompact($position, $airportID, $parentUser),
        "reportees" => findReportsToPositionsTopDown($department, $position, $airportID, $user)
    ];
}

function getUserObjectCompact($user, $parentUser = null){

    if (!$user){
        return null;
    }

    $obj = new stdClass();
    $obj->id = $user->id;
    $obj->parent_id = $parentUser ? $parentUser->id : null;

    $obj->location = getUserLocation($user);
    $obj->first_name = $user->first_name;
    $obj->last_name = $user->last_name;
    $obj->email = $user->email;
    $obj->phone = $user->phone;
    $obj->picture = $user->picture;
    $obj->reports_to_user_id = $user->reports_to_user_id;

    return $obj;
}

function getPositionObjectCompact($position, $airportID, $parentUser = null){

    if (!$position){
        return null;
    }

    $obj = new stdClass();
    $obj->id = $airportID ? intval($airportID.$position->id) : $position->id;
    $obj->name = $position->name;
    $obj->location = getAirportById($airportID);

    $obj->reports_to_id = $parentUser ? $parentUser->id : intval($airportID.$position->reports_to_id);

    return $obj;
}

function getPositionsOrganizationJsonForChart(&$result, $organization, $init = false)
{
//    $result = [];

    if (!$organization){
        return null;
    }

    foreach ($organization as $i => $data) {

        $reporteesExists = checkIfUsersExistsInReportees($data["reportees"]);

        if ($data["user"] || $reporteesExists){
            $result[] = organizationItem($data["user"], $data["position"], $init);
            getPositionsOrganizationJsonForChart($result, $data["reportees"], false);
        }

    }

//    return count($result) ? $result : null;
}

function checkIfUsersExistsInReportees($organization){
    if (!$organization){
        return false;
    }

    while($organization) {
        foreach ($organization as $i => $data) {
            if ($data["user"]){
                return true;
            }

            return checkIfUsersExistsInReportees($data["reportees"]);
        }
    }

    return false;
}

function organizationItem($user, $position, $init = false){
    $item = new \stdClass();
    //
    $item->id = $user ? $user->id : $position->id;
    //
    $item->parent = $init ? null : ($user && $user->parent_id ? $user->parent_id : $position->reports_to_id);
    $item->description = $position->name;

    $item->email = $user ? $user->email : '';
    $item->image = $user && $user->picture ? asset("storage/users/" . $user->picture) : asset("/assets/img/default-user-picture.png");
//        $item->itemTitleColor = $bgColor;
    $item->phone = $user ? $user->phone : '';

    if ($user){
        $item->title = $user->location. ", <a href='" . route("homepage") . "#staff/{$user->id}'>{$user->first_name} {$user->last_name}</a>";
    }
    else {
        $item->title = $position->location;
    }

//    if ($user && $user->reports_to_user_id) {
//        $item->title .= '<a href="' . url("organization/new-chart/user/{$user->reports_to_user_id}") . '">' .
//                        '<span style="float:right" class="glyphicon glyphicon-chevron-up"></span>' .
//                        '</a>';
//    }

    $item->label = $user ? $user->first_name . " " . $user->last_name : "";

    return $item;
}

function getOrganizationJsonForChart($organization)
{
    $data = [];

    // Get User Ids Array
    $arrayUserIds = getArrayUserId($organization);

    foreach ($organization as $i => $user) {
        if (!$user) {
            continue;
        }

        $picture = $user ? $user->picture : 'profile.png';
        $position = $user->position()->first();

        $item = new \stdClass();
        $item->id = $arrayUserIds[$user->id];
        $reportToUserId = $user->reports_to_user_id;

        $item->parent = $reportToUserId ? (isset($arrayUserIds[$reportToUserId]) ? $arrayUserIds[$reportToUserId] : null) : null;
        $item->description = ($position ? $position->name : '');
        $item->email = $user ? $user->email : '';
        $item->image = storage_path("app/public/users/$picture");
//        $item->itemTitleColor = $bgColor;
        $item->phone = $user ? $user->phone : '';
        $item->title = $user ? "<a href='" . route("homepage") . "#staff/{$user->id}'>" . $user->first_name . " " . $user->last_name . '</a>' : "";

        if ($user->reports_to_user_id) {
            $item->title .= '<a href="' . url("organization/new-chart/user/{$user->reports_to_user_id}") . '">' .
                '<span style="float:right" class="glyphicon glyphicon-chevron-up"></span>' .
                '</a>';
        }

        $item->label = $user ? $user->first_name . " " . $user->last_name : "";

        $data[] = $item;
    }

    debug($data);

    return json_encode($data);
}

function findReportsToPositions($staffID, $position, $staffStationID){
    $chain = [];

    // HDQ
    $baseStationID = 28873;

    while($position){
        $position = \App\Models\Position::find($position->reports_to_id);

        if ($position){
            $user = findUserByPosition($position->id, $staffStationID, $staffID);

            // Passenger Handling - Station Manager is excluded
            // Passenger Handling - Station Admin Officer
            if (!$user && $staffStationID != $baseStationID && !in_array($position->id, [354, 365])){
                $user = findUserByPosition($position->id, $baseStationID, $staffID);
            }

            if ($user){
                $chain[] = $user;
            }
        }
    }

    return $chain;
}

function sendSimpleEmail($content, $subject = "Notification Exception"){
    Mail::to( "dilovar88@mail.ru")
        ->send(new TemplateEmail($content, $subject));
//        ->send(new TemplateEmail( $bodyText, $subject));
}

function getShowLeaveRequestsUser(){
    $positions = \App\Models\Position::where("show_leave_requests", true)
        ->get();

    $users = [];
    foreach ($positions as $position) {
        $search = findUserByPosition($position->id);
        if ($search){
            $users[$search->id] = $search;
        }
    }

    return $users;
}

function getSubdepartmentsList($departmentID){
    return \App\Models\SubDepartment::where("department_id", $departmentID)
        ->whereNull("deleted_at")
        ->pluck("name", "id")
        ->all();
}

function findUserByPosition( $positionID, $stationID = null, $excludeUserID = null){
    $result = \App\Models\User::join('users__departments', 'users.id', '=', 'users__departments.user_id');

    if ($stationID) {
        $result->join("locations", "locations.id", "=", "users.location_id")
            ->where("airport_id", $stationID);
    }

    if ($excludeUserID){
        $result->where("users.id", "!=", $excludeUserID);
    }

    return $result->where("position_id", $positionID)
        ->whereNull("users.vs")
        ->whereNull("users.deleted_at")
        ->where(function($sql){
            $sql->whereNull("users.resigned_date")
                ->orWhere("users.resigned_date", EMPTY_DATE)
                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
        })
        ->first([
            "users.*"
        ]);
}

function findUsersByPosition( $positionID, $stationID = null, $excludeUserID = null){
    $result = \App\Models\User::join('users__departments', 'users.id', '=', 'users__departments.user_id');

    if ($stationID) {
        $result->join("locations", "locations.id", "=", "users.location_id")
            ->where("airport_id", $stationID);
    }

    if ($excludeUserID){
        $result->where("users.id", "!=", $excludeUserID);
    }

    return $result->where("position_id", $positionID)
        ->whereNull("users.vs")
        ->whereNull("users.deleted_at")
        ->where(function($sql){
            $sql->whereNull("users.resigned_date")
                ->orWhere("users.resigned_date", EMPTY_DATE)
                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
        })
        ->get([
            "users.*"
        ]);
}




function getPositionsByDepartments($departmentIDs){
    $positions = Position::whereIn("department_id", $departmentIDs)
//        ->whereNull('subdepartment_id')
        ->orderBy("name")
        ->pluck("name", "id")
        ->all();

    return $positions;
}

function getLibrarySignUsers($librarySign){
    if (!$librarySign){
        return null;
    }

    return listLibrarySignUsers($librarySign, 1);
}

function getLibraryLastSignUsers($library){
    if (!$library){
        return null;
    }

    return listLibrarySignUsers($library->lastSign, 1);
}

/**
 * Array 1 - IDs 2- Full Names
 *
 * @param $sign
 * @param int $array
 * @return array|string|null
 */
function listLibrarySignUsers($sign, $array = 0){
    if (!$sign || !$sign->users || !count($sign->users)){
        return null;
    }

    if ($array) {
        $arr = [];
        foreach ($sign->users as $item) {
            if (in_array($item->user_id, [42, 44])){
                continue;
            }

            if ($array == 1){
                $arr[] = $item->user_id;
            }
            elseif ($array == 2){
                $arr[] = getUserName($item->user);
            }
        }

        return $arr;
    }
    else {
        $str = "";
        foreach ($sign->users as $item) {
            $str .= getUserName($item->user) . ", ";
        }

        $str = rtrim($str, ", ");

        return $str;
    }
}


function getLibrarySignLocations($librarySign){
    if (!$librarySign){
        return null;
    }

    return listLibrarySignLocations($librarySign, 1);
}

function getLibraryLastSignLocations($library){
    if (!$library){
        return null;
    }

    return listLibrarySignLocations($library->lastSign, 1);
}

function listLibrarySignLocations($sign, $array = 0){
    if (!$sign || !$sign->locations || !count($sign->locations)){
        return null;
    }

    if ($array) {
        $arr = [];
        foreach ($sign->locations as $item) {
            if ($array == 1){
                $arr[] = $item->location_id;
            }
            else if ($array == 2){
                $arr[] = $item->location->airport->iata;
            }
        }

        return $arr;
    }
    else {
        $str = "";
        foreach ($sign->locations as $item) {
            $str .= $item->location->airport->iata . ", ";
        }
        $str = rtrim($str, ", ");

        return $str;
    }

}

function getLibrarySignDepartments($librarySign){
    if (!$librarySign){
        return null;
    }

    return listLibrarySignDepartments($librarySign, 1);
}

function getLibraryLastSignDepartments($library){
    if (!$library){
        return null;
    }

    return listLibrarySignDepartments($library->lastSign, 1);
}

function listLibrarySignDepartments($sign, $array = 0){
    if (!$sign || !$sign->departments || !count($sign->departments)){
        return null;
    }

    if ($array) {
        $arr = [];
        foreach ($sign->departments as $item) {
            if ($array == 1){
                $arr[] = $item->department_id;
            }
            else if ($array == 2){
                $arr[] = $item->department->name;
            }

        }

        return $arr;
    }
    else {
        $str = "";
        foreach ($sign->departments as $item) {
            $str .= $item->department->name . ", ";
        }

        $str = rtrim($str, ", ");

        return $str;
    }
}

function getLibrarySignPositions($librarySign){
    if (!$librarySign){
        return null;
    }

    return listLibrarySignPositions($librarySign, 1);
}

function getLibraryLastSignPositions($library){
    if (!$library){
        return null;
    }

    return listLibrarySignPositions($library->lastSign, 1);
}

function listLibrarySignPositions($sign, $array = 0){
    if (!$sign || !$sign->positions || !count($sign->positions)){
        return null;
    }

    if ($array) {
        $arr = [];
        foreach ($sign->positions as $item) {
            if ($array == 1){
                $arr[] = $item->position_id;
            }
            else if ($array == 2){
                $arr[] = $item->position->name;
            }
        }

        return $arr;
    }
    else {
        $str = "";
        foreach ($sign->positions as $item) {
            $str .= $item->position->name . ", ";
        }

        $str = rtrim($str, ", ");

        return $str;
    }
}

function findUsersByDepartmentPositionLocation($locationIDs = null, $departmentIDs = null, $positionIDs = null, $excludeUsersIDs = null,
                                               $listItems = null){
    $result = \App\Models\User::join('users__departments', 'users.id', '=', 'users__departments.user_id');

    if ($locationIDs) {
        $result->whereIn("users.location_id", $locationIDs);
    }

    if ($excludeUsersIDs){
        $excludeUsersIDs = is_array($excludeUsersIDs) ? $excludeUsersIDs : [$excludeUsersIDs];
        $result->whereNotIn("users.id", $excludeUsersIDs);
    }

    if ($departmentIDs){
        $result->whereIn("department_id", $departmentIDs);
    }

//    if ($subdepartmentID){
//        $result->where("subdepartment_id", $subdepartmentID);
//    }

    if ($positionIDs){
        $result->whereIn("position_id", $positionIDs);
    }

    $result->whereNull("users.vs")
        ->whereNull("users.deleted_at")
        ->where(function($sql){
            $sql->whereNull("users.resigned_date")
                ->orWhere("users.resigned_date", EMPTY_DATE)
                ->orWhere("users.resigned_date", ">", date("Y-m-d"));
        })
        ->orderBy("users.first_name");

    if ($listItems){
        return $result->get([
            DB::raw("CONCAT(first_name, ' ', last_name) as name"),
            "users.id as id"
        ]);
    }

    return $result->get([
        "users.*"
    ]);
}

function sendLeaveNotificationEmail($toEmail, $user, $leaveRequest, $type, $toAdmins = false){

    if (app()->environment() != PRODUCTION){
        return;
    }

    $mail = Mail::to($toEmail);

//    if ($toAdmins){
//        $mail->bcc("ejaz.1.khan@gmail.com");
//             ->bcc("dilovar88@mail.ru");
//    }

    switch ($type){
        case APPLICATION_STATUS_APPROVED:
            $view = "emails/leaves/leave-approved-by-ceo";
            $subject = $leaveRequest->leave->name ." approved for ".getUserName($user);
            break;

        case APPLICATION_STATUS_DECLINED:
            $view = "emails/leaves/leave-declined";
            $subject = $leaveRequest->leave->name ." rejected for ".getUserName($user);
            break;

        case APPLICATION_STATUS_CHANGE:
            $view = "emails/leaves/leave-change";
            $subject = $leaveRequest->leave->name ." reschedule for ".getUserName($user);
            break;

        case APPLICATION_STATUS_PENDING:
        default:
            $view = "emails/leaves/leave-apply";
            $subject = $leaveRequest->leave->name ." request for ".getUserName($user);
            break;
    }

    $mail->send(new TemplateEmail(view($view, [
            "reminderTitle"     => "",
            "user"              => $user,
            "leaveRequest"      => $leaveRequest,
        ])->render()
    ,  $subject));
}

function getBlackoutPeriodByStation($station, $year = null){
    if (!$year){
        $year = date("Y");
    }

    if ($year == 2021) {
        switch ($station) {
            case "BER":
                return [
                    ["2021-03-29", "2021-04-10"],
                    ["2021-06-24", "2021-08-06"],
                    ["2021-10-11", "2021-10-23"],
                    ["2021-12-23", "2021-12-31"],
                ];

            case "HAJ":
                return [
                    ["2021-03-29", "2021-04-09"],
                    ["2021-05-14", "2021-05-25"],
                    ["2021-07-22", "2021-09-01"],
                    ["2021-10-18", "2021-10-29"],
                    ["2021-12-23", "2022-01-07"],
                ];

            case "HAM":
                return [
                    ["2021-03-01", "2021-03-12"],
                    ["2021-05-10", "2021-05-14"],
                    ["2021-06-24", "2021-08-04"],
                    ["2021-10-04", "2021-10-15"],
                    ["2021-12-23", "2022-01-04"],
                ];

            case "CGN":
            case "DUS":
                return [
                    ["2021-03-29", "2021-04-10"],
                    ["2021-05-25"],
                    ["2021-07-05", "2021-08-17"],
                    ["2021-10-11", "2021-10-23"],
                    ["2021-12-24", "2022-01-08"],
                ];

            case "FRA":
                return [
                    ["2021-04-06", "2021-04-16"],
                    ["2021-07-19", "2021-08-27"],
                    ["2021-10-11", "2021-10-23"],
                    ["2021-12-23", "2022-01-08"],
                ];

            case "STR":
                return [
                    ["2021-04-01", "2021-04-10"],
                    ["2021-05-25", "2021-06-05"],
                    ["2021-07-29", "2021-09-11"],
                    ["2021-10-31", "2021-11-06"],
                    ["2021-12-23", "2022-01-08"],
                ];

            case "MUC":
                return [
                    ["2021-03-29", "2021-04-10"],
                    ["2021-05-25", "2021-06-04"],
                    ["2021-07-30", "2021-09-13"],
                    ["2021-11-02", "2021-11-17"],
                    ["2021-12-24", "2022-01-08"],
                ];
        }
    }
    else if ($year == 2022){
        switch ($station) {
            case "BER":
                return [
                    ["2022-04-11", "2022-04-23"],
                    ["2022-07-07", "2022-08-19"],
                    ["2022-10-24", "2022-11-05"],
                    ["2022-12-22", "2023-01-02"],
                ];

            case "HAJ":
                return [
                    ["2022-04-04", "2022-04-19"],
                    ["2022-05-27", "2022-06-07"],
                    ["2022-07-14", "2022-08-24"],
                    ["2022-10-17", "2022-10-28"],
                    ["2022-12-23", "2023-01-06"],
                ];

            case "HAM":
                return [
                    ["2022-03-07", "2022-03-18"],
                    ["2022-05-23", "2022-05-27"],
                    ["2022-07-07", "2022-08-17"],
                    ["2022-10-10", "2022-10-21"],
                    ["2022-12-23", "2023-01-06"],
                ];

            case "CGN":
            case "DUS":
                return [
                    ["2022-04-11", "2022-04-23"],
                    ["2022-06-27", "2022-08-09"],
                    ["2022-10-04", "2022-10-15"],
                    ["2022-12-23", "2023-01-06"],
                ];

            case "FRA":
                return [
                    ["2022-04-11", "2022-04-23"],
                    ["2022-07-25", "2022-09-02"],
                    ["2022-10-24", "2022-10-29"],
                    ["2022-12-22", "2023-01-07"],
                ];

            case "STR":
                return [
                    ["2022-04-14", "2022-04-23"],
                    ["2022-06-07", "2022-06-18"],
                    ["2022-07-28", "2022-09-10"],
                    ["2022-10-31", "2022-11-04"],
                    ["2022-12-21", "2023-01-07"],
                ];

            case "MUC":
                return [
                    ["2022-04-11", "2022-04-23"],
                    ["2022-06-07", "2022-06-18"],
                    ["2022-08-01", "2022-09-12"],
                    ["2022-10-31", "2022-11-16"],
                    ["2022-12-24", "2023-01-07"],
                ];
        }
    }
}


function getDistanceBetweenPoints($latitude1, $longitude1, $latitude2, $longitude2, $unit = 'Mi')
{
    $theta = $longitude1 - $longitude2;
    $distance = (sin(deg2rad($latitude1)) * sin(deg2rad($latitude2))) + (cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta)));
    $distance = acos($distance);
    $distance = rad2deg($distance);
    $distance = $distance * 60 * 1.1515;
    switch ($unit) {
        case 'Mi':
            break;
        case 'Km' :
            $distance = $distance * 1.609344;
            break;
    }
    return (round($distance, 2));
}


function makeUniqueByColumn($data, $column, $onlyUniqueValues = TRUE)
{
    $unique = $data->keyBy($column);

    if ($onlyUniqueValues) {
        return array_keys($unique->all());
    }

    return $unique->all();
}

function collectionToArray($data)
{
    $newData = [];
    $total_pax = 0;
    $total_revenue = 0;
    $total_period_pax = [];
    $total_period_revenue = [];

    foreach ($data as $each) {
        if (!isset($newData[$each->pos])) {
            $newData[$each->pos] = [];
            if (isset($each->bound)) {
                $newData[$each->pos]['bound'] = $each->bound;
            }
        }

        if (!isset($newData[$each->pos]['country'])) {
            $newData[$each->pos]['country'] = $each->country;
        }
        if (!isset($newData[$each->pos]['country_id'])) {
            $newData[$each->pos]['country_id'] = $each->country_id;
        }
        if ($each->city && !isset($newData[$each->pos]['city'])) {
            $newData[$each->pos]['city'] = $each->city;
        }
        if ($each->city_id && !isset($newData[$each->pos]['city_id'])) {
            $newData[$each->pos]['city_id'] = $each->city_id;
        }
        if ($each->agency_id && !isset($newData[$each->pos]['agency_id'])) {
            $newData[$each->pos]['agency_id'] = $each->agency_id;
        }

        // Totals
        if (!isset($newData[$each->pos]['revenue'])) {
            $newData[$each->pos]['revenue'] = [
                'total' => 0
            ];
        }
        $newData[$each->pos]['revenue']['total'] += $each->revenue;

        if (!isset($newData[$each->pos]['pax'])) {
            $newData[$each->pos]['pax'] = [
                'total' => 0
            ];
        }
        $newData[$each->pos]['pax']['total'] += $each->pax;

        // Totals (By Period)

        if (!isset($newData[$each->pos]['revenue'][$each->period])) {
            $newData[$each->pos]['revenue'][$each->period] = 0;
        }
        $newData[$each->pos]['revenue'][$each->period] += $each->revenue;

        if (!isset($newData[$each->pos]['pax'][$each->period])) {
            $newData[$each->pos]['pax'][$each->period] = 0;
        }
        $newData[$each->pos]['pax'][$each->period] += $each->pax;


        // Grand Total
        $total_pax += $each->pax;
        $total_revenue += $each->revenue;

        // Total PAX By Period
        if (!isset($total_period_pax[$each->period])) {
            $total_period_pax[$each->period] = 0;
        }
        $total_period_pax[$each->period] += $each->pax;

        // Total PAX By Period
        if (!isset($total_period_revenue[$each->period])) {
            $total_period_revenue[$each->period] = 0;
        }
        $total_period_revenue[$each->period] += $each->revenue;
    }

    $newData['pax'] = $total_period_pax;
    $newData['revenue'] = $total_period_revenue;

    $newData['pax']['total'] = $total_pax;
    $newData['revenue']['total'] = $total_revenue;

    return $newData;
}


function collectionToArrayRouteReport($data)
{
    $newData = [];
    $total_pax = 0;
    $total_revenue = 0;
    $total_period_pax = [];
    $total_period_revenue = [];

    foreach ($data as $each) {
        if (!isset($newData[$each->route])) {
            $newData[$each->route] = [];
        }
        if (!isset($newData[$each->route][$each->pos])) {
            $newData[$each->route][$each->pos] = [
                'bound' => $each->bound
            ];
        }

        // Sector Totals
        if (!isset($newData[$each->route][$each->pos]['revenue'])) {
            $newData[$each->route][$each->pos]['revenue'] = [
                'total' => 0
            ];
        }
        $newData[$each->route][$each->pos]['revenue']['total'] += $each->revenue;

        if (!isset($newData[$each->route][$each->pos]['pax'])) {
            $newData[$each->route][$each->pos]['pax'] = [
                'total' => 0
            ];
        }
        $newData[$each->route][$each->pos]['pax']['total'] += $each->pax;


        // Sector Totals (Period)
        if (!isset($newData[$each->route][$each->pos]['revenue'][$each->period])) {
            $newData[$each->route][$each->pos]['revenue'][$each->period] = 0;
        }
        $newData[$each->route][$each->pos]['revenue'][$each->period] += $each->revenue;

        if (!isset($newData[$each->route][$each->pos]['pax'][$each->period])) {
            $newData[$each->route][$each->pos]['pax'][$each->period] = 0;
        }
        $newData[$each->route][$each->pos]['pax'][$each->period] += $each->pax;

        // Route Totals
        if (!isset($newData[$each->route]['pax'])) {
            $newData[$each->route]['pax'] = [
                'total' => 0
            ];
        }
        if (!isset($newData[$each->route]['revenue'])) {
            $newData[$each->route]['revenue'] = [
                'total' => 0
            ];
        }
        $newData[$each->route]['revenue']['total'] += $each->revenue;
        $newData[$each->route]['pax']['total'] += $each->pax;

        // Route Totals (Period)
        if (!isset($newData[$each->route]['revenue'][$each->period])) {
            $newData[$each->route]['revenue'][$each->period] = 0;
        }
        $newData[$each->route]['revenue'][$each->period] += $each->revenue;

        if (!isset($newData[$each->route]['pax'][$each->period])) {
            $newData[$each->route]['pax'][$each->period] = 0;
        }
        $newData[$each->route]['pax'][$each->period] += $each->pax;

        // Grand Total
        $total_pax += $each->pax;
        $total_revenue += $each->revenue;

        // PAX Totals
        if (!isset($total_period_pax[$each->period])) {
            $total_period_pax[$each->period] = 0;
        }
        $total_period_pax[$each->period] += $each->pax;

        if (!isset($total_period_revenue[$each->period])) {
            $total_period_revenue[$each->period] = 0;
        }
        $total_period_revenue[$each->period] += $each->revenue;
    }

    $newData['pax'] = $total_period_pax;
    $newData['revenue'] = $total_period_revenue;

    $newData['pax']['total'] = $total_pax;
    $newData['revenue']['total'] = $total_revenue;

    return $newData;
}


function paxAndRevenueChartsData($data)
{
    $paxChart = [];
    $revenueChart = [];
    $xAxisValues = [];
    foreach ($data as $index => $each) {
        $newData = [];
        if (isset($each['pax'])) {
            $newData[] = $index;
            foreach ($each['pax'] as $j => $paxEach) {
                if ($j == "total")
                    continue;
                $newData[$j] = $paxEach;
                if (!isset($xAxisValues[$j])) {
                    $xAxisValues[strtoupper($j)] = 1;
                }
            }
            $paxChart[] = $newData;
        }
        $newData = [];
        if (isset($each['revenue'])) {
            $newData[] = $index;
            foreach ($each['revenue'] as $j => $revenueEach) {
                if ($j == "total")
                    continue;
                $newData[$j] = $revenueEach;
            }
            $revenueChart[] = $newData;
        }
    }

    // Sort By PAX
    $filter = 1;
    /* usort($paxChart, function($arr1, $arr2) use ($filter) {
         return ($arr1[$filter] < $arr2[$filter]) ? 1 : -1;
     });*/

    // Sort By Revenue
    $filter = 1;
    /*usort($revenueChart, function($arr1, $arr2) use ($filter) {
        return ($arr1[$filter] < $arr2[$filter]) ? 1 : -1;
    });*/

    //usort($paxChart, "sortArrayBySubArrayValue");

    $xAxisValues = array_keys($xAxisValues);

    foreach ($xAxisValues as $each) {
        foreach ($revenueChart as &$chart) {
            if (!isset($chart[$each]))
                $chart[$each] = 0;
        }
        foreach ($paxChart as &$chart) {
            if (!isset($chart[$each]))
                $chart[$each] = 0;
        }
    }

    foreach ($revenueChart as &$chart) {
        $firstElement = $chart[0];
        $leftoverArray = array_slice($chart, 1);
        ksort($leftoverArray);
        $chart = array_merge([$firstElement], array_values($leftoverArray));
    }

    foreach ($paxChart as &$chart) {
        $firstElement = $chart[0];
        $leftoverArray = array_slice($chart, 1);
        ksort($leftoverArray);
        $chart = array_merge([$firstElement], array_values($leftoverArray));
    }

    sort($xAxisValues);

    return [$paxChart, $revenueChart, $xAxisValues];
}

function sortArrayBySubArrayValue($a, $b)
{
    return $a[1] - $b[1];
}


function getCurrentLanguageImgSrc()
{
    $currentLanguage = \Illuminate\Support\Facades\Session::get('applocale');

    switch ($currentLanguage) {
        case "ru":
            $img = 'assets/img/icons/flags/24/Russia.png';
            break;
        case "en":
        default:
            $img = 'assets/img/icons/flags/24/United Kingdom.png';
    }

    return $img;
}

function getCurrentLanguageLocale($upstring = false)
{
    $locale = \Illuminate\Support\Facades\Session::get('applocale');
    if (!$locale)
        $locale = "en";
    return $upstring ? strtoupper($locale) : $locale;
}


function getUserLocation($user, $returnID = false){
    if (!$user || !$user->location || !$user->location->airport){
        return null;
    }

    if ($returnID)
        return $user->location->airport_id;

    return $user->location->airport->iata;
}

function getUserLocationAirport($user, $returnID = false){
    if (!$user || !$user->location || !$user->location->airport){
        return null;
    }

    if ($returnID)
        return $user->location->airport_id;

    return $user->location->airport->iata;
}

function getLocationAirport($location){
    if (!$location || !$location->airport){
        return "";
    }

    return $location->airport->iata ? $location->airport->iata : $location->airport->icao;
}

function getUserLocationByID($userID){
    if (!$userID){
        return "";
    }

    $user = User::with([
        "location",
        "location.airport",
    ])->find($userID);

    if (!$user->location || !$user->location->airport){
        return "";
    }

    return $user->location->airport->iata;
}


function convertMonthNumberToName($monthYear)
{
    $newString = $monthYear;
    preg_match('/(\d{2})\s*([-|,|.|\/]\s*)\s*(\d{4})/', $monthYear, $matches);
    if (count($matches)) {
        if (isset($matches[1])) {
            $newString = monthName(intval($matches[1]), TRUE);
            debug($newString);
        }
        if (isset($matches[2])) {
            $newString .= $matches[2];
        }
        if (isset($matches[3])) {
            $newString .= !isset($matches[2]) ? ", " . $matches[3] : $matches[3];
        }
    }
    return $newString;
}

function createLangString($string)
{
    if (!$string || trim($string) == ""){
        return null;
    }

    $string = str_replace([" ", "  ", "   "], "_", str_replace([" & ", "& ", " &", "&"], "_and_", strtolower($string)));
    $string = str_replace(["/", "/  ", " /", " / "], "_", $string);
    $string = str_replace(["-", "-  ", " -", " - "], "_", $string);
    $string = rtrim($string);
    $string = rtrim($string, "_");

    return $string;
}

function GetCrewPositionAbbr($position)
{
    $abbr = "";
    switch (trim($position)) {
        case PILOT_INSTRUCTOR_POSITION:
            $abbr = "INSTR";
            break;

        case CAPTAIN_POSITION :
        case FLIGHT_OPERATIONS_DIRECTOR_POSITION:
            $abbr = "CAPT";
            break;

        case FIRST_OFFICER_POSITION:
            $abbr = "FO";
            break;

        case CHIEF_PILOT_POSITION:
            $abbr = "CHF-CAPT";
            break;

        case COPILOT_JUNIOR_POSITION:
            $abbr = "FO-JNR";
            break;

        case PURSER_POSITION:
            $abbr = "PSR";
            break;

        case FLIGHT_ATTENDANT_POSITION:
            $abbr = "FA";
            break;

        case FLIGHT_ATTENDANT_N2_POSITION:
            $abbr = "FA-#2";
            break;

        case FLIGHT_ATTENDANT_JUNIOR_POSITION:
            $abbr = "FA-JNR";
            break;

        case INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            $abbr = "INSTR";
            break;

        case SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            $abbr = "SEN-INSTR";
            break;
    }

    return $abbr;
}

function GetCrewPositionCssClass($position)
{
    $className = "";
    switch (trim($position)) {
        case PILOT_INSTRUCTOR_POSITION:
            $className = "instructor";
            break;

        case CAPTAIN_POSITION:
        case FLIGHT_OPERATIONS_DIRECTOR_POSITION:
            $className = "captain";
            break;

        case FIRST_OFFICER_POSITION:
            $className = "";
            break;

        case CHIEF_PILOT_POSITION:
            $className = "captain";
            break;

        case COPILOT_JUNIOR_POSITION:
            $className = "junior";
            break;

        case PURSER_POSITION:
            $className = "purser";
            break;

        case FLIGHT_ATTENDANT_POSITION:
            $className = "";
            break;

        case FLIGHT_ATTENDANT_N2_POSITION:
            $className = "fa_n2";
            break;

        case FLIGHT_ATTENDANT_JUNIOR_POSITION:
            $className = "junior";
            break;

        case INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            $className = "instructor";
            break;

        case SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION:
            $className = "instructor";
            break;
    }
    return $className;
}

function isRoleU($anotherUser)
{
    $authUser = Auth::user();
    $authDepartment = $authUser->department[0];

    if ($authUser->user_role_id == ROLE_DEPARTMENT_ADMIN) {
        if ($authDepartment->id != $anotherUser->department[0]->id) {
            return false;
        }
    } else if (!$authUser->user_role_id ||$authUser->user_role_id == ROLE_USER) {
        if (!($authUser->view_crew_profile || $authUser->edit_crew_profile)) {
            if ($authUser->id != $anotherUser->id) {
                return false;
            }
        }
    }

    return true;
}

function getEmailNotificationGroup(){
    return ["" => "Select"] + EmailNotification::pluck("name", "id")->all();
}

function isUserAuthorizedToView($anotherUser)
{
    $authUser = Auth::user();

    if (!$authUser || !$anotherUser){
        return false;
    }

    if (!$authUser->user_role_id){
        $authUser->user_role_id = ROLE_USER;
        $authUser->save();
    }

    $authUserRoleID = $authUser->user_role_id ? $authUser->user_role_id : ROLE_USER;

    if ($authUser->id == $anotherUser->id){
        return true;
    }

    if ($authUser->vs && isUserSuperAdmin($authUser)){
        return true;
    }

    // Another SUPER ADMIN PROFILE => DENIED ACCESS
    if (in_array($anotherUser->user_role_id, [ROLE_SUPER_ADMIN])){
        return false;
    }

    // ADMINS => GRANTED
    if (in_array($authUserRoleID, [ROLE_SUPER_ADMIN])){
        return true;
    }

    if ($authUserRoleID == ROLE_ADMIN &&
        (!$anotherUser->user_role_id || in_array($anotherUser->user_role_id, [ROLE_USER, ROLE_DEPARTMENT_ADMIN]))){
        return true;
    }

    if (in_array($authUserRoleID, [ROLE_USER, ROLE_DEPARTMENT_ADMIN]) && in_array($anotherUser->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN])){
        return false;
    }

    // NO DEPT SPECIFIED => DENIED ACCESS
    if (!isset($anotherUser->department[0]) && !$anotherUser->department_id) {
        return false;
    }

    $anotherUserDeptID = isset($anotherUser->department[0]) && $anotherUser->department[0] ? $anotherUser->department[0]->id : $anotherUser->department_id;


    $authDepartment = null;
    if ($authUser->department && isset($authUser->department[0])) {
        $authDepartment = $authUser->department[0];
    }

    // STAFF NO DEPT SPECIFIED => DENIED ACCESS, ONLY APPLIED FOR USERS AND DEPT-ADMINS
    if (in_array($authUserRoleID, [ROLE_USER, ROLE_DEPARTMENT_ADMIN]) && !$authDepartment) {
        return false;
    }

    // WATCH DIFF DEPT PROFILE => DENIED ACCESS
    if (in_array($authUserRoleID, [ROLE_USER, ROLE_DEPARTMENT_ADMIN]) && $authDepartment && $authDepartment->id != $anotherUserDeptID){
        return false;
    }

    // SAME DEPT ADMIN => GRANTED
//    if ($authUserRoleID == ROLE_DEPARTMENT_ADMIN) {
//        return true;
//    }

    $viewEditPermission = UserModule::join("modules", "modules.id", "=", "users__modules.module_id")
        ->join("modules__permissions", "modules__permissions.id", "=", "users__modules.module_permission_id")
        ->where("user_id", $authUser->id)
        ->where("modules.name", STAFF_LIST)
        ->whereIn("modules__permissions.name", [VIEW_PERMISSION, EDIT_PERMISSION])
        ->whereNull("users__modules.deleted_at")
        ->first();

    if ($viewEditPermission){
        return true;
    }

    // SAME STAFF WITH OPTION TO SEE PROFILE => GRANTED
    if ($authUser->view_crew_profile || $authUser->edit_crew_profile) {
        return true;
    }

    return false;
}

function trimMax($str){
    return preg_replace('/^\p{Z}+|\p{Z}+$/u', '', trim($str));
}

function isAnyAdmin()
{
    $authUser = Auth::user();

    return in_array($authUser->user_role_id, [ROLE_SUPER_ADMIN, ROLE_ADMIN, ROLE_DEPARTMENT_ADMIN]);
}
function isAdmin()
{
    $authUser = Auth::user();

    return in_array($authUser->user_role_id, [ROLE_ADMIN]);
}

function isAdminOrSuperAdmin()
{
    $authUser = Auth::user();

    return $authUser && in_array($authUser->user_role_id, [ROLE_SUPER_ADMIN, ROLE_ADMIN]);
}

function isUserSuperAdmin($user)
{
    return $user && $user->user_role_id == ROLE_SUPER_ADMIN;
}

function isSuperAdmin()
{
    $authUser = Auth::user();

    return $authUser && $authUser->user_role_id == ROLE_SUPER_ADMIN;
}

function GetIPDetails()
{
    $ip = $_SERVER['REMOTE_ADDR'];
    $content = null;
    try {
        $content = file_get_contents("http://ipinfo.io/{$ip}/json");
        return json_decode($content);
    } catch (Exception $e) {
        return null;
    }
}



function getArrayUserId($organization)
{
    $array = [];
    $j = 0;
    foreach ($organization as $each) {
        if ($each && !isset($array[$each->id]))
            $array[$each->id] = $j++;
    }
    return $array;
}


function getGenderIcon($gender)
{
    if ($gender) {
        if (in_array(strtolower($gender), [MALE, "m"])) {
            return '<i class="fa fa-sm fa-male">';
        } else if (in_array(strtolower($gender), [FEMALE, "f"])) {
            return '<i class="fa fa-sm fa-female">';
        }
    }
    return $gender;
}

function getGenderAbbr($gender)
{
    if ($gender) {
        if (in_array(strtolower($gender), [MALE, "m"])) {
            return 'M';
        } else if (in_array(strtolower($gender), [FEMALE, "f"])) {
            return 'F';
        }
    }

    return $gender;
}


function getCountryAircraftCodes()
{
    $countryCodes = \App\Models\Country::pluck("icao_aircraft")
        ->all();

    $countryAircraftCodes = [
        1 => [],
        2 => [],
        3 => [],
        4 => [],
    ];

    foreach ($countryCodes as $each) {
        $part = explode(",", $each);
        foreach ($part as $str) {
            if (!$str) {
                continue;
            }
            $countryAircraftCodes[strlen($str)][] = $str;
        }
    }

    return $countryAircraftCodes;
}

function partitionAircraftCode($mvtName, $countryAircraftCodes = [])
{

    if (count($countryAircraftCodes) == 0) {
        $countryAircraftCodes = getCountryAircraftCodes();
    }

    if (strlen($mvtName) < 5) {
        return $mvtName;
    }

    for ($i = 4; $i >= 1; $i--) {
        $name = substr($mvtName, 0, $i);
        foreach ($countryAircraftCodes[$i] as $code) {
            if ($code == $name) {
                return $code . "-" . substr($mvtName, $i, (strlen($mvtName) - $i));
            }
        }
    }

    return $mvtName;
}

function getPreferredDaysOff($userID){
    return \App\Models\UserPreferredOff::firstOrCreate(["user_id" => $userID]);
}

function checkFromTo($objFrom, $objTo){
    if (!$objFrom || !$objTo){
        return false;
    }

    return strtotime($objFrom) > strtotime($objTo);
}

function weekDaysArray($withNames = false, $max6 = false)
{
    if ($withNames){
        return [
            1 => "Monday",
            2 => "Tuesday",
            3 => "Wednesday",
            4 => "Thursday",
            5 => "Friday",
            6 => "Saturday",
            ($max6 ? 0 : 7) => "Sunday"
        ];
    }

    return [
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        ($max6 ? 0 : 7) => ($max6 ? 0 : 7)
    ];
}

function flightHasStaff($flight){
    if ($flight->flightStaff && count($flight->flightStaff)){
        foreach ($flight->flightStaff as $staff) {
            if ($staff->deleted_at){
                continue;
            }

            return true;
        }
    }

    return false;
}

function staffRequirementClass($req, $min, $act, $background = false)
{
    if ($req === null || $min === null || $act === null) {
        return "default";
    }
    if ($background) {
        if ($act >= $req) {
            return "bg-success";
        } else if ($act == $min) {
            return "bg-warning";
        } else {
            return "bg-danger";
        }
    } else {
        if ($act >= $req) {
            return "success";
        } else if ($act == $min) {
            return "warning";
        } else {
            return "danger";
        }
    }
}

function staffRequirementMessage($req, $min, $act)
{
    if ($req === null || $min === null || $act === null) {
        return "";
    }
    if ($act == $req) {
        return '<span class="label label-success">Requirement Met</span>';
    } else if ($act == $min) {
        return '<span class="label label-warning">Minimum Accomplished</span>';
    } else {
        return '<span class="label label-danger">Minimum Not Met</span>';
    }
}

function shiftValidationClass($max, $min, $act)
{
    if ($max === null || $min === null || $act === null) {
        return "default";
    }

    if ($act > $max) {
        return "danger";
    } else if ($act == $max) {
        return "success";
    } else if ($act >= $min) {
        return "warning";
    } else {
        return "default";
    }
}

function accomplishmentStatus($act)
{
    if ($act === null) {
        return "bg-color-red";
    }

    if ($act >= 75) {
        return "bg-color-green";
    } else if ($act >= 50) {
        return "bg-color-orange";
    } else {
        return "bg-color-red";
    }
}

function getPunctualityBgColor($category)
{

    $bgColor = [
        'on_time' => 'rgba(0, 202, 14, 0.5)',
        'within_15_mins' => 'rgba(149, 246, 153, 0.5)',
        'within_30_mins' => 'rgba(251, 147, 147, 0.5)',
        'within_60_mins' => 'rgba(250, 106, 106, 0.5)',
        'above_60_mins' => 'rgba(221, 0, 0, 0.5)',
    ];

    return isset($bgColor[$category]) ? $bgColor[$category] : null;
}

function getPunctualityBgClass($category)
{

    $bgClass = [
        'on_time' => 'bg-color-on-time',
        'within_15_mins' => 'bg-color-within-15',
        'within_30_mins' => 'bg-color-within-30',
        'within_60_mins' => 'bg-color-within-60',
        'above_60_mins' => 'bg-color-above-60',
    ];

    return isset($bgClass[$category]) ? $bgClass[$category] : null;
}

function getPunctualityBgClassByPercentage($percentage)
{
    if ($percentage >= 90){
        return 'bg-color-above-90';
    }
    else if ($percentage >= 80){
        return 'bg-color-above-80';
    }
    else if ($percentage >= 70){
        return 'bg-color-above-70';
    }
    else if ($percentage >= 60){
        return 'bg-color-above-60m';
    }
    else if ($percentage >= 50){
        return 'bg-color-above-50';
    }
    else if ($percentage >= 40){
        return 'bg-color-above-40';
    }
    else {
        return 'bg-color-below-40';
    }
}

function getColorArray()
{
    $array = [
        "#0033cc",
        "#0000cc",
        "#0066cc",
        "#0099cc",
        "#00cccc",
        "#00ffcc",
        "#3300cc",
        "#3333cc",
        "#3366cc",
        "#3399cc",
        "#33cccc",
        "#33ffcc",
        "#6600cc",
        "#6633cc",
        "#6666cc",
        "#6699cc",
        "#66cccc",
        "#66ffcc",
        "#9900cc",
        "#9933cc",
        "#9966cc",
        "#9999cc",
        "#99cccc",
        "#99ffcc",
        "#cc00cc",
        "#cc33cc",
        "#cc66cc",
        "#cc99cc",
        "#cccccc",
        "#ccffcc",
        "#ff00cc",
        "#ff33cc",
        "#ff66cc",
        "#ff99cc",
        "#ffcccc",
        "#ffffcc",

        "#003366",
        "#000066",
        "#006666",
        "#009966",
        "#00cc66",
        "#00ff66",
        "#330066",
        "#333366",
        "#336666",
        "#339966",
        "#33cc66",
        "#33ff66",
        "#660066",
        "#663366",
        "#666666",
        "#669966",
        "#66cc66",
        "#66ff66",
        "#990066",
        "#993366",
        "#996666",
        "#999966",
        "#99cc66",
        "#99ff66",
        "#cc0066",
        "#cc3366",
        "#cc6666",
        "#cc9966",
        "#cccc66",
        "#ccff66",
        "#ff0066",
        "#ff3366",
        "#ff6666",
        "#ff9966",
        "#ffcc66",
        "#ffff66",

    ];
    shuffle($array);

    return json_encode($array);
}

function getFlightInfo($flight)
{

    if (!$flight) {
        return "-";
    }

    $flightNumber = $flight->flightNumber;
    $airline = $flightNumber->airline;
    $departureAirport = $flightNumber->departureAirport ? $flightNumber->departureAirport->iata : "";
    $arrivalAirport = $flightNumber->arrivalAirport ? $flightNumber->arrivalAirport->iata : "";
    $sector = $departureAirport . "-" . $arrivalAirport;

    return $airline->iata . "-" . $flightNumber->flight_number . "(" . $sector . ") | PTD:" . baseDateFormat($flight->ptd, true, "/");

}

/**
 * Get An Array of Types of Counters
 * @param $date
 * @param $counterTypes
 * @return array|bool
 */
function getCrewHoursCounterTypesArray($date, $counterTypes)
{
    if ($date && $counterTypes) {
        if (!is_array($counterTypes))
            $counterTypes = [$counterTypes];

        $types = null;

        foreach ($counterTypes as $type) {
            switch ($type) {
                case 'last365days':
                    $types[$type] = date('Y-m-d', strtotime("$date - 1 years"));
                    break;
                case 'yearToDate':
                    $types[$type] = date('Y-01-01', strtotime($date));
                    break;
                case 'monthToDate':
                    $types[$type] = date('Y-m-01', strtotime($date));
                    break;
                case 'last90days':
                    $types[$type] = date('Y-m-d', strtotime("$date - 90 days"));
                    break;
                case 'last28days':
                    $types[$type] = date('Y-m-d', strtotime("$date - 28 days"));
                    break;
                case 'last7days':
                    $types[$type] = date('Y-m-d', strtotime("$date - 7 days"));
                    break;
                case 'planned':
                    $types[$type] = date('Y-m-d', strtotime($date));
                    break;
            }
        }
        return $types;
    }
    return false;
}

/**
 * Get Label From Counter Type
 * @param $counterType
 * @return bool|string
 */
function getLabelOutOfCounterType($counterType)
{
    $label = false;
    if ($counterType) {

        switch ($counterType) {
            case "planned":
                $label = "PLANNED ROSTER TOTAL";
                break;
            case "last28days":
                $label = "LAST 28 DAYS TOTAL";
                break;
            case "last90days":
                $label = "LAST 90 DAYS TOTAL";
                break;
            case "last365days":
                $label = "LAST 365 DAYS TOTAL";
                break;
            case "fromTo":
                $label = "PERIOD";
                break;
            case 'default':
                $label = "LAST 28 DAYS TOTAL";
                break;

        }
        return $label;
    }
    return false;
}

/**
 * Calculate From And To Dates For Crew Hours Purposes
 * @param $counterTypes
 * @param bool $dateNow
 * @return array|bool
 */
function getFromToOutOfCounterTypeArray($counterTypes, $dateNow = false)
{
    if ($counterTypes) {
        $counterTypes = is_array($counterTypes) ? $counterTypes : [$counterTypes];
        $to = $dateNow ? $dateNow : date('Y-m-d');
        $from = date('Y-m-d');
        foreach ($counterTypes as $type => $date) {
            if ($type == 'planned')
                $date = date('Y-m-d', strtotime("$date + 30 days"));

            if (strtotime($date) < strtotime($from))
                $from = $date;

            if (strtotime($date) > strtotime($to))
                $to = $date;
        }
        return ['from' => $from, 'to' => $to];
    }
    return false;
}

function getSelectedPeriod($period = null, $from = null, $to = null)
{
    $date = date("Y-m-d");
    if (!$period) {
        $period = [
            'from' => $date,
            'to' => $date
        ];

        if ($from) {
            $period['from'] = $from;
        }
        if ($to) {
            $period['to'] = $to;
        }
    } else {
        if ($period == '') {
            $period = [
                'from' => $from,
                'to' => $to
            ];
        }
        else {
            // Get Counter Type
            $period = getCrewHoursCounterTypesArray($date, $period);

            // Get Period From And To
            $period = getFromToOutOfCounterTypeArray($period);
        }
    }

    return $period;
}

function getFlightMessages($flight, $margin = 10, $additionalClass = "departureArrivalType")
{
    if ((!$flight->message || !$flight->message->count()) && (!$flight->message2018 || !$flight->message2018->count())) {
        return "";
    }

    $spans = "";

    $pnlColorClass = 'bg-color-teal';
    $adlColorClass = 'bg-color-pinkDark';
    $prlColorClass = 'bg-color-redLight';

    $mvtDepColorClass = "bg-color-green";
    $mvtArrColorClass = "bg-color-blue";
    $psmArrColorClass = "bg-color-yellow";
    $ptmArrColorClass = "bg-color-pink";
    $tpmArrColorClass = "bg-color-grayDark";
    $cpmArrColorClass = "bg-color-greenLight";

    $ldmArrColorClass = "bg-color-red";
    $ldsArrColorClass = "bg-color-purple";


    $countedTypes = [
        ADL, PNL, PRL, MVT, LDM, LIR, PSM, PTM, TPM, CPM, CAL, LDS, LOADSHEET, LOADSHEET_FINAL
    ];

    $PNLs = $ADLs = $PRLs = 0;
    $MVTDep = $MVTArr = $LDMs = $PSMm = $PTMs = $TPMs = $LDSs = $CPMs = 0;
    foreach ($flight->message as $each) {

        $messageType = $each->message_type;

        $colorClass = 'bg-color-pinkDark';
        if ($each->message_type) {
            switch ($each->message_type) {
                case ADL:
                    $ADLs++;
                    break;

                case PNL:
                    $PNLs++;
                    break;

                case PRL:
                    $PRLs++;
                    break;

                case MVT:
                    $mvt = $each->mvt;
                    if ($mvt) {
                        if ($mvt->diversion) {
                            $colorClass = 'bg-color-red';
                            $messageType = 'DIV';
                        } else {
                            if ($mvt && $mvt->type == MVT_ARRIVAL){
                                $colorClass ="bg-color-blue";
                                $messageType = "MVT A";
                                $MVTArr++;
                            }
                            else {
                                $colorClass = "bg-color-green";
                                $messageType = "MVT D";
                                $MVTDep++;
                            }
                        }
                    }
                    break;

                case PSM:
                    $PSMm++;
                    $colorClass = 'bg-color-yellow';
                    break;

                case PTM:
                    $PTMs++;
                    $colorClass = 'bg-color-pink';
                    break;

                case TPM:
                    $TPMs++;
                    $colorClass = 'bg-color-grayDark';
                    break;

                case LDM:
                    $colorClass = 'bg-color-red';
                    $LDMs++;
                    break;

                case LDS:
                case LOADSHEET:
                case LOADSHEET_FINAL:
                    $messageType = LDS;
                    $colorClass = 'bg-color-purple';
                    $LDSs++;
                    break;

                case CPM:
                    $colorClass = 'bg-color-greenLight';
                    $CPMs++;
                    break;

                case LPM:
                    $colorClass = 'bg-color-blueLight';
                    break;

                case UCM:
                    $colorClass = 'bg-color-orange';
                    break;

                case CREW_LIST:
                    $colorClass = 'bg-color-magenta';
                    break;

                case OTHS:
                    $colorClass = 'bg-color-orangeDark';
                    break;

                default:
                    $colorClass = 'bg-color-pinkDark';
                    break;
            }

            if (!in_array($each->message_type, $countedTypes)) {
                $spans .= "<span style='margin:" . $margin . "px;' class='label {$colorClass} {$additionalClass}'>" . strtoupper($messageType) . "</span>";
            }
        }
    }

    if ($PNLs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$pnlColorClass} {$additionalClass}'>" . strtoupper(PNL) . ($PNLs > 1 ? " <span class='badge badge-success'>" . $PNLs . "</span>" : "") . "</span>";
    }
    if ($ADLs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$adlColorClass} {$additionalClass}'>" . strtoupper(ADL) . ($ADLs > 1 ? " <span class='badge badge-success'>" . $ADLs . "</span>" : "") . "</span>";
    }
    if ($PRLs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$prlColorClass} {$additionalClass}'>" . strtoupper(PRL) . ($PRLs > 1 ? " <span class='badge badge-success'>" . $PRLs . "</span>" : "") . "</span>";
    }

    if ($MVTDep) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$mvtDepColorClass} {$additionalClass}'>" . "MVT D" . ($MVTDep > 1 ? " <span class='badge badge-primary'>" . $MVTDep . "</span>" : "") . "</span>";
    }
    if ($MVTArr) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$mvtArrColorClass} {$additionalClass}'>" . "MVT A" . ($MVTArr > 1 ? " <span class='badge badge-primary'>" . $MVTArr . "</span>" : "") . "</span>";
    }
    if ($PSMm) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$psmArrColorClass} {$additionalClass}'>" . strtoupper(PSM) . ($PSMm > 1 ? " <span class='badge badge-primary'>" . $PSMm . "</span>" : "") . "</span>";
    }
    if ($PTMs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$ptmArrColorClass} {$additionalClass}'>" . strtoupper(PTM) . ($PTMs > 1 ? " <span class='badge badge-primary'>" . $PTMs . "</span>" : "") . "</span>";
    }
    if ($TPMs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$tpmArrColorClass} {$additionalClass}'>" . strtoupper(TPM) . ($TPMs > 1 ? " <span class='badge badge-primary'>" . $TPMs . "</span>" : "") . "</span>";
    }
    if ($CPMs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$cpmArrColorClass} {$additionalClass}'>" . strtoupper(CPM) . ($CPMs > 1 ? " <span class='badge badge-primary'>" . $CPMs . "</span>" : "") . "</span>";
    }
    if ($LDMs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$ldmArrColorClass} {$additionalClass}'>" . strtoupper(LDM) . ($LDMs > 1 ? " <span class='badge badge-primary'>" . $LDMs . "</span>" : "") . "</span>";
    }
    if ($LDSs) {
        $spans .= "<span style='margin:" . $margin . "px;' class='label {$ldsArrColorClass} {$additionalClass}'>" . strtoupper(LDS) . ($LDSs > 1 ? " <span class='badge badge-primary'>" . $LDSs . "</span>" : "") . "</span>";
    }

    return $spans;
}

function getFlightSimpleMessages($flight)
{
    if (!$flight->message || !$flight->message->count()) {
        return "";
    }

    $spans = "";

    foreach ($flight->message as $each) {
        if ($each->message_type) {
            $spans .= strtoupper($each->message_type) . ", ";
        }
    }

    trim(", ", $spans);

    return $spans;
}

function getFlightTimeComparedToBase($flight, $type, $baseArrDepDate, $timeSeparator = ":")
{
    if ($flight->{$type} && $flight->{$type} != EMPTY_DATETIME) {
        if (date("Y-m-d", strtotime($flight->{$type})) == $baseArrDepDate) {
            return baseTimeFormat($flight->{$type}, $timeSeparator);
        }
        return baseDateFormat($flight->{$type}, true, " ", true);
    }

    return "-";
}

function getFlightDepartureStatus($flight, $dep, $label = "")
{
    if (!$flight) {
        return "";
    }

    if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
        $diff = round((strtotime($flight->atd) - strtotime($dep)) / 60);
    }
    elseif ($flight->etd && $flight->etd != EMPTY_DATETIME) {
        $diff = round((strtotime($flight->etd) - strtotime($dep)) / 60);
    }
    else {
        return "";
    }

    if ($label){
        return $diff > 3 ? "badge-danger" : "badge-on-time";
    }

    return $diff > 3 ? "red" : "green";
}

function getFlightArrivalStatus($flight, $arr, $label = "")
{
    if (!$flight) {
        return "";
    }

    if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
        $diff = round((strtotime($flight->ata) - strtotime($arr)) / 60);
    }
    elseif ($flight->eta && $flight->eta != EMPTY_DATETIME) {
        $diff = round((strtotime($flight->eta) - strtotime($arr)) / 60);
    }
    else {
        return "";
    }

    if ($label){
        return $diff > 3 ? "badge-danger" : "badge-success";
    }

    return $diff > 3 ? "red" : "green";
}


function getFlightStatus($flight, $dep, $type = 1)
{
    if ($flight) {
        $diff = 0;
        if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
            $diff = round((strtotime($flight->atd) - strtotime($dep)) / 60);
        } elseif ($flight->etd && $flight->etd != EMPTY_DATETIME) {
            $diff = round((strtotime($flight->etd) - strtotime($dep)) / 60);
        }

        switch ($type) {
            case 2:
                return $diff > 3 ? "danger" : "success";

            default:
            case 1:
                return $diff > 3 ? "red" : "green";
        }

        /* if (count($flight->delays))
         {
             return "red";
         }*/
    }
}



function getFlightStatusMessage($flight, $depDateTime, $eta, $ata, $etd, $atd)
{
    if ($flight) {
        $nowDate = date("Y-m-d");
        $nowDateTime = date("Y-m-d H:i");

        $depDate = date("Y-m-d", strtotime($depDateTime));
        if (strtotime($depDateTime) > strtotime($nowDateTime)) {
            return "Scheduled";
        } else {
            if (strtotime($depDate) == strtotime($nowDate)) {
                if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                    return "Landed " . $ata;
                } elseif ($flight->eta && $flight->eta != EMPTY_DATETIME) {
                    return "Est. Arrival " . $eta;
                } elseif ($flight->atd && $flight->atd != EMPTY_DATETIME) {
                    return "Departed " . $atd;
                } elseif ($flight->etd && $flight->etd != EMPTY_DATETIME) {
                    return "Est. Departure " . $etd;
                } else {
                    return "Unknown";
                    /*
                    if ((strtotime($depDateTime) + 30 * 60) < strtotime($nowDateTime)) {
                        return "Unknown";
                    }
                    else {
                        return "In-flight";
                    }
                    */
                }
            } else {
                if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
                    return "Landed " . $ata;
                } else {
                    return "Unknown";
                }
            }
        }
    }
}

function getFlightProgressBarFlownPercentage($flight)
{
    if ($flight->atd && $flight->atd != EMPTY_DATETIME) {
        $flightStartTime = $flight->atd;
        $flightEndTime = $flight->sta;
        $now = date('Y-m-d H:i');

        if ($flight->ata && $flight->ata != EMPTY_DATETIME) {
            $flightEndTime = $flight->ata;
        }
        if ($flight->tdn && $flight->tdn != EMPTY_DATETIME) {
            $flightEndTime = $flight->tdn;
        } else if ($flight->eta && $flight->eta != EMPTY_DATETIME) {
            $flightEndTime = $flight->eta;
        } else if ($flight->pta && $flight->pta != EMPTY_DATETIME) {
            $flightEndTime = $flight->pta;
        }

        if (!$flightEndTime || $flightEndTime == EMPTY_DATETIME) {
            return 0;
        }

        if (strtotime($now) >= strtotime($flightEndTime)) {
            return 100;
        } else if (strtotime($now) < strtotime($flightStartTime)) {
            return 0;
        } else {
            $totalFlightTimeInSeconds = DateTimeDifference($flightStartTime, $flightEndTime);
            $flownRoute = DateTimeDifference($flightStartTime, $now);

            try {
                $perc = $totalFlightTimeInSeconds != 0 && is_int($flownRoute) && is_int($totalFlightTimeInSeconds) ? 100 * ($flownRoute / $totalFlightTimeInSeconds) : 0;
                return $perc;
            } catch (Exception $e) {
                return 0;
            }
        }
    }
    return 0;
}

function getSelectedFormPeriod($dateSearch, $dateFrom, $dateTo, $months, $year){
    $from = $to = null;
    switch ($dateSearch){
        case PERIOD_MONTH_YEAR:
            if ($months && count($months)){
                $from = date("Y-m-d", strtotime($year."-".$months[0]."-01"));
                $to = date("Y-m-t", strtotime($year."-".$months[count($months)-1]."-01"));
            }
            break;

        case PERIOD_FROM_TO:
            $from = $dateFrom;
            $to = $dateTo;

            break;
    }

    return [$from, $to];
}

function digitMonthYearToReadable($monthYear)
{
    $result = DateTime::createFromFormat("d m, Y", "01 " . $monthYear);
    return $result->format("M, Y");
}

function getFlightsDepArrFullType($flight, $handlingStations = null, $returnWithStation = null)
{
    if (!$handlingStations) {
        $handlingStations = \App\Models\Airport::getHandlingStationsIdAndObject();
    }

    $flightNumber = $flight->flightNumber;
    $station = null;

    $depAirportID = getFlightDepartureAirport($flight, true);
    $arrAirportID = getFlightArrivalAirport($flight, true);

    if (array_key_exists($depAirportID, $handlingStations) &&
        array_key_exists($arrAirportID, $handlingStations) )
    {
        $station = $handlingStations[$depAirportID];

        $type = FULL;
    }
    else
    {
        if (array_key_exists($depAirportID, $handlingStations)) {

            $station = $handlingStations[$depAirportID];

            $type = DEPARTURE;
        }
        elseif (array_key_exists($arrAirportID, $handlingStations)) {

            $station = $handlingStations[$arrAirportID];

            $type = ARRIVAL;
        }
        else {
            $type = intval($flightNumber->flight_number) % 2 == 0 ? ARRIVAL : DEPARTURE;
        }
    }

    return $returnWithStation ? [$type, $station] : $type;
}

function getFlightsDepArrType($flight, $handlingStations = null, $returnWithStation = null)
{
    if (!$handlingStations) {
        $handlingStations = \App\Models\Airport::getHandlingStationsIdAndObject();
    }

    $flightNumber = $flight->flightNumber;
    $station = null;

    $depAirportID = getFlightDepartureAirport($flight, true);
    $arrAirportID = getFlightArrivalAirport($flight, true);

    if (array_key_exists($depAirportID, $handlingStations)) {
        $station = $handlingStations[$depAirportID];

        $type = DEPARTURE;
    }
    elseif (array_key_exists($arrAirportID, $handlingStations)) {

        $station = $handlingStations[$arrAirportID];

        $type = ARRIVAL;
    }
    else {
        debug("FLT ID: ".$flight->id. "FN: ".$flightNumber->flight_number);
        $type = intval($flightNumber->flight_number) % 2 == 0 ? ARRIVAL : DEPARTURE;
    }

    return $returnWithStation ? [$type, $station] : $type;
}


function getFlightCapacity($flight, $total = false)
{
    if (!$flight){

        if ($total) {
            return null;
        }

        return [ null, null, null, null ];
    }

    $capacityC = $flight->capacity_c;
    $capacityY = $flight->capacity_y;

    if (!$capacityC && !$capacityY) {
        if ($flight->aircraft) {
            $capacityC = $flight->aircraft->config_c;
            $capacityY = $flight->aircraft->config_y;

            if (!$capacityC && !$capacityY && $flight->aircraft->type) {
                $capacityC = $flight->aircraft->type->config_c;
                $capacityY = $flight->aircraft->type->config_y;
            }
        }

        if (!$capacityC && !$capacityY) {
            if ($flight->aircraftType) {
                $capacityC = $flight->aircraftType->config_c;
                $capacityY = $flight->aircraftType->config_y;
            }
        }
    }


    if ($total){
        return ($capacityC ? $capacityC : 0) + ($capacityY ? $capacityY : 0);
    }

    return [
        $capacityC ? $capacityC : 0,
        $capacityY ? $capacityY : 0,
    ];
}

function getFlightPaxTotal($flight, $bookedForFuture = null)
{
    if (!$flight){
        return null;
    }

    $paxTotal = ($flight->pax_a_actual ? $flight->pax_a_actual : 0) +
        ($flight->pax_c_actual ? $flight->pax_c_actual : 0) +
        ($flight->pax_y_actual ? $flight->pax_y_actual : 0);

    if (!$paxTotal) {
        $paxTotal = $flight->pax_mvt_total;
    }

    if (!$paxTotal) {
        if ($flight->pax_adults_actual) {
            $paxTotal = $flight->pax_adults_actual;
        } else {
            $paxTotal = ($flight->pax_m_actual ? $flight->pax_m_actual : 0) +
                ($flight->pax_f_actual ? $flight->pax_f_actual : 0);
        }

        $paxTotal += ($flight->pax_ch_actual ? $flight->pax_ch_actual : 0);
    }

    if (!$paxTotal) {
        $paxTotal = ($flight->pax_a_booked ? $flight->pax_a_booked : 0) +
            ($flight->pax_c_booked ? $flight->pax_c_booked : 0) +
            ($flight->pax_y_booked ? $flight->pax_y_booked : 0);

        // Show booked only when flight is in future
        if ($bookedForFuture){
            return strtotime(date("Y-m-d H:i:s")) < getFlightDepartureDate($flight) ? $paxTotal : 0;
        }
    }

    return $paxTotal;
}

function getFlightPax($flight)
{
    if (!$flight){
        return [
            null, null,
        ];
    }

    $pax_c = $flight->pax_c_actual;
    $pax_y = $flight->pax_y_actual;

    if (!$pax_y) {
        $pax_c = $flight->pax_c_booked;
        $pax_y = $flight->pax_y_booked;
    }

    return [
        $pax_c ? $pax_c : 0,
        $pax_y ? $pax_y : 0,
    ];
}

function getFlightBookedPax($flight)
{
    if (!$flight){
        return [
            null, null,
        ];
    }

    $pax_c = $flight->pax_c_booked;
    $pax_y = $flight->pax_y_booked;

    return [
        $pax_c ? $pax_c : 0,
        $pax_y ? $pax_y : 0,
    ];
}

function getFlightBookedPaxWithInf($flight)
{
    if (!$flight){
        return [
            null, null, null,
        ];
    }

    $pax_c = $flight->pax_c_booked;
    $pax_y = $flight->pax_y_booked;
    $pax_inf = $flight->pax_inf_booked;

    return [
        $pax_c   ? $pax_c   : "",
        $pax_y   ? $pax_y   : "",
        $pax_inf ? $pax_inf : "",
    ];
}

function getFlightLoadFactor($flight){
    $act = getFlightActualPaxTotal($flight);
    $capacity = getFlightCapacity($flight, true);

    return $capacity ? round(100 * $act / $capacity) : 0;
}

function getFlightActualPaxTotal($flight)
{
    if (!$flight){
        return null;
    }

    $pax_c = $flight->pax_c_actual;
    $pax_y = $flight->pax_y_actual;

    return ($pax_c ? $pax_c : 0) + ($pax_y ? $pax_y : 0);
}

function getFlightActualPax($flight, $bookedPaxIfNull = false)
{
    if (!$flight){
        return [
            null, null,
        ];
    }

    if ($bookedPaxIfNull && !$flight->pax_c_actual && !$flight->pax_y_actual){
        return getFlightBookedPax($flight);
    }

    $pax_c = $flight->pax_c_actual;
    $pax_y = $flight->pax_y_actual;

    return [
        $pax_c ? $pax_c : 0,
        $pax_y ? $pax_y : 0,
    ];
}

function staffFlightIsInactive($flight){
    if (!$flight || $flight->deleted_at){
        return true;
    }

    return $flight->cancelled_at && !$flight->sod_completed;
}

function staffFlightIsInactiveByID($flightID){
    if (!$flightID){
        return true;
    }

    return staffFlightIsInactive(\App\Models\Flight::find($flightID));
}

function getFlightActualPaxWithInf($flight, $bookedPaxIfNull = false)
{
    if (!$flight){
        return [
            null, null, null
        ];
    }

    if ($bookedPaxIfNull && !$flight->pax_c_actual && !$flight->pax_y_actual){
        return getFlightBookedPaxWithInf($flight);
    }

    $pax_c = $flight->pax_c_actual;
    $pax_y = $flight->pax_y_actual;
    $pax_inf = $flight->pax_inf_actual;

    return [
        $pax_c      ? $pax_c    : "",
        $pax_y      ? $pax_y    : "",
        $pax_inf    ? $pax_inf  : "",
    ];
}

function getSector($flightNumber)
{
    if (!$flightNumber) {
        return "";
    }

    $sector = "";
    if ($flightNumber->departureAirport) {
        $sector .= $flightNumber->departureAirport->iata;
    }
    $sector .= "-";

    if ($flightNumber->arrivalAirport) {
        $sector .= $flightNumber->arrivalAirport->iata;
    }

    return $sector;
}

/**
 * @param $flightNumber
 * @param string $delimiter
 * @param bool $withAirlineCode
 * @param string $type
 * @return string
 */
function getFlightNumberFull($flightNumber, $delimiter = "-", $withAirlineCode = true, $type = IATA)
{
    $aType = $type == IATA ? ICAO : IATA;

    $airline = $withAirlineCode ? (($flightNumber && $flightNumber->airline ?
            ($flightNumber->airline->{$type} ? $flightNumber->airline->{$type} : $flightNumber->airline->{$aType}) : "")
        . $delimiter) : "";

    return $airline . ($flightNumber ? $flightNumber->flight_number : "");
}

function getSeatFactors($pax, $capacity)
{
    $result = $capacity ? 100 * round($pax / $capacity, 2) : 0;

    return $result > 100 ? 100 : $result;
}

function getFlightAirlineID($flight)
{
    if (!$flight || !$flight->flightNumber || !$flight->flightNumber->airline){
        return null;
    }

    return $flight->flightNumber->airline->id;
}
function getFlightNumberAirline($flightNumber)
{
    return $flightNumber && $flightNumber->airline ? $flightNumber->airline->airline : "";
}

function getUldContainerClass($position, $compartment = null, $cmp5has1container = null)
{
    switch ($position) {
        case LEFT:
            return "uld-container uld-container-left";

        case RIGHT:
            return "uld-container uld-container-right";

        case PALLET:
            return "uld-container-2columns uld-container-pallet";

        case null:
        default:
            break;
    }
    if ($compartment && $compartment == 5) {
        return $cmp5has1container ? "uld-container-bulk-2columns uld-container-both" : "uld-container-bulk-column uld-container-both";
    } else {
        return "uld-container-column uld-container-both";
    }
}

function getUldContainerBgColor($loadedType)
{

    if ($loadedType == "N" || starts_with($loadedType, "N")) {
        return "#ABABAB";
    }

    $types = [
        "B", "C", "E", "M", "T", "COU",
    ];

    $matches = 0;
    foreach ($types as $type) {
        if (contains($loadedType, $type)) {
            $matches++;
        }
    }

    if ((contains($loadedType, "EIC") && substr_count($loadedType, "C") == 1) ||
        (contains($loadedType, "COU") && substr_count($loadedType, "C") == 1)
    ) {
        $matches--;
    }

    if ($matches > 1) {
        return "#f8d2ff";
    }

    if (contains($loadedType, "COU")) {
        return "#b9fdff";
    }

    if (contains($loadedType, "E")) {
        return "#ffd5c2";
    }

    if (contains($loadedType, "B")) {
        return "#adffba";
    }
    if (contains($loadedType, "C")) {
        return "#a8cdff";
    }

    if (contains($loadedType, "M")) {
        return "#f8ffdc";
    }
    if (contains($loadedType, "T")) {
        return "#e6ffd5";
    }


//    .mixed { background-color: #f4caff;}

//    .baggage { background-color: #adffba;}
//    .cargo { background-color: #a8cdff;}
//    .eic { background-color: #ffd5c2;}
//    .mail { background-color: #f8ffdc;}

    return "#E3E3E3";

    switch ($vr) {
        case 3: // 75%
            return "#00b30a";

        case 2: // 50%
            return "#9dffac";

        case 1: // 25%
            return "#ff96a7";

        default:
            break;

    }

    if ($vr === 0) { // 0%
        return "#ff5568";
    }

    return "#ffffff";
}


function getFormPeriod()
{
    $dateSearch = null;
    $dateYesterday = date('Y-m-d', strtotime(" - 1 days"));
    switch (\request()->get('dateSearch')) {
        case 'monthYear':
            $dateSearch = [
                'month' => \request()->get('month')  ? \request()->get('month')   : date('m'),
                'year'  => \request()->get('year')   ? \request()->get('year')    : date('Y'),
            ];

            if (\request()->get("bi_month")){
                $dateSearch["bi_month"] = \request()->get("bi_month");
            }

            debug($dateSearch);

            break;

        case 'all':
            break;

        case 'fromTo':
            $dateSearch = [
                'from'  => \request()->get('dateFrom')   ? \request()->get('dateFrom')    : $dateYesterday,
                'to'    => \request()->get('dateTo')     ? \request()->get('dateTo')      : $dateYesterday
            ];
            break;

        default:
            $dateSearch = [
                'from'  => \request()->get('date') ? \request()->get('date') : $dateYesterday,
                'to'    => \request()->get('date') ? \request()->get('date') : $dateYesterday
            ];
            break;
    }

    return $dateSearch;
}

function getMinFCM($flight)
{
    $minFCM = 2;
    if ($flight->aircraft) {
        $minFCM = $flight->aircraft->min_fcm ? $flight->aircraft->min_fcm : 2;
    } else if ($flight->aircraftType) {
        $minFCM = $flight->aircraftType->min_fcm ? $flight->aircraftType->min_fcm : 2;
    }

    return $minFCM;
}

function getMinCCM($flight)
{

    $minCCM = 2;
    if ($flight->aircraft) {
        $minCCM = $flight->aircraft->min_ccm ? $flight->aircraft->min_ccm : 2;
    } else if ($flight->aircraftType) {
        $minCCM = $flight->aircraftType->min_ccm ? $flight->aircraftType->min_ccm : 2;
    }

    return $minCCM;
}

function debugFlights($flights, $j = null, $title = null)
{
    if ($title) {
        debug($title);
    }

//    foreach ($flights as $i => $each) {
//        debug(($j ? $j . "_" : "") . $i . ") STD: " . baseTimeFormat($each->std) . " STA: " . baseTimeFormat($each->sta)
//            . " | " . $each->flightNumber->flight_number
//            . " " . $each->flightNumber->departureAirport->iata . "-" . $each->flightNumber->arrivalAirport->iata);
//    }
}

function getAirlineCode($airline)
{
    if (!$airline) {
        return "";
    }

    return $airline->iata ? $airline->iata : $airline->icao;
}

function getMonthDays($date)
{
    $month = date("m", strtotime($date));
    $year = date("Y", strtotime($date));
    return cal_days_in_month(CAL_GREGORIAN, $month, $year);
}

function validateMVTDate($date, $delimiter = '-')
{
    $str = explode($delimiter, $date);

    if (count($str) < 3) {
        return false;
    }

    $year = $str[0];
    $month = $str[1];
    $day = $str[2];

    if ($month > 13 || $month < 0 || $day < 0 || $day > 31 || $year < 0) {
        return false;
    }

    $format = "Y{$delimiter}m{$delimiter}d";
    $loop = 0;
    do {
        $loop++;
        $newDate = "$year{$delimiter}" . (strlen($month) < 2 ? "0{$month}" : $month) . "{$delimiter}$day";
        $d = DateTime::createFromFormat($format, $newDate);
        if ((int)$month == 1) {
            $year--;
            $month = 12;
        } else {
            $month--;
        }

        if ($loop >= 12) {
            debug("LOOP Exceeded : OLD DATE : {$date} NEW DATE: {$newDate}");
            break;
        }
        //debug($newDate. " !! ".($d ? $d->format($format) : "ERROR FORMAT"));
    } while (!($d && $d->format($format) == $newDate));

    return $d->format($format);
}

function makeDateTime($str, $date = null)
{

    if (strlen($str) == 6) {
        list($day, $hours, $minutes) = str_split($str, 2);
        if ($date) {
            return date("Y-m", strtotime($date)) . "-{$day} {$hours}:{$minutes}:00";
        } else {
            return date("Y-m" . "-{$day} {$hours}:{$minutes}:00");
        }
    } else if (strlen($str) == 4) {
        list($hours, $minutes) = str_split($str, 2);
        if ($date) {
            return date("Y-m-d H:i", strtotime("{$date} {$hours}:{$minutes}:00"));
        } else {
            return date("Y-m-d " . "{$hours}:{$minutes}:00");
        }
    }
//        $this->error("Cannot get date string from string - $str and departure day - $date");
    return "";
    //return date("Y-m-d H:i", strtotime($date." ".$HHmm));
}

function makeTime($str)
{

    if (strlen($str) == 4) {
        list($hours, $minutes) = str_split($str, 2);

        return date("H:i:s", strtotime("{$hours}:{$minutes}:00"));
    }

//        $this->error("Cannot get time string from string - $str");

    return null;
    //return date("Y-m-d H:i", strtotime($date." ".$HHmm));
}

function createCrew($crew, $user, $position)
{
    if (!$crew || !$user) {
        return null;
    }

    $crewMember = null;

    switch ($crew) {
        case FCM_CREW:
        case FCM_CREW_LONG:
            if (!checkIfCrewExists($crew, $user)) {
                $crewMember = \App\Models\CaptainFirstOfficer::where("user_id", $user->id)
                    ->first();

                if (!$crewMember) {
                    $crewMember = new \App\Models\CaptainFirstOfficer();
                    $crewMember->user_id = $user->id;
                }

                $crewMember->is_captain = $position && $position->type == FCM_CPT_TYPE_ID;

                $crewMember->save();
            }
            break;

        case CCM_CREW:
        case CCM_CREW_LONG:
            if (!checkIfCrewExists($crew, $user)) {
                $crewMember = \App\Models\CabinCrew::where("user_id", $user->id)
                    ->first();

                if (!$crewMember) {
                    $crewMember = new \App\Models\CabinCrew();
                    $crewMember->user_id = $user->id;
                }

                $crewMember->is_purser = $position && $position->type == CCM_PSR_TYPE_ID;

                $crewMember->save();
            }
            break;

        default:
            break;
    }

    return;
}

function checkIfCrewExists($crew, $user)
{
    $search = null;

    switch ($crew) {
        case FCM_CREW:
        case FCM_CREW_LONG:
            $search = \App\Models\CaptainFirstOfficer::where("user_id", $user->id)
                ->first();
            break;

        case CCM_CREW:
        case CCM_CREW_LONG:
            $search = \App\Models\CabinCrew::where("user_id", $user->id)
                ->first();
            break;

        default:
            break;
    }

    return $search != null;
}


function dateConvertToTimezone($date, $fromTZ, $dateFormat, $toTZ, $toDateFormat)
{
    $res = '';
    if (!in_array($fromTZ, timezone_identifiers_list())) { // check source timezone
        trigger_error(__FUNCTION__ . ': Invalid source timezone ' . $fromTZ, E_USER_ERROR);
    } elseif (!in_array($toTZ, timezone_identifiers_list())) { // check destination timezone
        trigger_error(__FUNCTION__ . ': Invalid destination timezone ' . $toTZ, E_USER_ERROR);
    } else {
        // create DateTime object
        $d = DateTime::createFromFormat($dateFormat, $date, new DateTimeZone($fromTZ));
        // check source datetime
        if ($d && DateTime::getLastErrors()["warning_count"] == 0 && DateTime::getLastErrors()["error_count"] == 0) {
            // convert timezone
            $d->setTimeZone(new DateTimeZone($toTZ));
            // convert dateformat
            $res = $d->format($toDateFormat);
        } else {
            trigger_error(__FUNCTION__ . ': Invalid source datetime ' . $date . ', ' . $dateFormat, E_USER_ERROR);
        }
    }
    return $res;
}

function getLocalDateTime($datetime, $toTimezone, $format = 'Y-m-d H:i:s', $fromTimezone = "UTC")
{
    $date = new \DateTime($datetime, new \DateTimeZone($fromTimezone));
//    debug($fromTimezone . " : " . $date->format($format));

    $date->setTimezone(new DateTimeZone($toTimezone));
//    debug($toTimezone . " : " . $date->format($format));

    return $date->format($format);
}

function wordIsInEnglish($string)
{
    // string contains only english letters & digits
    return !preg_match('/[^A-Za-z0-9]/', $string);
}

//Object oriented style
function getUTCOffset($timezone)
{
    debug($timezone);
    if (!$timezone){
        $timezone = "UTC";
    }
    $current   = timezone_open($timezone);
    $utcTime  = new \DateTime('now', new \DateTimeZone('UTC'));
    $offsetInSecs =  $current->getOffset($utcTime);
    $hoursAndSec = gmdate('H:i', abs($offsetInSecs));
    return stripos($offsetInSecs, '-') === false ? "+{$hoursAndSec}" : "-{$hoursAndSec}";
}

function userAnyAdmin()
{
    return Auth::user() && Auth::user()->role && in_array(Auth::user()->role->role, [DEPARTMENT_ADMIN, ADMIN, SUPER_ADMIN]) ? 1 : 0;
}

function userDepartmentAdmin()
{
    return Auth::user() && Auth::user()->role && Auth::user()->role->role == DEPARTMENT_ADMIN;
}

function userAdmin()
{
    return Auth::user() && Auth::user()->role && Auth::user()->role->role == ADMIN;
}

function userSuperAdmin()
{
    return Auth::user() && Auth::user()->role && Auth::user()->role->role == SUPER_ADMIN;
}

function airlineID(){
    if (airlineModule()){
        return env(AIRLINE_ID);
    }

    return null;
}

function airlineModule()
{
    return env(CARRIER) == AIRLINE;
}

function ghaModule()
{
    return env(CARRIER) == HANDLING;
}

function getUserName($user)
{
    if (!$user) {
        return "";
    }

    return $user->first_name . " " . $user->last_name;
}

function getUserFullName($userID)
{
    if (!$userID) {
        return "";
    }

    $user = \App\Models\User::find($userID);

    if (!$user) {
        return "";
    }

    return $user->first_name . " " . $user->last_name;
}

function prepareMVTDepartureText($flight, $type, $si, $cor = null)
{
    if ($type == "ed") {
        return prepareMVTDepartureEDNotificationText($flight, $si);
//        return prepareMVTDepartureEDText($flight, $si);
    }

    return prepareMVTDepartureADText($flight, $si, $cor);
}

function prepareMVTDepartureADText($flight, $si = null, $cor = null)
{
    $fn = getFlightNumber($flight, "");
    $day = date("d", strtotime(getFlightDepartureInitialDate($flight)));
    $ac = getFlightAircraft($flight, false, true);
    $depAP = getFlightDepartureAirport($flight, false, true);

    $atd = convertToMVTDateFormat(getFlightDepartureDate($flight));
    $abn = $flight->abn && $flight->abn != EMPTY_DATETIME ? convertToMVTDateFormat($flight->abn) : null;
    $eta = convertToMVTDateFormat(getFlightArrivalDate($flight));
    $arrAP = getFlightArrivalAirport($flight, false, true);

    $pax = "";
    if ($flight->pax_y_actual) {

        if ($flight->pax_a_actual) {
            $pax .= $flight->pax_a_actual . "/";
        }
        if ($flight->pax_c_actual) {
            $pax .= $flight->pax_c_actual . "/";
        }

        $pax .= $flight->pax_y_actual;

        if ($flight->pax_inf_actual) {
            $pax .= "+" . $flight->pax_inf_actual;
        }

    } else if ($flight->pax_mvt_total) {

        $pax .= $flight->pax_mvt_total;

        if ($flight->pax_mvt_inf) {
            $pax .= "+" . $flight->pax_mvt_inf;
        } else if ($flight->pax_inf_actual) {
            $pax .= "+" . $flight->pax_inf_actual;
        }
    }

    $title = "MVT";

    // IF DIVERSION
    if ($flight->is_diversion && $flight->arrival_airport_id && $flight->diverted_airport_id){
        $title = "DIV";
    }
    else {
        if ($cor){
            $title = "COR\n".
                "MVT";
        }
    }

    $subject = "{$title} {$fn}/{$day}";

    $content = "{$title}\n"
        . "{$fn}/{$day}.{$ac}.{$depAP}\n"
        . "AD{$atd}" . ($abn ? "/{$abn}" : "") . " EA{$eta} {$arrAP}\n";

    // Delays
    if ($flight->delays) {
        // IATA format Delays not being used
        // $delays = $delayTimes = "";
        foreach ($flight->delays as $i => $each) {
            $duration = $each->duration ? date("Hi", strtotime($each->duration)) : "0001";
            $description = $each->delay->description ? trim($each->delay->description) : null;
            $descriptionLn = $each->delay->description_ln ? trim($each->delay->description_ln) : null;
            $descriptionShow = $descriptionLn ? $descriptionLn : $description;

            $content .= "DL{$each->delay->code}/{$duration}" . ($descriptionShow ? "/{$descriptionShow}" : "") . "\n";

            //  $delays .= ($i > 0 ? "/" : "").$each->delay->code;
            //  $delayTimes .= ($i > 0 ? "/" : "").$duration;
        }

        //  if ($delays || $delayTimes){
        //      $content .= "DL". ($delays ? $delays."/" : "").$delayTimes."\n";
        //  }
    }

    // PAX
    if ($pax) {
        $content .= "PX{$pax}" . "\n";
    }

    if ($flight->baggage || $flight->cargo || $flight->mail || $flight->eic) {
        if ($flight->baggage) {
            $content .= "B/{$flight->baggage} ";
        }
        if ($flight->cargo) {
            $content .= "C/{$flight->cargo} ";
        }
        if ($flight->mail) {
            $content .= "M/{$flight->mail} ";
        }
        if ($flight->eic) {
            $content .= "E/{$flight->eic} ";
        }
        $content .= "\n";
    }

    $fob = $flight->fob ? $flight->fob : ($flight->in_tanks + $flight->uplifted);
    if ($fob) {
        $content .= "FOB/" . $fob . "\n";
    }

    if ($flight->pic) {
        $content .= "SI-PIC/" . $flight->pic . "\n";
    }

    if ($si) {
        $content .= "SI/" . $si . "\n";
    }

    return [
        $subject,
        $content
    ];
}

function prepareMVTDepartureEDText($flight, $si = null)
{
    $fn = getFlightNumber($flight, "");
    $day = date("d", strtotime(getFlightDepartureInitialDate($flight)));
    $ac = getFlightAircraft($flight, false, true);
    $depAP = getFlightDepartureAirport($flight, false, true);

    $etd = convertToMVTDateFormat(getFlightDepartureDate($flight));
    $eta = convertToMVTDateFormat(getFlightArrivalDate($flight));
    $arrAP = getFlightArrivalAirport($flight, false, true);

    $subject = "MVT {$fn}/{$day}";

    $content = "MVT\n"
        . "{$fn}/{$day}.{$ac}.{$depAP}\n"
        . "ED{$etd} {$arrAP}\n";

    // Delays
    if ($flight->delays) {
        // IATA format Delays not being used
        // $delays = $delayTimes = "";
        foreach ($flight->delays as $i => $each) {
            $duration = $each->duration ? date("Hi", strtotime($each->duration)) : "0001";
            $description = $each->delay->description ? trim($each->delay->description) : null;
            $descriptionLn = $each->delay->description_ln ? trim($each->delay->description_ln) : null;
            $descriptionShow = $descriptionLn ? $descriptionLn : $description;

            $content .= "DL{$each->delay->code}/{$duration}" . ($descriptionShow ? "/{$descriptionShow}" : "") . "\n";

            //  $delays .= ($i > 0 ? "/" : "").$each->delay->code;
            //  $delayTimes .= ($i > 0 ? "/" : "").$duration;
        }

        //  if ($delays || $delayTimes){
        //      $content .= "DL". ($delays ? $delays."/" : "").$delayTimes."\n";
        //  }
    }

    if ($si) {
        $content .= "SI/" . $si . "\n";
    }

    return [
        $subject,
        $content
    ];
}

function prepareMVTDepartureEDNotificationText($flight, $si = null)
{
    /*
     *  Delay Notification:
        Flight: 9U864 (FRA-KIV)
        STD: 25 Sep 17 07:30
        ATD: 25 Sep 17 07:34
        Delay Code: 9U 09 |
        Delay Time: 00:04
        --------------------------
        Other Delays:
        --------------------------
        Total Delay Time: 00:04
     *
     */

    $fn = getFlightNumber($flight, "");
    $day = date("d", strtotime(getFlightDepartureInitialDate($flight)));
    $ac = getFlightAircraft($flight, false, true);

    $depAP = getFlightDepartureAirport($flight, false, true);
    $arrAP = getFlightArrivalAirport($flight, false, true);

    $etd = getFlightDepartureDate($flight);

    $subject = "Delay Notification {$fn}/{$day}";

    $content = "Delay Notification:\n"
        . "\nFlight: {$fn} ({$depAP}-{$arrAP})"
        . "\nSTD: " . ($flight->std && $flight->std != EMPTY_DATETIME ? baseDateFormat($flight->std, true) : "N/A")
        . "\n" . strtoupper(getFlightDepartureTimeType($flight)) . ": " . baseDateFormat($etd, true);


    // Delays
    if ($flight->delays) {
        // IATA format Delays not being used
        // $delays = $delayTimes = "";
        foreach ($flight->delays as $i => $each) {
            $duration = $each->duration ? date("Hi", strtotime($each->duration)) : "0001";
            $description = $each->delay->description ? trim($each->delay->description) : null;
            $descriptionLn = $each->delay->description_ln ? trim($each->delay->description_ln) : null;
            $descriptionShow = $descriptionLn ? $descriptionLn : $description;

            $content .= "\nDL{$each->delay->code}/{$duration}" . ($descriptionShow ? "/{$descriptionShow}" : "");
            //  $delays .= ($i > 0 ? "/" : "").$each->delay->code;
            //  $delayTimes .= ($i > 0 ? "/" : "").$duration;
        }

        //  if ($delays || $delayTimes){
        //      $content .= "DL". ($delays ? $delays."/" : "").$delayTimes."\n";
        //  }
    }

    $totalDelay = Calculate_Duration($flight->std, $etd, true);

    $content .= "\n--------------------------" .
        "\nTotal Delay Time: " . ($totalDelay ? hoursToTime($totalDelay, true) : "N/A");

    if ($si) {
        $content .= "\n\nSI:" . $si . "\n";
    }

    return [
        $subject,
        $content
    ];
}

function prepareMVTArrivalText($flight, $data = null, $cor = null)
{

    $fn = getFlightNumber($flight, "");
    $day = date("d", strtotime(getFlightDepartureInitialDate($flight)));
    $ac = getFlightAircraft($flight, false, true);
    $arrAP = getFlightArrivalAirport($flight, false, true);

    $ata = $data["ata"]; // convertToMVTDateFormat(getFlightArrivalDate($flight));
    $tdn = $data["tdn"]; // $flight->tdn && $flight->tdn != EMPTY_DATETIME ? convertToMVTDateFormat($flight->tdn) : null;

    $subject = "MVT {$fn}/{$day}";


    $content = "";

    if ($cor){
        $content = "COR\n";
    }

    $content .= "MVT\n"
        ."{$fn}/{$day}.{$ac}.{$arrAP}\n"
        . "AA" . ($tdn ? "{$tdn}/" : "") . $ata . "\n";

    if ($flight->rf) {
        $content .= "RF/" . $flight->rf . "\n";
    }

    if ($flight->pic_arr) {
        $content .= "SI-PIC/" . $flight->pic_arr . "\n";
    }

    if ($data && isset($data['si'])) {
        $content .= "SI/" . $data['si'] . "\n";
    }

    return [
        $subject,
        $content
    ];
}

function getFwTableAC($aircraft, $aircraftType, $withoutSpan = false){
    $result = "";
    if ($withoutSpan){
        if ($aircraft) {
            $result = $aircraft->name;
            if ($aircraftType) {
                $result .= ' ('.$aircraftType->icao.')';
            }
        }
        elseif ($aircraftType) {
            $result = $aircraftType->icao;
        }
    }
    else {
        if ($aircraft) {
            $result = '<span class="color-red">'.$aircraft->name.'</span>';
            if ($aircraftType) {
                $result .= '<span class="color-green"> ('.$aircraftType->icao.')</span>';
            }
        }
        elseif ($aircraftType) {
            $result = '<span class="color-green">'.$aircraftType->icao.'</span>';
        }
    }

    return $result;
}

function getACorTypeFromFlight($flight, $acTypeField = "iata_name")
{
    $ac = $flight->aircraft ? ($flight->aircraft->name ? $flight->aircraft->name : $flight->aircraft->mvt_name) : null;

    $acType = $flight->aircraft ? ($flight->aircraft->type ? $flight->aircraft->type->{$acTypeField} : "")
        : ($flight->aircraftType ? $flight->aircraftType->{$acTypeField} : "");

    if ($ac){
        return "<span class='color-red'>{$ac}</span>" .($acType ? "<span class='color-green'>({$acType})</span>" : "");
    }

    return "<span class='color-green'>{$acType}</span>";
}

function getACorTypeFromAC($aircraft, $acTypeField = "iata_name")
{
    return ($aircraft ? ($aircraft->name ? $aircraft->name : $aircraft->mvt_name)
        : ($aircraft->type ? $aircraft->type->{$acTypeField} : "-"));
}

function getAgencyCode($agencyCode)
{
    if (!$agencyCode) {
        return "";
    }

    return $agencyCode->code ? $agencyCode->code : $agencyCode->tch_code;
}

function hasEmployeesInLine($user){
    /*
    $reportee = \App\Models\User::where("email", "l.struckmeier@gsrm.de")
                                ->orWhere(function($sql) use ($userID) {
                                    $sql->where("reports_to_user_id", $userID)
                                        ->whereNull("deleted_at")
                                        ->whereNull("resigned_date");
                                    })
                                ->first();
    */

    $request = \App\Models\UserLeaveStatus::where("report_to_user_id", $user->id)
        ->first();

    $position = getUserPosition($user);

    return $request || ($position && $position->show_leave_requests) ;
}

function isSprAdm(){
    return Auth::user()->user_role_id == 4;
}

function mergeOperatorAirlineList($currentAirlineIDs, $val = "id", $key = null){
    if ($val && $key){
        $operatorsArr = Airline::where("operator", 1)
            ->pluck($val, $key)
            ->all();

        foreach ($operatorsArr as $i => $item) {
            $currentAirlineIDs[$i] = $item;
        }

        return $currentAirlineIDs;
    }
    else {
        $operatorsArr = Airline::where("operator", 1)
            ->pluck("{$val}")
            ->all();

        return array_merge($currentAirlineIDs, $operatorsArr);
    }
}

function displayService($serviceType){
    switch ($serviceType){
        case ARRIVAL_SERVICE:
            return ARRIVAL;

        case DEPARTURE_SERVICE:
            return DEPARTURE;

        case TURNAROUND_SERVICE:
            return TURNAROUND;

        default:
            return null;
    }
}

function displayServiceWithLabel($serviceType){
    switch ($serviceType){
        case ARRIVAL_SERVICE:
            return "<span class='label label-success font-sm'>".ARRIVAL."</span>";

        case DEPARTURE_SERVICE:
            return "<span class='label label-primary font-sm'>".DEPARTURE."</span>";

        case TURNAROUND_SERVICE:
            return "<span class='label label-warning font-sm'>".TURNAROUND."</span>";

        default:
            return null;
    }
}

function getStaffHandlingAirports()
{
    $handlingAirlines = $handlingAirports = [];

    if (ghaModule()) {
        $handlingAirlines = \App\Models\StaffAirline::currentStaffAirlinesList(NAME);
        $handlingAirports = \App\Models\StaffStation::currentStaffStationsList(IATA);

        if (!count($handlingAirlines)) {
            $handlingAirlines = \App\Models\Airline::listHandlingAirlines();
        }

        if (!count($handlingAirports)) {
            $handlingAirports = \App\Models\Airport::listHandlingStations();
        }
    } else {
        $handlingAirports = \App\Models\StaffStation::currentStaffStationsList(IATA);

        if (!count($handlingAirports)) {
            $handlingAirports = \App\Models\Airport::listOperatedStations();
        }
    }

    return [$handlingAirlines, $handlingAirports];
}

function getReportTypeName($num)
{
    $reportType = \App\Models\ReportType::find($num);

    if (!$reportType) {
        return "";
    }

    return $reportType->type;
}


function getBaggageInfo($pcs, $wt)
{
    return ($pcs ? $pcs . "/" : "") . $wt;
}

function getPassengerLink($passengerID, $newTab = true){

    $airline = env(AIRLINE);

    switch($airline){
        case QAZAQ_AIR:
        case TAJIK_AIR:

            //DEMO
        case COASTAL:
        case KAPKG:
        case AIRLINE:
        case CAA:
            return $newTab ? route("homepage")."#passenger/{$passengerID}" : "passenger/{$passengerID}";

        case SCO:
        case AVIAM:
        default:
            return "#";
    }


}

function passengerRecordPermitted(){

    $airline = env(AIRLINE);

    switch($airline){
        case QAZAQ_AIR:
        case TAJIK_AIR:
            // DEMO
        case AIRLINE:
        case COASTAL:
        case KAPKG:
        case CAA:
            return true;

        case SCO:
        case AVIAM:
        default:
            return false;
    }
}


function groupByReportType($group_period, $column){
    switch($group_period) {
        case REPORT_TYPE_YEARLY:
            $select  = "YEAR($column)";
            break;
        case REPORT_TYPE_QUARTERLY:
            $select  = "CONCAT(QUARTER($column),', ', YEAR($column))";
            break;
        case REPORT_TYPE_MONTHLY:
            $select  = "DATE_FORMAT($column, '%m, %Y')";
            break;
        case REPORT_TYPE_WEEKLY:
            $select  = "DATE_FORMAT($column, '%V, %X')";
            break;
        case REPORT_TYPE_WEEKDAYS:
            $select  = "WEEKDAY($column)";
            break;
        case REPORT_TYPE_DAILY:
            $select = $column;
            break;
        case REPORT_TYPE_SECTOR:
            $select  = "CONCAT(s_depAirport.iata, '-', s_arrAirport.iata)";
            break;
        case REPORT_TYPE_FLIGHT_NUMBER:
            $select  = "flight_number";
            break;
        case REPORT_TYPE_FLIGHT:
            $select  = [
                "CONCAT(IF(std is NULL, departure_date, DATE(std)), ' | ', flight_number, ' | ', s_depAirport.iata, '-', s_arrAirport.iata)",
//                "CONCAT(DATE(std), ' | ', flight_number, ' | ', s_depAirport.iata, '-', s_arrAirport.iata)",
                "departure",
                "std",
                "atd",
//                "DATE(std) as std",
                "flight_number",
                "s_passengers__flights.flight_number_id",
                "CONCAT(s_depAirport.iata, '-', s_arrAirport.iata) AS sector",
                "flight_id",
            ];
            break;
        default:
            $select = $column;
            break;
    }
    return $select;
}

function aircraftWideBoard($aircraft = null, $aircraftType = null){

    if (!$aircraft){
        return false;
    }

    if ($aircraft->aisles && $aircraft->aisles > 1){
        return true;
    }

    if ($aircraft->type && $aircraft->type->wide_board){
        return true;
    }

    return $aircraftType && $aircraftType->wide_board;
}

function getAgencyCodeCity($agencyCode){
    if ($agencyCode->city){
        return $agencyCode->city->city;
    }

    if ($agencyCode->agency && $agencyCode->agency->city){
        return $agencyCode->agency->city->city;
    }

    return "";
}

function getAgencyCodeCountry($agencyCode){
    if ($agencyCode->country){
        return $agencyCode->country->country;
    }

    if ($agencyCode->agency && $agencyCode->agency->country){
        return $agencyCode->agency->country->country;
    }

    return "";
}


function getAirlineLogo($airlineObj, $md = null){
    if (airlineModule()){
        $airline = env(AIRLINE);
        switch($airline){
            case TAJIK_AIR:
                if ($md){
                    return asset("smart/img/tajikair_logo_md.png");
                }
                return asset("assets/img/logos/tajikair.png");

            case COASTAL:
                if ($md){
                    return asset("assets/img/logos/coastal-logo-mini.png");
                }
                return asset("assets/img/logos/coastal-logo.jpg");

            case KAPKG:
                return asset("assets/img/logos/kapkg.png");

            /*
                        case QAZAQ_AIR:
                            if ($md){
                                return asset("smart/img/qazaqair_200.png");
                            }
                            return asset("assets/img/logos/qazaqair.png");

                        case PEGASUS:
                            if ($md){
                                return asset("smart/img/pgs_200.jpg");
                            }
                            return asset("smart/img/pgs_300.jpg");

                        case AIR_KYRGYZSTAN:
                            if ($md){
                                return asset("smart/img/kyrgyz_200.jpg");
                            }
                            return asset("smart/img/kyrgyz_300.jpg");
            */
            default:
                return asset("assets/img/logos/avbis.jpg");

        }
    }

    return $airlineObj && $airlineObj->picture ? asset("storage/airlines/img/{$airlineObj->picture}") : asset("/assets/img/default-airline-picture.png");
}


function getAirlineOfficialWords($word)
{
    $airline = env(AIRLINE);
    $str = "Exclusively for ";

    switch ($word) {
        case OFFICIAL_AIRLINE_NAME:
            switch ($airline) {
                case TAJIK_AIR:
                    return $str.OFFICIAL_TAJIK_AIR_NAME;

                case GSRM:
                    return $str.OFFICIAL_GSRM_NAME;

                case AVIAM:
                    return $str.OFFICIAL_AVIAM_NAME;

                case DLM:
                    return $str.OFFICIAL_DLM_NAME;

                case COASTAL:
                case KAPKG:
                case DHS:
                    return "";

                default:
                    return "By";
            }
            break;

        case OFFICIAL_AIRLINE_NAME_SHORT:
            switch ($airline) {
                case TAJIK_AIR:
                    return $str.OFFICIAL_TAJIK_AIR_NAME_SHORT;

                case GSRM:
                    return $str.OFFICIAL_GSRM_NAME_SHORT;

                case DLM:
                    return $str.OFFICIAL_DLM_NAME_SHORT;

                case AVIAM:
                    return $str.OFFICIAL_AVIAM_NAME_SHORT;

                case COASTAL:
                case KAPKG:
                case DHS:
                    return "";

                default:
                    return "By";

            }
            break;

        case OFFICIAL_AILINE_OF_COUNTRY:
            switch ($airline) {
                case TAJIK_AIR:
                    return $str.OFFICIAL_TAJIK_AIR_OF_COUNTRY;

                case QAZAQ_AIR:
                    return $str.OFFICIAL_QAZAQ_AIR_OF_COUNTRY;

                case COASTAL:
                case KAPKG:
                    return "";

                default:
                    return "By";

            }
            break;

        case OFFICIAL_AIRLINE_COMPANY:
            switch ($airline) {
                case TAJIK_AIR:
                    return $str.OFFICIAL_TAJIK_AIR_COMPANY;

                case QAZAQ_AIR:
                    return $str.OFFICIAL_QAZAQ_AIR_COMPANY;

                case COASTAL:
                case KAPKG:
                    return "";

                default:
                    return "By";

            }
            break;
    }

    return "";
}

function getMonth($date, $lang = "ru" ) {
    $ru_months = array( 'январь', 'февраль', 'март', 'апрель', 'май', 'июнь', 'июль', 'август', 'сентябрь', 'октябрь', 'ноябрь', 'декабрь' );
    $en_months = array( 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December' );

    $month = date("n", strtotime($date)) - 1;

    switch($lang){
        case "en":
            return $en_months[$month];

        default:
        case "ru":
            return $ru_months[$month];

    }
}

function getFlightNumberStrings($flight){
    $fn1 = $fn2 = $fn3 = "";
    if ($flight->flightNumber){
        $fn = $flight->flightNumber->flight_number;
        if ($flight->flightNumber->airline){
            $airline = $flight->flightNumber->airline;
            $fn1 = $airline->airline." ";

            $fn2 = $airline->icao ? $airline->icao : ($airline->iata ? $airline->iata : "");
            $fn3 = $airline->iata ? $airline->iata : ($airline->icao ? $airline->icao : "");
        }

        $fn1 .= $fn;

        // if ($fn2){
        $fn2 .= $fn;
        //}

        //if ($fn3){
        $fn3 .= $fn;
        //}
    }

    return [$fn1, $fn2, $fn3];
}

function removePrevPictures(&$obj, $variable, $destinationPath, $saveObject = false){

    if ($obj->{$variable}){
        if (\Illuminate\Support\Facades\File::exists($destinationPath."/".$obj->{$variable})){
            \Illuminate\Support\Facades\File::delete($destinationPath."/".$obj->{$variable});
        }
    }

    $obj->{$variable} = null;

    if ($saveObject){
        $obj->save();
    }
}

function departureArrivalAirportsMatch($flight){
    $depAP = $flight->departure_airport_id ? $flight->departure_airport_id : $flight->flightNumber->departure_airport_id;
    $arrAP = $flight->arrival_airport_id ? $flight->arrival_airport_id : $flight->flightNumber->arrival_airport_id;

    return $depAP == $arrAP;
}

function getFlightNumbersHandlingStation($handlingStations, $flightNumber){
    if (array_key_exists($flightNumber->departure_airport_id, $handlingStations)){
        return $flightNumber->departure_airport_id;
    }
    elseif (array_key_exists($flightNumber->arrival_airport_id, $handlingStations)){
        return $flightNumber->arrival_airport_id;
    }
    return null;
}

function getFileObject($url)
{
    //get name file by url and save in object-file
    $path_parts = pathinfo($url);
    //get image info (mime, size in pixel, size in bits)
    $newPath = $path_parts['dirname'] . '/tmp-files/';
    if(!is_dir ($newPath)){
        mkdir($newPath, 0777);
    }
    $newUrl = $newPath . $path_parts['basename'];
    copy($url, $newUrl);
    $imgInfo = getimagesize($newUrl);
    $file = new \Illuminate\Http\UploadedFile(
        $newUrl,
        $path_parts['basename'],
        $imgInfo['mime'],
        filesize($url),
        TRUE
    );

    return $file;
}

function movePicture($image, $destinationPath, $imageName, $width = 512, $currentPath = null){

    // Save thumb
    $currentPath = $currentPath ? $currentPath : $image->getRealPath();

    \Intervention\Image\Facades\Image::make($currentPath)->resize($width, null, function ($constraint) {
        $constraint->aspectRatio();
    })->save($destinationPath . '/' . $imageName);
    return $imageName;


    $fileinfo = @getimagesize($image); //$_FILES["{$inputVar}"]["tmp_name"]);
    $origWidth = $fileinfo[0];
    $origHeight = $fileinfo[1];

    if ($origWidth <= $width) {
        // Save Original
//        $request->{$inputVar}->move($destinationPath, $imageName);
        // Save thumb
        \Intervention\Image\Facades\Image::make($currentPath)->save($destinationPath . '/' . $imageName);
    }
    else {
        // Save thumb
        \Intervention\Image\Facades\Image::make($currentPath)->resize($width, null, function ($constraint) {
            $constraint->aspectRatio();
        })->save($destinationPath . '/' . $imageName);
    }
}

function saveImage($file, $ext, &$obj, $folderName, $title, $replace = true){

    $fileName = str_limit(($title ? $title : $file->getClientOriginalName()), 32, "");

//    $ext = $fileImage->getClientOriginalExtension();
    $destinationPath = storage_path("app/public/{$folderName}");

    try {
        $fileinfo = @getimagesize($file); //$_FILES["{$inputVar}"]["tmp_name"]);
        $origWidth = $fileinfo[0];
        $origHeight = $fileinfo[1];
    }
    catch(Exception $e){
        $origWidth = $origHeight = null;
    }

    if (in_array(strtolower($ext), ["jpg", "jpeg", "png", "gif"])){
        //    removePrevPictures($obj, "picture_original", $destinationPath);

        try {
            if ($replace) {
                removePrevPictures($obj, "picture", $destinationPath);
//            removePrevPictures($obj, "thumb", $destinationPath);
                removePrevPictures($obj, "icon", $destinationPath);
            }

            $obj->picture = movePicture($file, $destinationPath, $fileName . '_pic.' . $ext, 1024);
            $obj->icon = movePicture($file, $destinationPath, $fileName . '_ic.' . $ext, 256);
        }
        catch(Exception $e){
            $obj->error = ($e->getCode() ? $e->getCode()." / " : ""). $e->getMessage();
        }

//        $obj->picture = resizeAndSaveImage($file, $fileName.'_ic.'.$ext, $destinationPath, 1024);
//        $obj->icon = resizeAndSaveImage($file, $fileName.'_ic.'.$ext, $destinationPath, 256);

        $obj->type = $ext;
        $obj->width = $origWidth;
        $obj->height = $origHeight;
        $obj->save();
    }
    elseif (in_array(strtolower($ext), ["pdf"])) {
        try {
            if ($replace) {
                removePrevPictures($obj, "file", $destinationPath);
            }

            $fileName .= "." . $ext;
            $file->move($destinationPath, $fileName);
        }
        catch(Exception $e){
            $obj->error = ($e->getCode() ? $e->getCode()." / " : ""). $e->getMessage();
        }

        $obj->file = $fileName;
        $obj->type = $ext;
        $obj->width = $origWidth;
        $obj->height = $origHeight;
        $obj->save();
    }


}

function resizeAndSaveImage($file, $fileNewName, $destinationPath, $width) {

//    $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
//    $file = $_FILES['image']['tmp_name'];
    $sourceProperties = @getimagesize($file);
//    $folderPath .= "/";
    $imageType = $sourceProperties[2];

    debug($file);
//    $file = $_FILES['img']['tmp_name'];

    switch ($imageType) {

        case IMAGETYPE_PNG:
            $imageResourceId = imagecreatefrompng($file);
            $targetLayer = imageResize($imageResourceId,$sourceProperties[0],$sourceProperties[1], $width);
            imagepng($targetLayer,$destinationPath. $fileNewName);
            break;

        case IMAGETYPE_GIF:
            $imageResourceId = imagecreatefromgif($file);
            $targetLayer = imageResize($imageResourceId,$sourceProperties[0],$sourceProperties[1], $width);
            imagegif($targetLayer,$destinationPath. $fileNewName);
            break;

        default:
        case IMAGETYPE_JPEG:
            $imageResourceId = imagecreatefromjpeg($file);
            $targetLayer = imageResize($imageResourceId,$sourceProperties[0],$sourceProperties[1], $width);
            imagejpeg($targetLayer,$destinationPath. $fileNewName);
            break;

//        default:
//            echo "Invalid Image type.";
//            exit;
//            break;
    }

    move_uploaded_file($file, $destinationPath. $fileNewName);

    return $fileNewName;
//    return $targetLayer;
}

function imageResize($imageResourceId, $width, $height, $targetWidth) {

    $targetHeight = $targetWidth * $height / $width;

    $targetLayer = imagecreatetruecolor($targetWidth,$targetHeight);
    imagecopyresampled($targetLayer,$imageResourceId,0,0,0,0, $targetWidth, $targetHeight, $width, $height);

    return $targetLayer;
}

function getApprovedCountryList(){
    $countries = \App\Models\Country::orderBy("country")
        ->whereIn("country", [
            "Tajikistan",
            "Kyrgyzstan",
            "Kazakhstan",
            "Russia",
            "Moldova",
            "Turkmenistan",
            "Armenia",
            "Azerbaijan",
            "Ukraine",
        ])
        ->pluck('country', 'id')
        ->all();

    return $countries;
}


function expiryStatus($expiryDate){
    $todayStrToTime = strtotime("today");
    $expiryStrToTime = strtotime($expiryDate);

    if ($todayStrToTime > $expiryStrToTime){
        return "<span class='color-red'>Expired</span>";
    }

    $diff = CalculateDifference(date("Y-m-d"), $expiryDate) / (60 * 24);

    return "Expires in ". ($diff == 1 ? "1 day" : $diff." days");

}

function getTitleAndIcon(){
    $airline = env("AIRLINE");
    if ($airline == GSRM)
    {
        $title = "GSRM";
        $ico = "gsrm.ico";
    }
    elseif ($airline == DHS){
        $title = "DHS";
        $ico = "eos-64.ico";
    }
    elseif ($airline == FRAAI)
    {
        $title = "Air India";
        $ico = "air_india.ico";
    }
    elseif ($airline == TAJIK_AIR)
    {
        $title = "Tajik Air";
        $ico = "tajikair.ico";
    }
    elseif ($airline == COASTAL){
        $title = "Coastal";
        $ico = "cq.ico";
    }
    elseif ($airline == AVIAM)
    {
        $title = "AVIAM";
        $ico = "aviam.ico";
    }
    else
    {
        $title = "AvBIS";
        $ico = "eos-64.ico";
    }

    return [$title, $ico];
}


function getScheduleTimings(){
    return [
        null    => UTC,
        1       => LOCAL,
    ];
}

function getTemplateTypes(){
    return [
        null => "Select",
        1    => "FLT No",
        2    => "Airline - FLT No",
    ];
}

function getPositionTypesList(){
    return [
        null                => STAFF_TYPE,
        CCM_PSR_TYPE_ID     => CCM_PSR_TYPE,
        CCM_CC_TYPE_ID      => CCM_CC_TYPE,
        FCM_CPT_TYPE_ID     => FCM_CPT_TYPE,
        FCM_FA_TYPE_ID      => FCM_FA_TYPE,

    ];
}

function getPositionType($type){

    $list = getPositionTypesList();

    if (isset($list[$type])){
        return $list[$type];
    }

    return STAFF_TYPE;
}

function getUserPosition($user){
    return $user->position && count($user->position) && isset($user->position[0]) ? $user->position[0] : null;
}

function getUserPositionName($user){
    return $user && $user->position && count($user->position) && isset($user->position[0]) ? $user->position[0]->name : "";
}

function getUserPositionType($user){
    if ($user && $user->position && isset($user->position[0]) && $user->position[0]){
        return $user->position[0]->type;
    }

    return null;
}

function parseMessage($message, $date = null, $skipDateRangeCheck = null){
    $MAX_EXECUTION_TIME = 60;

    ini_set("max_execution_time", $MAX_EXECUTION_TIME);
    ini_set('memory_limit', '128M');

    $parseOperations = new \App\Classes\Parsing\ParseOperations($date, null, null, null, $skipDateRangeCheck);
    $result = $parseOperations->run($message);

    if ($result && array_key_exists("parsed", $result)){
        return $result["parsed"];
    }

    return false;
}


function getIntValueOrNull($string){
    return $string && is_numeric($string) ? intval($string) : null;
}

function parseMessageOperation($type, $date = null){
    $MAX_EXECUTION_TIME = 60;

    ini_set("max_execution_time", $MAX_EXECUTION_TIME);
    ini_set('memory_limit', '512M');

    $parseOperations = new \App\Classes\Parsing\ParseMessagesOperations(null,null,null,null,true);
    $result = $parseOperations->preRun($type, $date, null, true);

    if ($result && array_key_exists("parsed", $result)){
        return $result["parsed"];
    }

    return false;
}


function getMessageTypes(){
    $types = [
        CPM,
        UCM,
        LOADSHEET,
        LOADSHEET_FINAL,
        LDM,
        PSM,
        PTM,
        LPM,
        TPM,
        FAG,
        ONLOAD,
        NOT,
        NOTOC,
        COMRO,
        COM,
        WAB,
        TXT_ING,
        PNL,
        PRL,
        ADL,
        SLS,
        HBG,
        CREW_LIST,

        LIR,
        CAL,
        PAL,
    ];

    return $types;
}


function getConfigFromText(&$data, $index){
    if (!$data[$index] || !$cap = (int) filter_var($data[$index], FILTER_SANITIZE_NUMBER_INT)){
        unset($data[$index]);
        return;
    }
    $found = false;
    debug($data[$index]);
    if (contains($data[$index], "C") || contains($data[$index],"J")){
        $data["capacityC"] = $cap;
        $found = true;
    }
    if (contains($data[$index], "Y") || contains($data[$index], "B") || contains($data[$index],"M")){
        $data["capacityY"] = $cap;
        $found = true;
    }

    if ($found){
        unset($data[$index]);
    }

    return;
}

function contains($str, $needleStrOrArr)
{
    if (is_array($needleStrOrArr)){
        foreach($needleStrOrArr as $a) {
            if (stripos($str,$a) !== false) return true;
        }
        return false;
    }

    return str_contains($str, $needleStrOrArr);
}


function getUserStatuses(){
    return [
        ACTIVATED   => ACTIVATED,
        DEACTIVATED => DEACTIVATED,
        DELETED     => DELETED,
        ""          => ALL,
    ];
}

function getPageViewClassNameAndID($module, $url){
    if (!in_array($module, [FLIGHT_WATCH, FLIGHT_COM])){
        return [
            null,
            null,
        ];
    }

    preg_match('/.*\/(\d+)/', $url, $match);
    switch ($module){
        case FLIGHT_WATCH:
        case FLIGHT_COM:
            $model = FLIGHT_MODEL_NAME;
            break;

        default:
            $model = null;
            break;
    }

    return [
        $model,
        isset($match[1]) && $match[1] ? $match[1] : null,
    ];
}

function getPageViewUrl($pageView){
    switch ($pageView->module){
        case FLIGHT_WATCH:
            return $pageView->class_id ? "flight-tracker/" . $pageView->class_id : "flight-watch";

        case FLIGHT_COM:
            return $pageView->class_id ? "flight-com/flight/"  . $pageView->class_id : "flight-com";

        default:
            return route("homepage")."#".$pageView->module_url;
    }
}

function getAuditProp($prop, $oldValues = false){
    if ($oldValues){
        if ($prop == "edited_by_email"){
            return "Edited by Manual Message Entry"; //strtoupper(str_replace("_", " ", $prop)).' <span class="glyphicon glyphicon-check"></span>';
        }
    }
    else {
        if ($prop == "edited_by_email"){
            return "";
        }
    }
    return strtoupper(str_replace("_", " ", $prop)).": ";
}
function getAuditValue($prop, $val, $newValues = false){
    if ($newValues){
        if ($prop == "edited_by_email"){
            return "";
        }
    }


    if (in_array($prop, [STD, PTD, ETD, ATD, ABN,  STA, PTA, ETA, TDN, ATA])){
        return baseDateFormat($val, true, "-");
    }
//    elseif (in_array($prop, [PLANNED_REPORT_TIME, PLANNED_RELEASE_TIME, REPORT_TIME, RELEASE_TIME])){
//        return baseDateFormat($val, true, "-");
//    }
    elseif (is_bool($val)){
        return $val == true ? "True" : "False";
    }
    elseif (in_array($prop, ["include_all_stations", "service_timings", "departure_service", "arrival_service"])){
        return $val == true ? "True" : "False";
    }
    elseif (in_array($prop, [ISSUE_DATE, EXPIRY_DATE, CONDITION_FROM, CONDITION_TO])){
        return baseDateFormat($val, false, "-");
    }

    return $val;
}

function localToUTC($airportTimezones, $airportID, $datetime){
    if (!$airportID || !isset($airportTimezones[$airportID]) || !$airportTimezones[$airportID]){
        debug("ERR: ". $airportID);
        return $datetime;
    }

    $timezone = $airportTimezones[$airportID];
    $utcDateTime = getLocalDateTime($datetime, "UTC", "Y-m-d H:i:s", $timezone);
    // $utcTime = date("H:i:s", strtotime($utcDateTime));

    return $utcDateTime;
}

function isSunday($date) {
    return (date('N', strtotime($date)) == 7);
}

function isWeekend($date) {
    return (date('N', strtotime($date)) >= 6);
}

function utcToLocal($airportTimezones, $airportID, $datetime){
    if (!$airportID || !isset($airportTimezones[$airportID]) || !$airportTimezones[$airportID]){
        return $datetime;
    }

    $timezone = $airportTimezones[$airportID];
    $localDateTime = getLocalDateTime($datetime, $timezone, "Y-m-d H:i:s","UTC");

    return $localDateTime;
}

function convertUtcToLocal($datetime, $timezone = null, $fromTimezone = "UTC"){
    if (!$timezone){
        return $datetime;
    }

    return getLocalDateTime($datetime, $timezone, "Y-m-d H:i:s", $fromTimezone);
}


function getNotificationType($notification){
    switch ($notification->type){
        default:
            return "";

        case "App\Notifications\ReadAndSignNotification":
            return "Read and sign document";
    }
}

/*
 * so if the flight has AD and AC Reg - then if AA comes with different AC Reg - system should not update AC Reg
 */
function skipMVTArrMessage($flight, $mvtArrAircraft, $ata){
    if (!$flight){
        return false;
    }

    if (!$flight->aircraft_id || !$flight->atd || $flight->atd == EMPTY_DATETIME){
        return false;
    }

    if ($mvtArrAircraft && $flight->aircraft_id != $mvtArrAircraft->id){
        return true;
    }

    if (strtotime($flight->atd) >= strtotime($ata)){
        return true;
    }

    return false;
}

function skipMVTDepMessage($flight, $mvtDepAircraft, $atd){
    if (!$flight){
        return false;
    }

    if (!$flight->aircraft_id || !$flight->atd || $flight->atd == EMPTY_DATETIME
        || !$flight->ata || $flight->ata == EMPTY_DATETIME){
        return false;
    }

    if ($mvtDepAircraft && $flight->aircraft_id != $mvtDepAircraft->id){
        return true;
    }

    if ($flight->ata && $flight->ata != EMPTY_DATETIME
        && $atd && $atd != EMPTY_DATETIME
        && strtotime($flight->ata) < strtotime($atd))
    {
        return true;
    }

    return false;
}

function getLicenseTypes($includeEmpty = true){
    $handling = env(AIRLINE);

    $types = [];

    if ($includeEmpty){
        $types[""] = "Select";
    }

    $types[STAFF_AIRLINE_LICENSE] = "Airline";
    $types[STAFF_AIRPORT_LICENSE] = "Airport";
    $types[$handling] = $handling;

    if (airlineModule()) {
        $types[FCM_LICENSE] = "Flight Crew";
        $types[CCM_LICENSE] = "Cabin Crew";
    }

    $types[OTHERS_LICENSE] = "Others";

    return $types;
}

function getAirportOrCreate($code, $createFrom = "icao"){
    if (!$code || !trim($code)){
        return null;
    }

    $record = \App\Models\Airport::where("icao", $code)
                                ->first();

    if ($record){
        return $record;
    }

    $record = \App\Models\Airport::where("iata", $code)
                                ->first();

    if ($record){
        return $record;
    }

    return \App\Models\Airport::create([
        $createFrom => $code,
    ]);
}

function getCeoUser(){
    $user = \auth()->user();
    if (!$user){
        return null;
    }

    $position = Position::whereIn("name", [
        "CEO",
        "Managing Director",
        "Chief Operating Officer",
    ])->first();

    if (!$position){
        return null;
    }

    return \App\Models\User::join("users__departments", "users__departments.user_id", "=", "users.id")
                    ->where("position_id", $position->id)
                    ->whereNull("users.deleted_at")
                    ->whereNull("users__departments.deleted_at")
                    ->first("users.*");
}

function isCeo(){
    $user = \auth()->user();
    if (!$user){
        return false;
    }

    $position = getUserPosition($user);

    if (!$position){
        return false;
    }

    return $position->name == "CEO" || $position->name == "Managing Director" || $position->name == "Chief Operating Officer";

}