<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */

use App\Models\User;
use App\Repositories\Interfaces\IOrganizationRepository;
use App\Repositories\Interfaces\IUserRepository;
use Illuminate\Support\Facades\Auth;

class UserRepository extends Repository implements IUserRepository {


    protected $modelClassName = 'User';

    public function __construct(User $user)
    {
        $this->model = $user;
    }
    public function getAllUsers()
    {
        return $this->user->all();
    }

    public function findByUserName($email)
    {
        $where = call_user_func(__NAMESPACE__MODEL."{$this->modelClassName}::where", array($email));
        return $where->get();
    }

    public function getAuthUserId(){
        return Auth::check() ? Auth::user()->id : false;
    }

    public static function getCeoUserId($userDepartmentRepository){
        $user = $userDepartmentRepository->findByAttributes(['p.name' => 'Chief Executive'], [], ['user_id AS id'], [
            'structure__positions AS p', 'p.id', '=', 'users__departments.position_id'
        ]);

        return $user ? $user->id : null;
    }

    public static function getUserFullInformation($userId)
    {
        if ($userId) {
            return User::with('userFamily')->select([
                "users.id",
                "users.first_name",
                "users.last_name",
                "users.is_contractor",
                "users.marital_status_id",
                "users.email",
                "users.dob",
                "users.staff_number",
                "users.resigned_date",
//                "users.languages",
                "users.location_id",
//                "users.phone",
                "users.doj",
                "users.passport_num",
                "users.passport_doi",
                "users.passport_dex",
                "users.pob_country_id",
                "users.nationality_id",
                "users.idcard_number",
                "users.idcard_expiry",
                "users.picture",
                "users.thumb",
                "users.activated",
                "users.user_role_id",
                "users__departments.department_id AS department_id",
                "users__departments.subdepartment_id AS subdepartment_id",
                "users__departments.position_id AS position_id",
                "structure__departments.name AS department_name",
                "structure__subdepartments.name AS subdepartment_name",
                "structure__positions.name AS position_title",
                "structure__departments.has_subdepartment AS has_subdepartment"
            ])
                ->join("users__departments", "users.id", "=", "users__departments.user_id")
                ->join("structure__departments", "users__departments.department_id", "=", "structure__departments.id", "left")
                ->join("structure__positions", "users__departments.position_id", "=", "structure__positions.id", "left")
                ->join("structure__subdepartments", "users__departments.subdepartment_id", "=", "structure__subdepartments.id", "left")
                ->findOrFail($userId);
        }
        return false;
    }


    public static function hasUserReportees($user_id, IOrganizationRepository $organizationRepository){
        $findOrganization = $organizationRepository->findByAttributes(['report_to_user_id' => $user_id]);

        if ($findOrganization)
            return true;

        return false;
    }
}
