<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\UserLanguage;
use App\Repositories\Interfaces\IUserLanguageRepository;

class UserLanguageRepository extends Repository implements IUserLanguageRepository {

    protected $modelClassName = 'UserLanguage';

    public function __construct(UserLanguage $model)
    {
        $this->model = $model;
    }

    public function listLanguages($userId = FALSE){

        $result = $this->model->select('languages.language', 'languages.id AS id')
                        ->join('languages', 'languages.id', '=','users__languages.language_id');

        if ($userId){
            $userId = is_array($userId) ? $userId : [$userId];
            $result->whereIn('user_id', $userId);
        }

        return $result->pluck('language', 'id')->all();
    }
}
