<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */
use App\Models\UserHistory;
use App\Repositories\Interfaces\IUserHistoryRepository;

class UserHistoryRepository extends Repository implements IUserHistoryRepository {

    protected $modelClassName = 'UserHistory';

    public function __construct(UserHistory $model)
    {
        $this->model = $model;
    }

    public function getCrewConditions($crewType = FCM_CREW, $conditionType = FALSE){

        $table = $crewType == FCM_CREW ? 'crew__flight' : 'crew__cabin';

        $result = $this->model->join($table, "{$table}.user_id", '=', 'users__history.user_id')
            ->join('users', "{$table}.user_id", '=', 'users.id')
            ->join('users__departments', "{$table}.user_id", '=', 'users__departments.user_id')
            ->join('structure__positions', "users__departments.position_id", '=', 'structure__positions.id')
            ->join('conditions', "users__history.condition_id", '=', 'conditions.id');

        if ($conditionType)
            $result->where('conditions.name', $conditionType);

        return $result->get([
            'users.id AS user_id',
            "{$table}.id AS crew_id",
            "users.first_name",
            "users.last_name",
            "users.thumb",
            "condition_from",
            "condition_to",
            "duty_from",
            "duty_to",
            "position_id",
            "structure__positions.name AS position_name"
        ]);
    }
}
