<?php namespace App\Repositories;

/**
 * Created by PhpStorm.

 */

use App\Models\SubDepartment;
use App\Models\UserDepartment;
use App\Repositories\Interfaces\ISubDepartmentRepository;

class SubDepartmentRepository extends Repository implements ISubDepartmentRepository {


    protected $modelClassName = 'SubDepartment';

    public function __construct(SubDepartment $model, UserDepartment $userDepartment)
    {
        $this->model = $model;
        $this->userDepartment = $userDepartment;
    }

    public function findUserSubDepartmentByUserId($userId)
    {
        if ($userId) {
            $where =  $this->userDepartment->where('user_id', $userId);
            return $where->first();
        }
        return false;
    }

    public function findUserSubDepartmentOrCreate($attributes){
        return $this->userDepartment->firstOrCreate($attributes);
    }

    public function updateUserSubDepartmentByUserId($userId, $attributes){
        return $this->userDepartment->where('user_id', $userId)->update($attributes);
    }

    public function findAndListSubDepartment($searchAttr, $lists, $selectOptionValue = false){
        $result = $this->model;
        foreach ($searchAttr as $attr => $value) {
            if (is_null($value))
                $result = $result->whereNull($attr);
            else
                $result = $result->where($attr, $value);
        }
        $result = $result->pluck($lists['val'], $lists['key'])->all();
        return $selectOptionValue ? [$selectOptionValue => "Select"] + $result : $result;
    }


}
